/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.support;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.CloseableClient;

public class MemorizingClientSupplier<T extends CloseableClient>
implements Supplier<T>,
CloseableClient {
    final Supplier<T> delegate;
    volatile transient boolean initialized;
    transient T value;

    public MemorizingClientSupplier(Supplier<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            MemorizingClientSupplier memorizingClientSupplier = this;
            synchronized (memorizingClientSupplier) {
                if (!this.initialized) {
                    CloseableClient t = (CloseableClient)this.delegate.get();
                    this.value = t;
                    this.initialized = true;
                    return (T)t;
                }
            }
        }
        return this.value;
    }

    public String toString() {
        return "Suppliers.memoize(" + (this.initialized ? "<supplier that returned " + this.value + ">" : this.delegate) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.initialized) {
            MemorizingClientSupplier memorizingClientSupplier = this;
            synchronized (memorizingClientSupplier) {
                if (this.initialized) {
                    if (this.value != null) {
                        this.value.close();
                        this.value = null;
                    }
                    this.initialized = false;
                }
            }
        }
    }
}

