/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.io.Serializable;
import java.net.ConnectException;
import java.util.Base64;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.KyuubiSyncThriftClient;
import org.apache.kyuubi.client.KyuubiSyncThriftClient$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.EngineRef;
import org.apache.kyuubi.engine.KyuubiApplicationManager$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.package$;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetInfoType;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.sql.plan.KyuubiTreeNode;
import org.apache.kyuubi.sql.plan.command.RunnableCommand;
import org.apache.kyuubi.util.SignUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001\u0002\"D\u00011C\u0011\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u00151\t\u0013\r\u0004!\u0011!Q\u0001\n\u0011\f\b\"\u0003:\u0001\u0005\u0003\u0005\u000b\u0011\u00023t\u0011%!\bA!A!\u0002\u0013!W\u000fC\u0005w\u0001\t\u0005\t\u0015!\u0003xu\"I1\u0010\u0001B\u0001B\u0003%Ap \u0005\u000b\u0003\u0003\u0001!\u0011!Q\u0001\n\u0005\r\u0001BCA\b\u0001\t\u0005\t\u0015!\u0003\u0002\u0012!Q\u0011\u0011\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0007\t\u000f\u00055\u0002\u0001\"\u0001\u00020!I\u0011Q\t\u0001C\u0002\u0013\u0005\u0013q\t\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002J!Q\u0011\u0011\u000e\u0001C\u0002\u0013\u0005Q)a\u001b\t\u000f\u00055\u0004\u0001)A\u0005o\"Q\u0011q\u000e\u0001\t\u0006\u0004%I!!\u001d\t\u0015\u0005M\u0004\u0001#b\u0001\n\u0003\t)\b\u0003\u0006\u0002\u0002\u0002\u0011\r\u0011\"\u0001F\u0003\u0007C\u0001\"!%\u0001A\u0003%\u0011Q\u0011\u0005\u000b\u0003'\u0003\u0001R1A\u0005\n\u0005E\u0004\"CAK\u0001\t\u0007I\u0011BAL\u0011!\t)\u000b\u0001Q\u0001\n\u0005e\u0005bBAT\u0001\u0011\u0005\u0013\u0011\u0016\u0005\b\u0003c\u0003A\u0011IAZ\u0011-\tY\f\u0001a\u0001\u0002\u0004%I!!0\t\u0017\u0005-\u0007\u00011AA\u0002\u0013%\u0011Q\u001a\u0005\f\u0003'\u0004\u0001\u0019!A!B\u0013\ty\fC\u0004\u0002F\u0002!\t!!0\t\u0017\u0005u\u0007\u00011AA\u0002\u0013%\u0011q\u001c\u0005\f\u0003O\u0004\u0001\u0019!a\u0001\n\u0013\tI\u000fC\u0006\u0002n\u0002\u0001\r\u0011!Q!\n\u0005\u0005\b\"CAy\u0001\u0001\u0007I\u0011BAz\u0011%\u0011I\u0001\u0001a\u0001\n\u0013\u0011Y\u0001\u0003\u0005\u0003\u0010\u0001\u0001\u000b\u0015BA{\u0011\u001d\u0011\u0019\u0002\u0001C!\u0003gCqA!\u0006\u0001\t\u0003\u00119\u0002\u0003\u0005\u0003*\u0001!\t!\u0012B\u0016\u0011)\u0011y\u0004AI\u0001\n\u0003)%\u0011\t\u0005\b\u0005/\u0002A\u0011\u000bB-\u0011%\u0011\u0019\u0007\u0001a\u0001\n\u0013\u0011)\u0007C\u0005\u0003h\u0001\u0001\r\u0011\"\u0003\u0003j!A!Q\u000e\u0001!B\u0013\t\t\u0002C\u0004\u0003r\u0001!I!a-\t\u000f\tM\u0004\u0001\"\u0003\u0003v!9!q\u000f\u0001\u0005B\u0005M\u0006b\u0002B=\u0001\u0011\u0005#1\u0010\u0005\b\u0005\u001b\u0003A\u0011\tBH\u0011-\u00119\u000b\u0001a\u0001\u0002\u0004%IA!+\t\u0017\t-\u0006\u00011AA\u0002\u0013%!Q\u0016\u0005\f\u0005c\u0003\u0001\u0019!A!B\u0013\u0011\t\u000bC\u0005\u00036\u0002\u0011\r\u0011\"\u0003\u0003*\"A!q\u0017\u0001!\u0002\u0013\u0011\t\u000bC\u0005\u0003:\u0002\u0011\r\u0011\"\u0003\u0003f!A!1\u0018\u0001!\u0002\u0013\t\t\u0002C\u0005\u0003>\u0002\u0011\r\u0011\"\u0003\u0003@\"A!q\u0019\u0001!\u0002\u0013\u0011\t\rC\u0005\u0003J\u0002\u0001\r\u0011\"\u0003\u0003@\"I!1\u001a\u0001A\u0002\u0013%!Q\u001a\u0005\t\u0005#\u0004\u0001\u0015)\u0003\u0003B\"9!Q\u001b\u0001\u0005\u0002\t]\u0007\"\u0004Bm\u0001A\u0005\u0019\u0011!A\u0005\n\u0005E\u0014\u000f\u0003\b\u0003\\\u0002\u0001\n1!A\u0001\n\u0013\t\u0019L!8\t\u001b\t}\u0007\u0001%A\u0002\u0002\u0003%IA!9\u0000\u00115\u0011I\u000f\u0001I\u0001\u0004\u0003\u0005I\u0011BA9g\"i!1\u001e\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0003n\u0002DaBa<\u0001!\u0003\r\t\u0011!C\u0005\u0005c\u0014YPA\tLsV,(-[*fgNLwN\\%na2T!\u0001R#\u0002\u000fM,7o]5p]*\u0011aiR\u0001\u0007Wf,XOY5\u000b\u0005!K\u0015AB1qC\u000eDWMC\u0001K\u0003\ry'oZ\u0002\u0001'\t\u0001Q\n\u0005\u0002O\u001f6\t1)\u0003\u0002Q\u0007\ni1*_;vE&\u001cVm]:j_:\f\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0003'zk\u0011\u0001\u0016\u0006\u0003+Z\u000ba\u0001\u001e5sS\u001a$(BA,Y\u0003\r\u0011\bo\u0019\u0006\u00033j\u000bqa]3sm&\u001cWM\u0003\u0002\\9\u0006!\u0001.\u001b<f\u0015\tiV)\u0001\u0004tQ\u0006$W\rZ\u0005\u0003?R\u0013\u0001\u0003\u0016)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\n\u0005E\u000b\u0017B\u00012D\u0005=\t%m\u001d;sC\u000e$8+Z:tS>t\u0017\u0001B;tKJ\u0004\"!\u001a8\u000f\u0005\u0019d\u0007CA4k\u001b\u0005A'BA5L\u0003\u0019a$o\\8u})\t1.A\u0003tG\u0006d\u0017-\u0003\u0002nU\u00061\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\ti'.\u0003\u0002dC\u0006A\u0001/Y:to>\u0014H-\u0003\u0002sC\u0006I\u0011\u000e]!eIJ,7o]\u0005\u0003i\u0006\fAaY8oMB!Q\r\u001f3e\u0013\tI\bOA\u0002NCBL!A^1\u0002\u001dM,7o]5p]6\u000bg.Y4feB\u0011a*`\u0005\u0003}\u000e\u0013AcS=vk\nL7+Z:tS>tW*\u00198bO\u0016\u0014\u0018BA>b\u0003-\u0019Xm]:j_:\u001cuN\u001c4\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003F\u0003\u0019\u0019wN\u001c4jO&!\u0011QBA\u0004\u0005)Y\u00150^;cS\u000e{gNZ\u0001\fI>\f5/\u00128bE2,G\r\u0005\u0003\u0002\u0014\u0005UQ\"\u00016\n\u0007\u0005]!NA\u0004C_>dW-\u00198\u0002\rA\f'o]3s!\u0011\ti\"!\u000b\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\taa]3sm\u0016\u0014(\u0002BA\r\u0003KQ1!a\nF\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003W\tyB\u0001\u0007LsV,(-\u001b)beN,'/\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003c\t\u0019$!\u000e\u00028\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0011\u00059\u0003\u0001\"B)\u000b\u0001\u0004\u0011\u0006\"B2\u000b\u0001\u0004!\u0007\"\u0002:\u000b\u0001\u0004!\u0007\"\u0002;\u000b\u0001\u0004!\u0007\"\u0002<\u000b\u0001\u00049\b\"B>\u000b\u0001\u0004a\bbBA\u0001\u0015\u0001\u0007\u00111\u0001\u0005\b\u0003\u001fQ\u0001\u0019AA\t\u0011\u001d\tIB\u0003a\u0001\u00037\t1b]3tg&|g\u000eV=qKV\u0011\u0011\u0011\n\t\u0005\u0003\u0017\n\tG\u0004\u0003\u0002N\u0005uc\u0002BA(\u00037rA!!\u0015\u0002Z9!\u00111KA,\u001d\r9\u0017QK\u0005\u0002\u0015&\u0011\u0001*S\u0005\u0003\r\u001eK!\u0001R#\n\u0007\u0005}3)A\u0006TKN\u001c\u0018n\u001c8UsB,\u0017\u0002BA2\u0003K\u00121bU3tg&|g\u000eV=qK*\u0019\u0011qL\"\u0002\u0019M,7o]5p]RK\b/\u001a\u0011\u0002\u001b=\u0004H/[7ju\u0016$7i\u001c8g+\u00059\u0018AD8qi&l\u0017N_3e\u0007>tg\rI\u0001\u0012K:<\u0017N\\3De\u0016$WM\u001c;jC2\u001cX#\u00013\u0002\r\u0015tw-\u001b8f+\t\t9\b\u0005\u0003\u0002z\u0005uTBAA>\u0015\r\t\u0019(R\u0005\u0005\u0003\u007f\nYHA\u0005F]\u001eLg.\u001a*fM\u0006qA.Y;oG\",enZ5oK>\u0003XCAAC!\u0011\t9)!$\u000e\u0005\u0005%%bAAF\u000b\u0006Iq\u000e]3sCRLwN\\\u0005\u0005\u0003\u001f\u000bIIA\u0005Pa\u0016\u0014\u0018\r^5p]\u0006yA.Y;oG\",enZ5oK>\u0003\b%A\u000btKN\u001c\u0018n\u001c8Vg\u0016\u00148+[4o\u0005\u0006\u001cXM\u000e\u001b\u0002\u0019M,7o]5p]\u00163XM\u001c;\u0016\u0005\u0005e\u0005\u0003BAN\u0003Ck!!!(\u000b\u0007\u0005}U)\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003G\u000biJ\u0001\nLsV,(-[*fgNLwN\\#wK:$\u0018!D:fgNLwN\\#wK:$\b%A\bhKR\u001cVm]:j_:,e/\u001a8u+\t\tY\u000b\u0005\u0004\u0002\u0014\u00055\u0016\u0011T\u0005\u0004\u0003_S'AB(qi&|g.\u0001\u000edQ\u0016\u001c7nU3tg&|g.Q2dKN\u001c\b+\u0019;i+JK5\u000f\u0006\u0002\u00026B!\u00111CA\\\u0013\r\tIL\u001b\u0002\u0005+:LG/A\u0004`G2LWM\u001c;\u0016\u0005\u0005}\u0006\u0003BAa\u0003\u000fl!!a1\u000b\u0007\u0005\u0015W)\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003\u0013\f\u0019M\u0001\fLsV,(-[*z]\u000e$\u0006N]5gi\u000ec\u0017.\u001a8u\u0003-y6\r\\5f]R|F%Z9\u0015\t\u0005U\u0016q\u001a\u0005\n\u0003#L\u0012\u0011!a\u0001\u0003\u007f\u000b1\u0001\u001f\u00132\u0003!y6\r\\5f]R\u0004\u0003f\u0001\u000e\u0002XB!\u00111CAm\u0013\r\tYN\u001b\u0002\tm>d\u0017\r^5mK\u0006!r,\u001a8hS:,7+Z:tS>t\u0007*\u00198eY\u0016,\"!!9\u0011\u00079\u000b\u0019/C\u0002\u0002f\u000e\u0013QbU3tg&|g\u000eS1oI2,\u0017\u0001G0f]\u001eLg.Z*fgNLwN\u001c%b]\u0012dWm\u0018\u0013fcR!\u0011QWAv\u0011%\t\t.HA\u0001\u0002\u0004\t\t/A\u000b`K:<\u0017N\\3TKN\u001c\u0018n\u001c8IC:$G.\u001a\u0011)\u0007y\t9.\u0001\tpa\u0016t7+Z:tS>tWI\u001d:peV\u0011\u0011Q\u001f\t\u0007\u0003'\ti+a>\u0011\t\u0005e(1\u0001\b\u0005\u0003w\fyPD\u0002h\u0003{L\u0011a[\u0005\u0004\u0005\u0003Q\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005\u000b\u00119AA\u0005UQJ|w/\u00192mK*\u0019!\u0011\u00016\u0002)=\u0004XM\\*fgNLwN\\#se>\u0014x\fJ3r)\u0011\t)L!\u0004\t\u0013\u0005E\u0007%!AA\u0002\u0005U\u0018!E8qK:\u001cVm]:j_:,%O]8sA!\u001a\u0011%a6\u0002\t=\u0004XM\\\u0001\u000eO\u0016$XI\\4j]\u0016tu\u000eZ3\u0016\u0005\te\u0001CBA\n\u0003[\u0013Y\u0002\u0005\u0003\u0003\u001e\t\u0015RB\u0001B\u0010\u0015\u0011\t)M!\t\u000b\u0007\t\rR)\u0001\u0002iC&!!q\u0005B\u0010\u0005=\u0019VM\u001d<jG\u0016tu\u000eZ3J]\u001a|\u0017!E8qK:,enZ5oKN+7o]5p]R!\u0011Q\u0017B\u0017\u0011%\u0011y\u0003\nI\u0001\u0002\u0004\u0011\t$\u0001\bfqR\u0014\u0018-\u00128hS:,Gj\\4\u0011\r\u0005M\u0011Q\u0016B\u001a!\u0011\u0011)Da\u000f\u000e\u0005\t]\"\u0002\u0002B\u001d\u0003\u0013\u000b1\u0001\\8h\u0013\u0011\u0011iDa\u000e\u0003\u0019=\u0003XM]1uS>tGj\\4\u00027=\u0004XM\\#oO&tWmU3tg&|g\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019E\u000b\u0003\u00032\t\u00153F\u0001B$!\u0011\u0011IEa\u0015\u000e\u0005\t-#\u0002\u0002B'\u0005\u001f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tE#.\u0001\u0006b]:|G/\u0019;j_:LAA!\u0016\u0003L\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0019I,hn\u00149fe\u0006$\u0018n\u001c8\u0015\t\tm#\u0011\r\t\u0005\u0003\u000f\u0013i&\u0003\u0003\u0003`\u0005%%aD(qKJ\fG/[8o\u0011\u0006tG\r\\3\t\u000f\u0005-e\u00051\u0001\u0002\u0006\u0006qQM\\4j]\u0016d\u0015-\u001e8dQ\u0016$WCAA\t\u0003I)gnZ5oK2\u000bWO\\2iK\u0012|F%Z9\u0015\t\u0005U&1\u000e\u0005\n\u0003#D\u0013\u0011!a\u0001\u0003#\tq\"\u001a8hS:,G*Y;oG\",G\r\t\u0015\u0004S\u0005]\u0017!F<bSR4uN]#oO&tW\rT1v]\u000eDW\rZ\u0001\u0017e\u0016tWm^#oO&tWm\u0011:fI\u0016tG/[1mgR\tA-A\u0003dY>\u001cX-A\u0004hKRLeNZ8\u0015\t\tu$1\u0011\t\u0004'\n}\u0014b\u0001BA)\niAkR3u\u0013:4wNV1mk\u0016DqA!\".\u0001\u0004\u00119)\u0001\u0005j]\u001a|G+\u001f9f!\r\u0019&\u0011R\u0005\u0004\u0005\u0017#&\u0001\u0004+HKRLeNZ8UsB,\u0017\u0001E3yK\u000e,H/Z*uCR,W.\u001a8u))\u0011YF!%\u0003\u0016\ne%Q\u0014\u0005\u0007\u0005's\u0003\u0019\u00013\u0002\u0013M$\u0018\r^3nK:$\bB\u0002BL]\u0001\u0007q/A\u0006d_:4wJ^3sY\u0006L\bb\u0002BN]\u0001\u0007\u0011\u0011C\u0001\teVt\u0017i]=oG\"9!q\u0014\u0018A\u0002\t\u0005\u0016\u0001D9vKJLH+[7f_V$\b\u0003BA\n\u0005GK1A!*k\u0005\u0011auN\\4\u0002\u001f\u0015tw-\u001b8f\u0019\u0006\u001cH/\u00117jm\u0016,\"A!)\u0002'\u0015tw-\u001b8f\u0019\u0006\u001cH/\u00117jm\u0016|F%Z9\u0015\t\u0005U&q\u0016\u0005\n\u0003#\u0004\u0014\u0011!a\u0001\u0005C\u000b\u0001#\u001a8hS:,G*Y:u\u00032Lg/\u001a\u0011)\u0007E\n9.\u0001\nf]\u001eLg.Z!mSZ,G+[7f_V$\u0018aE3oO&tW-\u00117jm\u0016$\u0016.\\3pkR\u0004\u0013!E1mSZ,\u0007K]8cK\u0016s\u0017M\u00197fI\u0006\u0011\u0012\r\\5wKB\u0013xNY3F]\u0006\u0014G.\u001a3!\u0003])gnZ5oK\u0006c\u0017N^3NCb4\u0015-\u001b7D_VtG/\u0006\u0002\u0003BB!\u00111\u0003Bb\u0013\r\u0011)M\u001b\u0002\u0004\u0013:$\u0018\u0001G3oO&tW-\u00117jm\u0016l\u0015\r\u001f$bS2\u001cu.\u001e8uA\u0005!RM\\4j]\u0016\fE.\u001b<f\r\u0006LGnQ8v]R\f\u0001$\u001a8hS:,\u0017\t\\5wK\u001a\u000b\u0017\u000e\\\"pk:$x\fJ3r)\u0011\t)La4\t\u0013\u0005E\u0017(!AA\u0002\t\u0005\u0017!F3oO&tW-\u00117jm\u00164\u0015-\u001b7D_VtG\u000f\t\u0015\u0004u\u0005]\u0017AG2iK\u000e\\WI\\4j]\u0016\u001cuN\u001c8fGRLwN\\!mSZ,GCAA\t\u0003)\u0019X\u000f]3sIU\u001cXM]\u0001\u000bgV\u0004XM\u001d\u0013pa\u0016t\u0017b\u0001B\nC\u0006!2/\u001e9fe\u0012\u001aXm]:j_:l\u0015M\\1hKJ,\"Aa9\u0011\u00079\u0013)/C\u0002\u0003h\u000e\u0013abU3tg&|g.T1oC\u001e,'/\u0001\btkB,'\u000f\n9bgN<xN\u001d3\u0002\u001dM,\b/\u001a:%aJ|Go\\2pYV\t!+\u0001\ftkB,'\u000fJ3yK\u000e,H/Z*uCR,W.\u001a8u))\u0011YFa=\u0003v\n](\u0011 \u0005\u0007\u0005'\u000b\u0005\u0019\u00013\t\r\t]\u0015\t1\u0001x\u0011\u001d\u0011Y*\u0011a\u0001\u0003#AqAa(B\u0001\u0004\u0011\t+C\u0002\u0003\u000e\u0006\u0004")
public class KyuubiSessionImpl
extends KyuubiSession {
    private String engineCredentials;
    private EngineRef engine;
    private String sessionUserSignBase64;
    private final KyuubiConf sessionConf;
    private final boolean doAsEnabled;
    private final KyuubiParser parser;
    private final Enumeration.Value sessionType;
    private final scala.collection.immutable.Map<String, String> optimizedConf;
    private final Operation launchEngineOp;
    private final KyuubiSessionEvent sessionEvent;
    private volatile KyuubiSyncThriftClient _client;
    private volatile SessionHandle _engineSessionHandle;
    private volatile Option<Throwable> openSessionError;
    private volatile boolean engineLaunched;
    private volatile long engineLastAlive;
    private final long engineAliveTimeout;
    private final boolean aliveProbeEnabled;
    private final int engineAliveMaxFailCount;
    private volatile int engineAliveFailCount;
    private volatile byte bitmap$0;

    private /* synthetic */ String super$user() {
        return super.user();
    }

    private /* synthetic */ void super$open() {
        super.open();
    }

    private /* synthetic */ SessionManager super$sessionManager() {
        return super.sessionManager();
    }

    private /* synthetic */ String super$password() {
        return super.password();
    }

    private /* synthetic */ TProtocolVersion super$protocol() {
        return super.protocol();
    }

    private /* synthetic */ OperationHandle super$executeStatement(String statement, scala.collection.immutable.Map confOverlay, boolean runAsync, long queryTimeout) {
        return super.executeStatement(statement, confOverlay, runAsync, queryTimeout);
    }

    @Override
    public Enumeration.Value sessionType() {
        return this.sessionType;
    }

    public scala.collection.immutable.Map<String, String> optimizedConf() {
        return this.optimizedConf;
    }

    private String engineCredentials$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.engineCredentials = this.renewEngineCredentials();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.engineCredentials;
    }

    private String engineCredentials() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.engineCredentials$lzycompute();
        }
        return this.engineCredentials;
    }

    private EngineRef engine$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.engine = new EngineRef(this.sessionConf, super.user(), this.doAsEnabled, ((KyuubiSessionManager)super.sessionManager()).groupProvider(), this.handle().identifier().toString(), ((KyuubiSessionManager)super.sessionManager()).applicationManager(), ((KyuubiSessionManager)super.sessionManager()).engineStartupProcessSemaphore());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.engine;
    }

    public EngineRef engine() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.engine$lzycompute();
        }
        return this.engine;
    }

    public Operation launchEngineOp() {
        return this.launchEngineOp;
    }

    private String sessionUserSignBase64$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sessionUserSignBase64 = SignUtils$.MODULE$.signWithPrivateKey(super.user(), ((KyuubiSessionManager)super.sessionManager()).signingPrivateKey(), SignUtils$.MODULE$.signWithPrivateKey$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sessionUserSignBase64;
    }

    private String sessionUserSignBase64() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.sessionUserSignBase64$lzycompute();
        }
        return this.sessionUserSignBase64;
    }

    private KyuubiSessionEvent sessionEvent() {
        return this.sessionEvent;
    }

    @Override
    public Option<KyuubiSessionEvent> getSessionEvent() {
        return Option$.MODULE$.apply((Object)this.sessionEvent());
    }

    @Override
    public void checkSessionAccessPathURIs() {
        KyuubiApplicationManager$.MODULE$.checkApplicationAccessPaths((String)this.sessionConf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()), (scala.collection.immutable.Map<String, String>)this.sessionConf.getAll(), ((KyuubiSessionManager)super.sessionManager()).getConf());
    }

    private KyuubiSyncThriftClient _client() {
        return this._client;
    }

    private void _client_$eq(KyuubiSyncThriftClient x$1) {
        this._client = x$1;
    }

    public KyuubiSyncThriftClient client() {
        return this._client();
    }

    private SessionHandle _engineSessionHandle() {
        return this._engineSessionHandle;
    }

    private void _engineSessionHandle_$eq(SessionHandle x$1) {
        this._engineSessionHandle = x$1;
    }

    private Option<Throwable> openSessionError() {
        return this.openSessionError;
    }

    private void openSessionError_$eq(Option<Throwable> x$1) {
        this.openSessionError = x$1;
    }

    public void open() {
        this.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.traceMetricsOnOpen();
            this.checkSessionAccessPathURIs();
            this.super$open();
            this.runOperation(this.launchEngineOp());
            this.engineLastAlive_$eq(System.currentTimeMillis());
        });
    }

    public Option<ServiceNodeInfo> getEngineNode() {
        return (Option)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(this.sessionConf, (Function1 & Serializable & scala.Serializable)discoveryClient -> this.engine().getServiceNode((DiscoveryClient)discoveryClient, this._client().hostPort()));
    }

    public void openEngineSession(Option<OperationLog> extraEngineLog) {
        this.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DiscoveryClientProvider$.MODULE$.withDiscoveryClient($this.sessionConf, (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$2(this, extraEngineLog, discoveryClient);
            return BoxedUnit.UNIT;
        }));
    }

    public Option<OperationLog> openEngineSession$default$1() {
        return None$.MODULE$;
    }

    public OperationHandle runOperation(Operation operation) {
        block2: {
            Operation operation2 = operation;
            Operation operation3 = this.launchEngineOp();
            if (!(operation2 == null ? operation3 != null : !operation2.equals(operation3))) break block2;
            try {
                this.waitForEngineLaunched();
            }
            catch (Throwable t) {
                operation.close();
                throw t;
            }
            this.sessionEvent().totalOperations_$eq(this.sessionEvent().totalOperations() + 1);
        }
        return super.runOperation(operation);
    }

    private boolean engineLaunched() {
        return this.engineLaunched;
    }

    private void engineLaunched_$eq(boolean x$1) {
        this.engineLaunched = x$1;
    }

    private void waitForEngineLaunched() {
        if (!this.engineLaunched()) {
            Option$.MODULE$.apply((Object)this.launchEngineOp()).foreach((Function1 & Serializable & scala.Serializable)op -> {
                KyuubiSessionImpl.$anonfun$waitForEngineLaunched$1(this, op);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private String renewEngineCredentials() {
        String string;
        try {
            string = ((KyuubiSessionManager)super.sessionManager()).credentialsManager().renewCredentials(this.engine().appUser());
        }
        catch (Exception e) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Failed to renew engine credentials for ").append(this.handle()).toString(), e);
            string = "";
        }
        return string;
    }

    public void close() {
        super.close();
        ((KyuubiSessionManager)super.sessionManager()).credentialsManager().removeSessionCredentialsEpoch(this.handle().identifier().toString());
        try {
            if (this._client() != null) {
                this._client().closeSession();
            }
        }
        finally {
            this.openSessionError().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                KyuubiSessionImpl.$anonfun$close$1(this, x$6);
                return BoxedUnit.UNIT;
            });
            this.sessionEvent().endTime_$eq(System.currentTimeMillis());
            EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
            this.traceMetricsOnClose();
        }
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        String string = (String)this.sessionConf.get(KyuubiConf$.MODULE$.SERVER_INFO_PROVIDER());
        if ("SERVER".equals(string)) {
            return super.getInfo(infoType);
        }
        if ("ENGINE".equals(string)) {
            return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
                this.waitForEngineLaunched();
                return this.client().getInfo(infoType).getInfoValue();
            });
        }
        throw new IllegalArgumentException(new StringBuilder(29).append("Unknown server info provider ").append(string).toString());
    }

    public OperationHandle executeStatement(String statement, scala.collection.immutable.Map<String, String> confOverlay, boolean runAsync, long queryTimeout) {
        return (OperationHandle)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiTreeNode kyuubiNode = $this.parser.parsePlan(statement);
            KyuubiTreeNode kyuubiTreeNode = kyuubiNode;
            if (kyuubiTreeNode instanceof RunnableCommand) {
                RunnableCommand runnableCommand = (RunnableCommand)kyuubiTreeNode;
                Operation operation = ((KyuubiSessionManager)this.super$sessionManager()).operationManager().newExecuteOnServerOperation(this, runAsync, runnableCommand);
                return this.runOperation(operation);
            }
            return this.super$executeStatement(statement, confOverlay, runAsync, queryTimeout);
        });
    }

    private long engineLastAlive() {
        return this.engineLastAlive;
    }

    private void engineLastAlive_$eq(long x$1) {
        this.engineLastAlive = x$1;
    }

    private long engineAliveTimeout() {
        return this.engineAliveTimeout;
    }

    private boolean aliveProbeEnabled() {
        return this.aliveProbeEnabled;
    }

    private int engineAliveMaxFailCount() {
        return this.engineAliveMaxFailCount;
    }

    private int engineAliveFailCount() {
        return this.engineAliveFailCount;
    }

    private void engineAliveFailCount_$eq(int x$1) {
        this.engineAliveFailCount = x$1;
    }

    public boolean checkEngineConnectionAlive() {
        boolean bl;
        block5: {
            try {
                if (Option$.MODULE$.apply((Object)this.client()).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.engineConnectionClosed()))) {
                    return false;
                }
                if (!this.aliveProbeEnabled()) {
                    return true;
                }
                this.getInfo(TGetInfoType.CLI_DBMS_VER);
                this.engineLastAlive_$eq(System.currentTimeMillis());
                this.engineAliveFailCount_$eq(0);
                bl = true;
            }
            catch (Throwable e) {
                long now = System.currentTimeMillis();
                this.engineAliveFailCount_$eq(this.engineAliveFailCount() + 1);
                if (now - this.engineLastAlive() > this.engineAliveTimeout() && this.engineAliveFailCount() >= this.engineAliveMaxFailCount()) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(229).append("The engineRef[").append(this.engine().getEngineRefId()).append("] is marked as not alive ").append("due to a lack of recent successful alive probes. ").append("The time since last successful probe: ").append(now - this.engineLastAlive()).append(" ms exceeds the timeout of ").append(this.engineAliveTimeout()).append(" ms. ").append("The engine has failed ").append(this.engineAliveFailCount()).append(" times, ").append("surpassing the maximum failure count of ").append(this.engineAliveMaxFailCount()).append(".").toString());
                    bl = false;
                    break block5;
                }
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("The engineRef[").append(this.engine().getEngineRefId()).append("] alive probe fails, ").append(now - this.engineLastAlive()).append(" ms exceeds timeout ").append(this.engineAliveTimeout()).append(" ms, ").append("and has failed ").append(this.engineAliveFailCount()).append(" times.").toString(), e);
                bl = true;
            }
        }
        return bl;
    }

    private final void deregisterEngine$1(DiscoveryClient discoveryClient$1, String host$1, int port$1) {
        try {
            this.engine().deregister(discoveryClient$1, (Tuple2<String, Object>)new Tuple2((Object)host$1, (Object)BoxesRunTime.boxToInteger((int)port$1)));
        }
        catch (Throwable e) {
            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error on de-registering engine [").append(this.engine().engineSpace()).append(" ").append(host$1).append(":").append(port$1).append("]").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$openEngineSession$4(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$10(KyuubiSessionImpl $this, String e) {
        $this.sessionEvent().engineId_$eq(e);
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$2(KyuubiSessionImpl $this, Option extraEngineLog$1, DiscoveryClient discoveryClient) {
        scala.collection.immutable.Map openEngineSessionConf = $this.optimizedConf().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.handle"), (Object)$this.handle().identifier().toString())})));
        if (new StringOps(Predef$.MODULE$.augmentString($this.engineCredentials())).nonEmpty()) {
            $this.sessionConf.set("kyuubi.engine.credentials", $this.engineCredentials());
            openEngineSessionConf = openEngineSessionConf.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.engine.credentials"), (Object)$this.engineCredentials())})));
        }
        if (BoxesRunTime.unboxToBoolean((Object)$this.sessionConf.get(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED()))) {
            openEngineSessionConf = openEngineSessionConf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED().key()), (Object)$this.sessionConf.get(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED()).toString())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.sign.publickey"), (Object)Base64.getEncoder().encodeToString(((KyuubiSessionManager)$this.super$sessionManager()).signingPublicKey().getEncoded()))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.user.sign"), (Object)$this.sessionUserSignBase64()));
        }
        int maxAttempts = BoxesRunTime.unboxToInt((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_MAX_ATTEMPTS()));
        long retryWait = BoxesRunTime.unboxToLong((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_RETRY_WAIT()));
        Enumeration.Value openOnFailure = KyuubiConf.EngineOpenOnFailure$.MODULE$.withName((String)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_ON_FAILURE()));
        IntRef attempt = IntRef.create((int)0);
        boolean shouldRetry = true;
        while (attempt.elem <= maxAttempts && shouldRetry) {
            Tuple2<String, Object> tuple2 = $this.engine().getOrCreate(discoveryClient, (Option<OperationLog>)extraEngineLog$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
            String host2 = (String)tuple22._1();
            int port2 = tuple22._2$mcI$sp();
            try {
                try {
                    String passwd = BoxesRunTime.unboxToBoolean((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED())) ? InternalSecurityAccessor$.MODULE$.get().issueToken() : (String)Option$.MODULE$.apply((Object)$this.super$password()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionImpl.$anonfun$openEngineSession$4(x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
                    $this._client_$eq(KyuubiSyncThriftClient$.MODULE$.createClient($this.super$user(), passwd, host2, port2, $this.sessionConf));
                    $this._engineSessionHandle_$eq($this._client().openSession($this.super$protocol(), $this.super$user(), passwd, (scala.collection.immutable.Map<String, String>)openEngineSessionConf));
                    $this.logSessionInfo(new StringBuilder(33).append("Connected to engine [").append(host2).append(":").append(port2).append("]/[").append($this.client().engineId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("]").append(" with ").append($this._engineSessionHandle()).append("]").toString());
                    shouldRetry = false;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof TTransportException) {
                        TTransportException tTransportException = (TTransportException)throwable2;
                        if (attempt.elem < maxAttempts && tTransportException.getCause() instanceof ConnectException && tTransportException.getCause().getMessage().contains("Connection refused")) {
                            $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Failed to open [").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("] after").append(" ").append(attempt$1.elem).append("/").append(maxAttempts).append(" times, retrying").toString(), tTransportException.getCause());
                            Thread.sleep(retryWait);
                            Enumeration.Value value = openOnFailure;
                            Enumeration.Value value2 = KyuubiConf.EngineOpenOnFailure$.MODULE$.DEREGISTER_IMMEDIATELY();
                            Enumeration.Value value3 = value;
                            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                                $this.deregisterEngine$1(discoveryClient, host2, port2);
                            }
                            shouldRetry = true;
                            continue;
                        }
                    }
                    if (throwable2 != null) {
                        boolean bl;
                        Throwable throwable3 = throwable2;
                        $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Opening engine [").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("]").append(" for ").append($this.super$user()).append(" session failed").toString(), throwable3);
                        $this.openSessionError_$eq((Option<Throwable>)new Some((Object)throwable3));
                        Enumeration.Value value = openOnFailure;
                        Enumeration.Value value4 = KyuubiConf.EngineOpenOnFailure$.MODULE$.DEREGISTER_IMMEDIATELY();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            bl = true;
                        } else {
                            Enumeration.Value value6 = KyuubiConf.EngineOpenOnFailure$.MODULE$.DEREGISTER_AFTER_RETRY();
                            Enumeration.Value value7 = value;
                            bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
                        }
                        if (bl) {
                            $this.deregisterEngine$1(discoveryClient, host2, port2);
                        }
                        throw throwable3;
                    }
                    throw throwable;
                }
            }
            finally {
                ++attempt.elem;
                if (!shouldRetry || $this._client() == null) continue;
                try {
                    $this._client().closeSession();
                }
                catch (Throwable e2) {
                    $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Error on closing broken client of engine ").append("[").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("]").toString(), e2);
                }
            }
        }
        $this.sessionEvent().openedTime_$eq(System.currentTimeMillis());
        $this.sessionEvent().remoteSessionId_$eq($this._engineSessionHandle().identifier().toString());
        $this._client().engineId().foreach((Function1 & Serializable & scala.Serializable)e -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$10($this, e);
            return BoxedUnit.UNIT;
        });
        EventBus$.MODULE$.post((KyuubiEvent)$this.sessionEvent());
    }

    public static final /* synthetic */ void $anonfun$waitForEngineLaunched$1(KyuubiSessionImpl $this, Operation op) {
        long waitingStartTime = System.currentTimeMillis();
        $this.logSessionInfo("Starting to wait the launch engine operation finished");
        op.getBackgroundHandle().get();
        long elapsedTime = System.currentTimeMillis() - waitingStartTime;
        $this.logSessionInfo(new StringBuilder(42).append("Engine has been launched, elapsed time: ").append(elapsedTime / 1000L).append(" s").toString());
        if ($this._engineSessionHandle() == null) {
            KyuubiSQLException ex = (KyuubiSQLException)op.getStatus().exception().getOrElse((Function0 & Serializable & scala.Serializable)() -> KyuubiSQLException$.MODULE$.apply(new StringBuilder(28).append("Failed to launch engine for ").append($this.handle()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4()));
            throw ex;
        }
        $this.engineLaunched_$eq(true);
    }

    public static final /* synthetic */ void $anonfun$close$1(KyuubiSessionImpl $this, Throwable x$6) {
        if ($this.engine() != null) {
            $this.engine().close();
            return;
        }
    }

    public KyuubiSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf, KyuubiSessionManager sessionManager, KyuubiConf sessionConf, boolean doAsEnabled, KyuubiParser parser) {
        scala.collection.immutable.Map map;
        this.sessionConf = sessionConf;
        this.doAsEnabled = doAsEnabled;
        this.parser = parser;
        super(protocol, user, password, ipAddress, conf, sessionManager);
        this.sessionType = SessionType$.MODULE$.INTERACTIVE();
        scala.collection.mutable.Map confOverlay = (scala.collection.mutable.Map)((TraversableOnce)((KyuubiSessionManager)super.sessionManager()).sessionConfAdvisor().map((Function1 & Serializable & scala.Serializable)x$1 -> (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$1.getConfOverlay(this.super$user(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.normalizedConf()).asJava())).asScala(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$plus$plus((GenTraversableOnce)x$3));
        if (confOverlay != null) {
            map = this.normalizedConf().$plus$plus((GenTraversableOnce)confOverlay);
        } else {
            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("the server plugin return null value for user: ").append(this.super$user()).append(", ignore it").toString());
            map = this.normalizedConf();
        }
        this.optimizedConf = map;
        this.optimizedConf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string2 = package$.MODULE$.USE_CATALOG();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string4 = package$.MODULE$.USE_DATABASE();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return $this.sessionConf.set(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        this.launchEngineOp = ((KyuubiSessionManager)super.sessionManager()).operationManager().newLaunchEngineOperation(this, BoxesRunTime.unboxToBoolean((Object)sessionConf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_LAUNCH_ASYNC())));
        this.sessionEvent = KyuubiSessionEvent$.MODULE$.apply(this);
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
        this.openSessionError = None$.MODULE$;
        this.engineLaunched = false;
        this.engineAliveTimeout = BoxesRunTime.unboxToLong((Object)sessionConf.get(KyuubiConf$.MODULE$.ENGINE_ALIVE_TIMEOUT()));
        this.aliveProbeEnabled = BoxesRunTime.unboxToBoolean((Object)sessionConf.get(KyuubiConf$.MODULE$.ENGINE_ALIVE_PROBE_ENABLED()));
        this.engineAliveMaxFailCount = BoxesRunTime.unboxToInt((Object)sessionConf.get(KyuubiConf$.MODULE$.ENGINE_ALIVE_MAX_FAILURES()));
        this.engineAliveFailCount = 0;
    }
}

