/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import com.zaxxer.hikari.util.DriverDataSource;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import javax.security.sasl.AuthenticationException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.PasswdAuthenticationProvider;
import org.apache.kyuubi.util.JdbcUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u000e\u001d\u0001\u001dB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006{\u0001!\tA\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0011\u0019Y\u0005\u0001)A\u0005\u0007\"9A\n\u0001b\u0001\n\u0013i\u0005B\u0002,\u0001A\u0003%a\nC\u0004X\u0001\t\u0007I\u0011B'\t\ra\u0003\u0001\u0015!\u0003O\u0011\u001dI\u0006A1A\u0005\niCaa\u0019\u0001!\u0002\u0013Y\u0006b\u00023\u0001\u0005\u0004%I!\u001a\u0005\u0007g\u0002\u0001\u000b\u0011\u00024\t\u000fQ\u0004!\u0019!C\u0005K\"1Q\u000f\u0001Q\u0001\n\u0019DqA\u001e\u0001C\u0002\u0013%Q\r\u0003\u0004x\u0001\u0001\u0006IA\u001a\u0005\bq\u0002\u0011\r\u0011\"\u0003f\u0011\u0019I\b\u0001)A\u0005M\"9!\u0010\u0001b\u0001\n\u0013)\u0007BB>\u0001A\u0003%a\r\u0003\u0005}\u0001\t\u0007I1\u0001\u0011~\u0011\u001d\ti\u0001\u0001Q\u0001\nyDq!a\u0004\u0001\t\u0003\n\t\u0002C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005M\u0004\u0001\"\u0003\u0002@!9\u0011Q\u000f\u0001\u0005\n\u0005]$A\b&eE\u000e\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\u0018*\u001c9m\u0015\tib$\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005}\u0001\u0013aB:feZL7-\u001a\u0006\u0003C\t\naa[=vk\nL'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001Q9\u0012\u0004CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020a5\tA$\u0003\u000229\ta\u0002+Y:to\u0012\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bCA\u001a5\u001b\u0005\u0001\u0013BA\u001b!\u0005\u001daunZ4j]\u001e\fAaY8oMB\u0011\u0001hO\u0007\u0002s)\u0011!\bI\u0001\u0007G>tg-[4\n\u0005qJ$AC&zkV\u0014\u0017nQ8oM\u00061A(\u001b8jiz\"\"a\u0010!\u0011\u0005=\u0002\u0001\"\u0002\u001c\u0003\u0001\u00049\u0014!F*R\u0019~\u0003F*Q\"F\u0011>cE)\u0012*`%\u0016;U\tW\u000b\u0002\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\t[\u0006$8\r[5oO*\u0011\u0001JK\u0001\u0005kRLG.\u0003\u0002K\u000b\n)!+Z4fq\u000612+\u0015'`!2\u000b5)\u0012%P\u0019\u0012+%k\u0018*F\u000f\u0016C\u0006%\u0001\u000bV'\u0016\u0013vlU)M?Bc\u0015iQ#I\u001f2#UIU\u000b\u0002\u001dB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0005Y\u0006twMC\u0001T\u0003\u0011Q\u0017M^1\n\u0005U\u0003&AB*ue&tw-A\u000bV'\u0016\u0013vlU)M?Bc\u0015iQ#I\u001f2#UI\u0015\u0011\u00021A\u000b5kU,P%\u0012{6+\u0015'`!2\u000b5)\u0012%P\u0019\u0012+%+A\rQ\u0003N\u001bvk\u0014*E?N\u000bFj\u0018)M\u0003\u000e+\u0005j\u0014'E\u000bJ\u0003\u0013!F:vaB|'\u000f^3e!2\f7-\u001a5pY\u0012,'o]\u000b\u00027B\u0019A,\u0019(\u000e\u0003uS!AX0\u0002\u0013%lW.\u001e;bE2,'B\u00011+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Ev\u00131aU3u\u0003Y\u0019X\u000f\u001d9peR,G\r\u00157bG\u0016Dw\u000e\u001c3feN\u0004\u0013a\u00033sSZ,'o\u00117bgN,\u0012A\u001a\t\u0004S\u001dL\u0017B\u00015+\u0005\u0019y\u0005\u000f^5p]B\u0011!.\u001d\b\u0003W>\u0004\"\u0001\u001c\u0016\u000e\u00035T!A\u001c\u0014\u0002\rq\u0012xn\u001c;?\u0013\t\u0001(&\u0001\u0004Qe\u0016$WMZ\u0005\u0003+JT!\u0001\u001d\u0016\u0002\u0019\u0011\u0014\u0018N^3s\u00072\f7o\u001d\u0011\u0002\u001b\u0005,H\u000f\u001b#c\u0015\u0012\u00147-\u0016:m\u00039\tW\u000f\u001e5EE*#'mY+sY\u0002\n!\"Y;uQ\u0012\u0013Wk]3s\u0003-\tW\u000f\u001e5EEV\u001bXM\u001d\u0011\u0002\u001d\u0005,H\u000f\u001b#c!\u0006\u001c8o^8sI\u0006y\u0011-\u001e;i\t\n\u0004\u0016m]:x_J$\u0007%A\u0005bkRD\u0017+^3ss\u0006Q\u0011-\u001e;i#V,'/\u001f\u0011\u0002\u0005\u0011\u001cX#\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0003\u000f\tQA[1wCbLA!a\u0003\u0002\u0002\tQA)\u0019;b'>,(oY3\u0002\u0007\u0011\u001c\b%\u0001\u0007bkRDWM\u001c;jG\u0006$X\r\u0006\u0004\u0002\u0014\u0005e\u0011Q\u0004\t\u0004S\u0005U\u0011bAA\fU\t!QK\\5u\u0011\u0019\tYb\u0006a\u0001S\u0006!Qo]3s\u0011\u0019\tyb\u0006a\u0001S\u0006A\u0001/Y:to>\u0014H\rK\u0003\u0018\u0003G\tI\u0004E\u0003*\u0003K\tI#C\u0002\u0002()\u0012a\u0001\u001e5s_^\u001c\b\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0005g\u0006\u001cHN\u0003\u0003\u00024\u0005\u0015\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005]\u0012Q\u0006\u0002\u0018\u0003V$\b.\u001a8uS\u000e\fG/[8o\u000bb\u001cW\r\u001d;j_:\fdAH5\u0002<\u00055\u0014'C\u0012\u0002>\u0005\u0015\u00131MA$+\u0011\ty$!\u0011\u0016\u0003%$q!a\u0011'\u0005\u0004\tiEA\u0001U\u0013\u0011\t9%!\u0013\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\tYEK\u0001\u0007i\"\u0014xn^:\u0012\t\u0005=\u0013Q\u000b\t\u0004S\u0005E\u0013bAA*U\t9aj\u001c;iS:<\u0007\u0003BA,\u0003;r1!KA-\u0013\r\tYFK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty&!\u0019\u0003\u0013QC'o\\<bE2,'bAA.UEJ1%!\u001a\u0002h\u0005%\u00141\n\b\u0004S\u0005\u001d\u0014bAA&UE*!%\u000b\u0016\u0002l\t)1oY1mCF\u001aa%!\u000b\u0002!\rDWmY6KI\n\u001c7i\u001c8gS\u001e\u001cHCAA\n\u00035\u0001(/\u001a9be\u0016$\u0017+^3ss\u0006\t\u0012/^3ssBc\u0017mY3i_2$WM]:\u0016\u0005\u0005e\u0004#BA>\u0003\u0003Kg\u0002BA?\u00033r1\u0001\\A@\u0013\u0005Y\u0013\u0002BAB\u0003C\u0012\u0001\"\u0013;fe\u0006$xN\u001d")
public class JdbcAuthenticationProviderImpl
implements PasswdAuthenticationProvider,
Logging {
    private final Regex SQL_PLACEHOLDER_REGEX;
    private final String USER_SQL_PLACEHOLDER;
    private final String PASSWORD_SQL_PLACEHOLDER;
    private final Set<String> supportedPlaceholders;
    private final Option<String> driverClass;
    private final Option<String> authDbJdbcUrl;
    private final Option<String> authDbUser;
    private final Option<String> authDbPassword;
    private final Option<String> authQuery;
    private final DataSource ds;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Regex SQL_PLACEHOLDER_REGEX() {
        return this.SQL_PLACEHOLDER_REGEX;
    }

    private String USER_SQL_PLACEHOLDER() {
        return this.USER_SQL_PLACEHOLDER;
    }

    private String PASSWORD_SQL_PLACEHOLDER() {
        return this.PASSWORD_SQL_PLACEHOLDER;
    }

    private Set<String> supportedPlaceholders() {
        return this.supportedPlaceholders;
    }

    private Option<String> driverClass() {
        return this.driverClass;
    }

    private Option<String> authDbJdbcUrl() {
        return this.authDbJdbcUrl;
    }

    private Option<String> authDbUser() {
        return this.authDbUser;
    }

    private Option<String> authDbPassword() {
        return this.authDbPassword;
    }

    private Option<String> authQuery() {
        return this.authQuery;
    }

    public DataSource ds() {
        return this.ds;
    }

    @Override
    public void authenticate(String user, String password) throws AuthenticationException {
        if (StringUtils.isBlank((CharSequence)user)) {
            throw new AuthenticationException(new StringBuilder(54).append("Error validating, user is null").append(" or contains blank space").toString());
        }
        try {
            this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(21).append("prepared auth query: ").append(this.preparedQuery()).toString());
            JdbcUtils$.MODULE$.executeQuery(this.preparedQuery(), (Function1<PreparedStatement, BoxedUnit>)(Function1<PreparedStatement, Object> & Serializable & scala.Serializable)pStmt -> {
                JdbcAuthenticationProviderImpl.$anonfun$authenticate$2(this, user, password, pStmt);
                return BoxedUnit.UNIT;
            }, (Function1<ResultSet, Object> & Serializable & scala.Serializable)resultSet -> {
                JdbcAuthenticationProviderImpl.$anonfun$authenticate$4(user, password, resultSet);
                return BoxedUnit.UNIT;
            }, this.ds());
        }
        catch (AuthenticationException rethrow) {
            throw rethrow;
        }
        catch (Exception rethrow) {
            throw new AuthenticationException("Cannot get user info", rethrow);
        }
    }

    private void checkJdbcConfigs() {
        Function2<String, Option, String> & Serializable & scala.Serializable configLog = (Function2<String, Option, String> & Serializable & scala.Serializable)(config, value) -> new StringBuilder(21).append("JDBCAuthConfig: ").append((String)config).append(" = '").append(value.orNull(Predef$.MODULE$.$conforms())).append("'").toString();
        this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> (String)configLog.apply("Driver Class", this.driverClass()));
        this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> (String)configLog.apply("JDBC URL", this.authDbJdbcUrl()));
        this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> (String)configLog.apply("Database user", this.authDbUser()));
        this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> (String)configLog.apply("Database password", new Some<String>(JdbcUtils$.MODULE$.redactPassword(this.authDbPassword()))));
        this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> (String)configLog.apply("Query SQL", this.authQuery()));
        Predef$.MODULE$.require(this.driverClass().nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "JDBC driver class is not configured.");
        Predef$.MODULE$.require(this.authDbJdbcUrl().nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "JDBC url is not configured.");
        Predef$.MODULE$.require(this.authQuery().nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Query SQL is not configured");
        String query = this.authQuery().get().trim().toLowerCase();
        Predef$.MODULE$.require(query.startsWith("select"), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Query SQL must start with 'SELECT'");
        if (!query.contains("where")) {
            this.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Query SQL does not contains 'WHERE' keyword");
        }
        if (!query.contains(this.USER_SQL_PLACEHOLDER())) {
            this.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Query SQL does not contains '").append(this.USER_SQL_PLACEHOLDER()).append("' placeholder").toString());
        }
        if (!query.contains(this.PASSWORD_SQL_PLACEHOLDER())) {
            this.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Query SQL does not contains '").append(this.PASSWORD_SQL_PLACEHOLDER()).append("' placeholder").toString());
        }
        this.queryPlaceholders().foreach((Function1<String, Object> & Serializable & scala.Serializable)placeholder -> {
            Predef$.MODULE$.require(this.supportedPlaceholders().contains(placeholder), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Unsupported placeholder in Query SQL: ").append(placeholder).toString());
            return BoxedUnit.UNIT;
        });
    }

    private String preparedQuery() {
        return this.SQL_PLACEHOLDER_REGEX().replaceAllIn((CharSequence)this.authQuery().get(), "?");
    }

    private Iterator<String> queryPlaceholders() {
        return this.SQL_PLACEHOLDER_REGEX().findAllMatchIn(this.authQuery().get()).map((Function1<Regex.Match, String> & Serializable & scala.Serializable)x$1 -> x$1.matched());
    }

    public static final /* synthetic */ void $anonfun$authenticate$3(JdbcAuthenticationProviderImpl $this, PreparedStatement pStmt$1, String user$1, String password$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string2 = $this.USER_SQL_PLACEHOLDER();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                pStmt$1.setString(i + 1, user$1);
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string4 = $this.PASSWORD_SQL_PLACEHOLDER();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                pStmt$1.setString(i + 1, password$1);
                return;
            }
        }
        if (tuple2 != null) {
            String p = (String)tuple2._1();
            throw new IllegalArgumentException(new StringBuilder(39).append("Unrecognized placeholder in Query SQL: ").append(p).toString());
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$authenticate$2(JdbcAuthenticationProviderImpl $this, String user$1, String password$1, PreparedStatement pStmt) {
        $this.queryPlaceholders().zipWithIndex().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            JdbcAuthenticationProviderImpl.$anonfun$authenticate$3($this, pStmt, user$1, password$1, x0$1);
            return BoxedUnit.UNIT;
        });
        pStmt.setMaxRows(1);
    }

    public static final /* synthetic */ void $anonfun$authenticate$4(String user$1, String password$1, ResultSet resultSet) {
        if (!resultSet.next()) {
            throw new AuthenticationException(new StringBuilder(59).append("Password does not match or no such user. ").append("user: ").append(user$1).append(", password: ").append(JdbcUtils$.MODULE$.redactPassword(new Some<String>(password$1))).toString());
        }
    }

    public JdbcAuthenticationProviderImpl(KyuubiConf conf) {
        Logging.$init$(this);
        this.SQL_PLACEHOLDER_REGEX = new StringOps(Predef$.MODULE$.augmentString("\\$\\{.+?}")).r();
        this.USER_SQL_PLACEHOLDER = "${user}";
        this.PASSWORD_SQL_PLACEHOLDER = "${password}";
        this.supportedPlaceholders = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.USER_SQL_PLACEHOLDER(), this.PASSWORD_SQL_PLACEHOLDER()}));
        this.driverClass = (Option)((Object)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_JDBC_DRIVER()));
        this.authDbJdbcUrl = (Option)((Object)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_JDBC_URL()));
        this.authDbUser = (Option)((Object)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_JDBC_USER()));
        this.authDbPassword = (Option)((Object)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_JDBC_PASSWORD()));
        this.authQuery = (Option)((Object)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_JDBC_QUERY()));
        this.checkJdbcConfigs();
        this.ds = new DriverDataSource((String)this.authDbJdbcUrl().orNull(Predef$.MODULE$.$conforms()), (String)this.driverClass().orNull(Predef$.MODULE$.$conforms()), new Properties(), (String)this.authDbUser().orNull(Predef$.MODULE$.$conforms()), (String)this.authDbPassword().orNull(Predef$.MODULE$.$conforms()));
    }
}

