/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.kyuubi.jdbc.hive.auth.KerberosAuthentication;
import org.apache.kyuubi.jdbc.hive.auth.KerberosUtils;

public class CachingKerberosAuthentication {
    private final KerberosAuthentication kerberosAuthentication;
    @GuardedBy(value="this")
    private Subject subject;
    @GuardedBy(value="this")
    private long nextRefreshTime;

    public CachingKerberosAuthentication(KerberosAuthentication kerberosAuthentication) {
        this.kerberosAuthentication = Objects.requireNonNull(kerberosAuthentication, "kerberosAuthentication is null");
    }

    public synchronized Subject getSubject() {
        if (this.subject == null || this.ticketNeedsRefresh()) {
            this.subject = Objects.requireNonNull(this.kerberosAuthentication.getSubject(), "kerberosAuthentication.getSubject() is null");
            KerberosTicket tgtTicket = KerberosUtils.getTgt(this.subject);
            this.nextRefreshTime = KerberosUtils.getTgtRefreshTime(tgtTicket);
        }
        return this.subject;
    }

    public synchronized void reauthenticateIfSoonWillBeExpired() {
        Objects.requireNonNull(this.subject, "subject is null, getSubject() must be called before reauthenticate()");
        if (this.ticketNeedsRefresh()) {
            this.kerberosAuthentication.attemptLogin(this.subject);
            KerberosTicket tgtTicket = KerberosUtils.getTgt(this.subject);
            this.nextRefreshTime = KerberosUtils.getTgtRefreshTime(tgtTicket);
        }
    }

    private boolean ticketNeedsRefresh() {
        return this.nextRefreshTime < System.currentTimeMillis();
    }
}

