/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.kyuubi.shade.io.vertx.core.AsyncResult;
import org.apache.kyuubi.shade.io.vertx.core.Context;
import org.apache.kyuubi.shade.io.vertx.core.DeploymentOptions;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.Promise;
import org.apache.kyuubi.shade.io.vertx.core.ThreadingModel;
import org.apache.kyuubi.shade.io.vertx.core.Verticle;
import org.apache.kyuubi.shade.io.vertx.core.impl.CloseFuture;
import org.apache.kyuubi.shade.io.vertx.core.impl.ConcurrentHashSet;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextImpl;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.Deployment;
import org.apache.kyuubi.shade.io.vertx.core.impl.VertxImpl;
import org.apache.kyuubi.shade.io.vertx.core.impl.VertxInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.WorkerPool;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.PromiseInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.logging.Logger;
import org.apache.kyuubi.shade.io.vertx.core.impl.logging.LoggerFactory;
import org.apache.kyuubi.shade.io.vertx.core.json.JsonObject;

public class DeploymentManager {
    private static final Logger log = LoggerFactory.getLogger(DeploymentManager.class);
    private final VertxImpl vertx;
    private final Map<String, Deployment> deployments = new ConcurrentHashMap<String, Deployment>();

    public DeploymentManager(VertxImpl vertx) {
        this.vertx = vertx;
    }

    private String generateDeploymentID() {
        return UUID.randomUUID().toString();
    }

    public Future<String> deployVerticle(Callable<Verticle> verticleSupplier, DeploymentOptions options) {
        if (options.getInstances() < 1) {
            throw new IllegalArgumentException("Can't specify < 1 instances to deploy");
        }
        options.checkIsolationNotDefined();
        ContextInternal currentContext = this.vertx.getOrCreateContext();
        ClassLoader cl = options.getClassLoader();
        if (cl == null && (cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = this.getClass().getClassLoader();
        }
        return this.doDeploy(options, (Verticle v) -> "java:" + v.getClass().getName(), currentContext, currentContext, cl, verticleSupplier).map(Deployment::deploymentID);
    }

    public Future<Void> undeployVerticle(String deploymentID) {
        Deployment deployment = this.deployments.get(deploymentID);
        ContextInternal currentContext = this.vertx.getOrCreateContext();
        if (deployment == null) {
            return currentContext.failedFuture(new IllegalStateException("Unknown deployment"));
        }
        return deployment.doUndeploy(this.vertx.getOrCreateContext());
    }

    public Set<String> deployments() {
        return Collections.unmodifiableSet(this.deployments.keySet());
    }

    public Deployment getDeployment(String deploymentID) {
        return this.deployments.get(deploymentID);
    }

    public Future<Void> undeployAll() {
        HashSet deploymentIDs = new HashSet();
        for (Map.Entry<String, Deployment> entry : this.deployments.entrySet()) {
            if (entry.getValue().isChild()) continue;
            deploymentIDs.add(entry.getKey());
        }
        ArrayList completionList = new ArrayList();
        if (!deploymentIDs.isEmpty()) {
            for (String deploymentID : deploymentIDs) {
                Promise promise = Promise.promise();
                completionList.add(promise.future());
                this.undeployVerticle(deploymentID).onComplete(ar -> {
                    if (ar.failed()) {
                        log.error("Undeploy failed", ar.cause());
                    }
                    promise.handle(ar);
                });
            }
            PromiseInternal promise = this.vertx.getOrCreateContext().promise();
            Future.join(completionList).mapEmpty().onComplete(promise);
            return promise.future();
        }
        return this.vertx.getOrCreateContext().succeededFuture();
    }

    private <T> void reportFailure(Throwable t, Context context, Handler<AsyncResult<T>> completionHandler) {
        if (completionHandler != null) {
            this.reportResult(context, completionHandler, Future.failedFuture(t));
        } else {
            log.error(t.getMessage(), t);
        }
    }

    private <T> void reportResult(Context context, Handler<AsyncResult<T>> completionHandler, AsyncResult<T> result) {
        context.runOnContext(v -> {
            try {
                completionHandler.handle(result);
            }
            catch (Throwable t) {
                log.error("Failure in calling handler", t);
                throw t;
            }
        });
    }

    Future<Deployment> doDeploy(DeploymentOptions options, Function<Verticle, String> identifierProvider, ContextInternal parentContext, ContextInternal callingContext, ClassLoader tccl, Callable<Verticle> verticleSupplier) {
        int nbInstances = options.getInstances();
        Set verticles = Collections.newSetFromMap(new IdentityHashMap());
        for (int i = 0; i < nbInstances; ++i) {
            Verticle verticle;
            try {
                verticle = verticleSupplier.call();
            }
            catch (Exception e) {
                return Future.failedFuture(e);
            }
            if (verticle == null) {
                return Future.failedFuture("Supplied verticle is null");
            }
            verticles.add(verticle);
        }
        if (verticles.size() != nbInstances) {
            return Future.failedFuture("Same verticle supplied more than once");
        }
        Verticle[] verticlesArray = verticles.toArray(new Verticle[0]);
        return this.doDeploy(identifierProvider.apply(verticlesArray[0]), options, parentContext, callingContext, tccl, verticlesArray);
    }

    private Future<Deployment> doDeploy(String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, ClassLoader tccl, Verticle ... verticles) {
        PromiseInternal promise = callingContext.promise();
        Deployment parent = parentContext.getDeployment();
        String deploymentID = this.generateDeploymentID();
        AtomicInteger deployCount = new AtomicInteger();
        AtomicBoolean failureReported = new AtomicBoolean();
        VertxImpl.SharedWorkerPool workerPool = null;
        ThreadingModel mode = options.getThreadingModel();
        if (mode == null) {
            mode = ThreadingModel.EVENT_LOOP;
        }
        if (mode != ThreadingModel.VIRTUAL_THREAD) {
            if (options.getWorkerPoolName() != null) {
                workerPool = this.vertx.createSharedWorkerPool(options.getWorkerPoolName(), options.getWorkerPoolSize(), options.getMaxWorkerExecuteTime(), options.getMaxWorkerExecuteTimeUnit());
            }
        } else if (!VertxInternal.isVirtualThreadAvailable()) {
            return callingContext.failedFuture("This Java runtime does not support virtual threads");
        }
        DeploymentImpl deployment = new DeploymentImpl(parent, workerPool, deploymentID, identifier, options);
        for (Verticle verticle : verticles) {
            ContextImpl context;
            CloseFuture closeFuture = new CloseFuture(log);
            switch (mode) {
                default: {
                    context = this.vertx.createEventLoopContext(deployment, closeFuture, workerPool, tccl);
                    break;
                }
                case WORKER: {
                    context = this.vertx.createWorkerContext(deployment, closeFuture, workerPool, tccl);
                    break;
                }
                case VIRTUAL_THREAD: {
                    context = this.vertx.createVirtualThreadContext(deployment, closeFuture, tccl);
                }
            }
            VerticleHolder holder = new VerticleHolder(verticle, context, closeFuture);
            deployment.addVerticle(holder);
            context.runOnContext(v -> {
                block2: {
                    try {
                        verticle.init(this.vertx, context);
                        PromiseInternal<Void> startPromise = context.promise();
                        Future startFuture = startPromise.future();
                        verticle.start(startPromise);
                        startFuture.onComplete(ar -> {
                            if (ar.succeeded()) {
                                if (parent != null) {
                                    if (parent.addChild(deployment)) {
                                        deployment.child = true;
                                    } else {
                                        deployment.doUndeploy(this.vertx.getOrCreateContext()).onComplete(ar2 -> promise.fail("Verticle deployment failed.Could not be added as child of parent verticle"));
                                        return;
                                    }
                                }
                                this.deployments.put(deploymentID, deployment);
                                if (deployCount.incrementAndGet() == verticles.length) {
                                    promise.complete(deployment);
                                }
                            } else if (failureReported.compareAndSet(false, true)) {
                                deployment.rollback(callingContext, promise, context, holder, ar.cause());
                            }
                        });
                    }
                    catch (Throwable t) {
                        if (!failureReported.compareAndSet(false, true)) break block2;
                        deployment.rollback(callingContext, promise, context, holder, t);
                    }
                }
            });
        }
        return promise.future();
    }

    private class DeploymentImpl
    implements Deployment {
        private static final int ST_DEPLOYED = 0;
        private static final int ST_UNDEPLOYING = 1;
        private static final int ST_UNDEPLOYED = 2;
        private final Deployment parent;
        private final String deploymentID;
        private final JsonObject conf;
        private final String verticleIdentifier;
        private final List<VerticleHolder> verticles = new CopyOnWriteArrayList<VerticleHolder>();
        private final Set<Deployment> children = new ConcurrentHashSet<Deployment>();
        private final WorkerPool workerPool;
        private final DeploymentOptions options;
        private Handler<Void> undeployHandler;
        private int status = 0;
        private volatile boolean child;

        private DeploymentImpl(Deployment parent, WorkerPool workerPool, String deploymentID, String verticleIdentifier, DeploymentOptions options) {
            this.parent = parent;
            this.deploymentID = deploymentID;
            this.conf = options.getConfig() != null ? options.getConfig().copy() : new JsonObject();
            this.verticleIdentifier = verticleIdentifier;
            this.options = options;
            this.workerPool = workerPool;
        }

        public void addVerticle(VerticleHolder holder) {
            this.verticles.add(holder);
        }

        private synchronized void rollback(ContextInternal callingContext, Handler<AsyncResult<Deployment>> completionHandler, ContextImpl context, VerticleHolder closeFuture, Throwable cause) {
            if (this.status == 0) {
                this.status = 1;
                this.doUndeployChildren(callingContext).onComplete(childrenResult -> {
                    Handler<Void> handler;
                    if (this.workerPool != null) {
                        this.workerPool.close();
                    }
                    DeploymentImpl deploymentImpl = this;
                    synchronized (deploymentImpl) {
                        this.status = 2;
                        handler = this.undeployHandler;
                        this.undeployHandler = null;
                    }
                    if (handler != null) {
                        try {
                            handler.handle(null);
                        }
                        catch (Exception e) {
                            context.reportException(e);
                        }
                    }
                    if (childrenResult.failed()) {
                        DeploymentManager.this.reportFailure(cause, callingContext, completionHandler);
                    } else {
                        closeFuture.close(closeHookAsyncResult -> DeploymentManager.this.reportFailure(cause, callingContext, completionHandler));
                    }
                });
            }
        }

        private synchronized Future<Void> doUndeployChildren(ContextInternal undeployingContext) {
            if (!this.children.isEmpty()) {
                ArrayList undeployFutures = new ArrayList();
                for (Deployment childDeployment : new HashSet<Deployment>(this.children)) {
                    Promise p = Promise.promise();
                    undeployFutures.add(p.future());
                    childDeployment.doUndeploy(undeployingContext).onComplete(ar -> {
                        this.children.remove(childDeployment);
                        p.handle(ar);
                    });
                }
                return Future.all(undeployFutures).mapEmpty();
            }
            return Future.succeededFuture();
        }

        @Override
        public synchronized Future<Void> doUndeploy(ContextInternal undeployingContext) {
            Handler<Void> handler;
            if (this.status == 2) {
                return Future.failedFuture(new IllegalStateException("Already undeployed"));
            }
            if (!this.children.isEmpty()) {
                this.status = 1;
                return this.doUndeployChildren(undeployingContext).compose(v -> this.doUndeploy(undeployingContext));
            }
            this.status = 2;
            ArrayList undeployFutures = new ArrayList();
            if (this.parent != null) {
                this.parent.removeChild(this);
            }
            for (VerticleHolder verticleHolder : this.verticles) {
                ContextImpl context = verticleHolder.context;
                Promise p = Promise.promise();
                undeployFutures.add(p.future());
                context.runOnContext(v -> {
                    block2: {
                        PromiseInternal<Void> stopPromise = undeployingContext.promise();
                        Future stopFuture = stopPromise.future();
                        stopFuture.onComplete(ar -> {
                            DeploymentManager.this.deployments.remove(this.deploymentID);
                            verticleHolder.close(ar2 -> {
                                if (ar2.failed()) {
                                    log.error("Failed to run close hook", ar2.cause());
                                }
                                if (ar.succeeded()) {
                                    p.complete();
                                } else if (ar.failed()) {
                                    p.fail(ar.cause());
                                }
                            });
                        });
                        try {
                            verticleHolder.verticle.stop(stopPromise);
                        }
                        catch (Throwable t) {
                            if (stopPromise.tryFail(t)) break block2;
                            undeployingContext.reportException(t);
                        }
                    }
                });
            }
            PromiseInternal resolvingPromise = undeployingContext.promise();
            Future.all(undeployFutures).mapEmpty().onComplete(resolvingPromise);
            Future<Void> fut = resolvingPromise.future();
            if (this.workerPool != null) {
                fut = fut.andThen(ar -> this.workerPool.close());
            }
            if ((handler = this.undeployHandler) != null) {
                this.undeployHandler = null;
                return fut.compose(v -> {
                    handler.handle(null);
                    return Future.succeededFuture();
                }, v -> {
                    handler.handle(null);
                    return Future.succeededFuture();
                });
            }
            return fut;
        }

        @Override
        public String verticleIdentifier() {
            return this.verticleIdentifier;
        }

        @Override
        public DeploymentOptions deploymentOptions() {
            return this.options;
        }

        @Override
        public JsonObject config() {
            return this.conf;
        }

        @Override
        public synchronized boolean addChild(Deployment deployment) {
            if (this.status == 0) {
                this.children.add(deployment);
                return true;
            }
            return false;
        }

        @Override
        public void removeChild(Deployment deployment) {
            this.children.remove(deployment);
        }

        @Override
        public Set<Context> getContexts() {
            HashSet<Context> contexts = new HashSet<Context>();
            for (VerticleHolder holder : this.verticles) {
                contexts.add(holder.context);
            }
            return contexts;
        }

        @Override
        public Set<Verticle> getVerticles() {
            HashSet<Verticle> verts = new HashSet<Verticle>();
            for (VerticleHolder holder : this.verticles) {
                verts.add(holder.verticle);
            }
            return verts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undeployHandler(Handler<Void> handler) {
            DeploymentImpl deploymentImpl = this;
            synchronized (deploymentImpl) {
                if (this.status != 2) {
                    this.undeployHandler = handler;
                    return;
                }
            }
            handler.handle(null);
        }

        @Override
        public boolean isChild() {
            return this.child;
        }

        @Override
        public String deploymentID() {
            return this.deploymentID;
        }
    }

    static class VerticleHolder {
        final Verticle verticle;
        final ContextImpl context;
        final CloseFuture closeFuture;

        VerticleHolder(Verticle verticle, ContextImpl context, CloseFuture closeFuture) {
            this.verticle = verticle;
            this.context = context;
            this.closeFuture = closeFuture;
        }

        void close(Handler<AsyncResult<Void>> completionHandler) {
            this.closeFuture.close().onComplete(completionHandler);
        }
    }
}

