/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.hive.service.rpc.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.kyuubi.shaded.thrift.TBase;
import org.apache.kyuubi.shaded.thrift.TBaseHelper;
import org.apache.kyuubi.shaded.thrift.TException;
import org.apache.kyuubi.shaded.thrift.TFieldIdEnum;
import org.apache.kyuubi.shaded.thrift.meta_data.FieldMetaData;
import org.apache.kyuubi.shaded.thrift.meta_data.FieldValueMetaData;
import org.apache.kyuubi.shaded.thrift.meta_data.ListMetaData;
import org.apache.kyuubi.shaded.thrift.protocol.TCompactProtocol;
import org.apache.kyuubi.shaded.thrift.protocol.TField;
import org.apache.kyuubi.shaded.thrift.protocol.TList;
import org.apache.kyuubi.shaded.thrift.protocol.TProtocol;
import org.apache.kyuubi.shaded.thrift.protocol.TProtocolException;
import org.apache.kyuubi.shaded.thrift.protocol.TProtocolUtil;
import org.apache.kyuubi.shaded.thrift.protocol.TStruct;
import org.apache.kyuubi.shaded.thrift.protocol.TTupleProtocol;
import org.apache.kyuubi.shaded.thrift.scheme.IScheme;
import org.apache.kyuubi.shaded.thrift.scheme.SchemeFactory;
import org.apache.kyuubi.shaded.thrift.scheme.StandardScheme;
import org.apache.kyuubi.shaded.thrift.scheme.TupleScheme;
import org.apache.kyuubi.shaded.thrift.transport.TIOStreamTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TDoubleColumn
implements TBase<TDoubleColumn, _Fields>,
Serializable,
Cloneable,
Comparable<TDoubleColumn> {
    private static final TStruct STRUCT_DESC = new TStruct("TDoubleColumn");
    private static final TField VALUES_FIELD_DESC = new TField("values", 15, 1);
    private static final TField NULLS_FIELD_DESC = new TField("nulls", 11, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private List<Double> values;
    private ByteBuffer nulls;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TDoubleColumn() {
    }

    public TDoubleColumn(List<Double> values, ByteBuffer nulls) {
        this();
        this.values = values;
        this.nulls = TBaseHelper.copyBinary((ByteBuffer)nulls);
    }

    public TDoubleColumn(TDoubleColumn other) {
        if (other.isSetValues()) {
            ArrayList<Double> __this__values = new ArrayList<Double>(other.values);
            this.values = __this__values;
        }
        if (other.isSetNulls()) {
            this.nulls = TBaseHelper.copyBinary((ByteBuffer)other.nulls);
        }
    }

    public TDoubleColumn deepCopy() {
        return new TDoubleColumn(this);
    }

    public void clear() {
        this.values = null;
        this.nulls = null;
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    public Iterator<Double> getValuesIterator() {
        return this.values == null ? null : this.values.iterator();
    }

    public void addToValues(double elem) {
        if (this.values == null) {
            this.values = new ArrayList<Double>();
        }
        this.values.add(elem);
    }

    public List<Double> getValues() {
        return this.values;
    }

    public void setValues(List<Double> values) {
        this.values = values;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean value) {
        if (!value) {
            this.values = null;
        }
    }

    public byte[] getNulls() {
        this.setNulls(TBaseHelper.rightSize((ByteBuffer)this.nulls));
        return this.nulls == null ? null : this.nulls.array();
    }

    public ByteBuffer bufferForNulls() {
        return TBaseHelper.copyBinary((ByteBuffer)this.nulls);
    }

    public void setNulls(byte[] nulls) {
        this.nulls = nulls == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(nulls, nulls.length));
    }

    public void setNulls(ByteBuffer nulls) {
        this.nulls = TBaseHelper.copyBinary((ByteBuffer)nulls);
    }

    public void unsetNulls() {
        this.nulls = null;
    }

    public boolean isSetNulls() {
        return this.nulls != null;
    }

    public void setNullsIsSet(boolean value) {
        if (!value) {
            this.nulls = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case VALUES: {
                if (value == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((List)value);
                break;
            }
            case NULLS: {
                if (value == null) {
                    this.unsetNulls();
                    break;
                }
                this.setNulls((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VALUES: {
                return this.getValues();
            }
            case NULLS: {
                return this.getNulls();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VALUES: {
                return this.isSetValues();
            }
            case NULLS: {
                return this.isSetNulls();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TDoubleColumn) {
            return this.equals((TDoubleColumn)that);
        }
        return false;
    }

    public boolean equals(TDoubleColumn that) {
        if (that == null) {
            return false;
        }
        boolean this_present_values = this.isSetValues();
        boolean that_present_values = that.isSetValues();
        if (this_present_values || that_present_values) {
            if (!this_present_values || !that_present_values) {
                return false;
            }
            if (!this.values.equals(that.values)) {
                return false;
            }
        }
        boolean this_present_nulls = this.isSetNulls();
        boolean that_present_nulls = that.isSetNulls();
        if (this_present_nulls || that_present_nulls) {
            if (!this_present_nulls || !that_present_nulls) {
                return false;
            }
            if (!this.nulls.equals(that.nulls)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_values = this.isSetValues();
        list.add(present_values);
        if (present_values) {
            list.add(this.values);
        }
        boolean present_nulls = this.isSetNulls();
        list.add(present_nulls);
        if (present_nulls) {
            list.add(this.nulls);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(TDoubleColumn other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetValues()).compareTo(other.isSetValues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValues() && (lastComparison = TBaseHelper.compareTo(this.values, other.values)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNulls()).compareTo(other.isSetNulls());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNulls() && (lastComparison = TBaseHelper.compareTo((Comparable)this.nulls, (Comparable)other.nulls)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TDoubleColumn(");
        boolean first = true;
        sb.append("values:");
        if (this.values == null) {
            sb.append("null");
        } else {
            sb.append(this.values);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("nulls:");
        if (this.nulls == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.nulls, (StringBuilder)sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetValues()) {
            throw new TProtocolException("Required field 'values' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNulls()) {
            throw new TProtocolException("Required field 'nulls' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TDoubleColumnStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TDoubleColumnTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VALUES, new FieldMetaData("values", 1, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(4))));
        tmpMap.put(_Fields.NULLS, new FieldMetaData("nulls", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TDoubleColumn.class, metaDataMap);
    }

    private static class TDoubleColumnTupleScheme
    extends TupleScheme<TDoubleColumn> {
        private TDoubleColumnTupleScheme() {
        }

        public void write(TProtocol prot, TDoubleColumn struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.values.size());
            Iterator iterator = struct.values.iterator();
            while (iterator.hasNext()) {
                double _iter98 = (Double)iterator.next();
                oprot.writeDouble(_iter98);
            }
            oprot.writeBinary(struct.nulls);
        }

        public void read(TProtocol prot, TDoubleColumn struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list99 = new TList(4, iprot.readI32());
            struct.values = new ArrayList(_list99.size);
            for (int _i101 = 0; _i101 < _list99.size; ++_i101) {
                double _elem100 = iprot.readDouble();
                struct.values.add(_elem100);
            }
            struct.setValuesIsSet(true);
            struct.nulls = iprot.readBinary();
            struct.setNullsIsSet(true);
        }
    }

    private static class TDoubleColumnTupleSchemeFactory
    implements SchemeFactory {
        private TDoubleColumnTupleSchemeFactory() {
        }

        public TDoubleColumnTupleScheme getScheme() {
            return new TDoubleColumnTupleScheme();
        }
    }

    private static class TDoubleColumnStandardScheme
    extends StandardScheme<TDoubleColumn> {
        private TDoubleColumnStandardScheme() {
        }

        public void read(TProtocol iprot, TDoubleColumn struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list94 = iprot.readListBegin();
                            struct.values = new ArrayList(_list94.size);
                            for (int _i96 = 0; _i96 < _list94.size; ++_i96) {
                                double _elem95 = iprot.readDouble();
                                struct.values.add(_elem95);
                            }
                            iprot.readListEnd();
                            struct.setValuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.nulls = iprot.readBinary();
                            struct.setNullsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TDoubleColumn struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.values != null) {
                oprot.writeFieldBegin(VALUES_FIELD_DESC);
                oprot.writeListBegin(new TList(4, struct.values.size()));
                Iterator iterator = struct.values.iterator();
                while (iterator.hasNext()) {
                    double _iter97 = (Double)iterator.next();
                    oprot.writeDouble(_iter97);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.nulls != null) {
                oprot.writeFieldBegin(NULLS_FIELD_DESC);
                oprot.writeBinary(struct.nulls);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TDoubleColumnStandardSchemeFactory
    implements SchemeFactory {
        private TDoubleColumnStandardSchemeFactory() {
        }

        public TDoubleColumnStandardScheme getScheme() {
            return new TDoubleColumnStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VALUES(1, "values"),
        NULLS(2, "nulls");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VALUES;
                }
                case 2: {
                    return NULLS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

