/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableDelaySubscriptionOther<T, U>
extends Observable<T> {
    final ObservableSource<? extends T> main;
    final ObservableSource<U> other;

    public ObservableDelaySubscriptionOther(ObservableSource<? extends T> main, ObservableSource<U> other) {
        this.main = main;
        this.other = other;
    }

    @Override
    public void subscribeActual(final Observer<? super T> child) {
        final SequentialDisposable serial = new SequentialDisposable();
        child.onSubscribe(serial);
        Observer otherObserver = new Observer<U>(){
            boolean done;

            @Override
            public void onSubscribe(Disposable d) {
                serial.update(d);
            }

            @Override
            public void onNext(U t) {
                this.onComplete();
            }

            @Override
            public void onError(Throwable e) {
                if (this.done) {
                    RxJavaPlugins.onError(e);
                    return;
                }
                this.done = true;
                child.onError(e);
            }

            @Override
            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                ObservableDelaySubscriptionOther.this.main.subscribe(new Observer<T>(){

                    @Override
                    public void onSubscribe(Disposable d) {
                        serial.update(d);
                    }

                    @Override
                    public void onNext(T value) {
                        child.onNext(value);
                    }

                    @Override
                    public void onError(Throwable e) {
                        child.onError(e);
                    }

                    @Override
                    public void onComplete() {
                        child.onComplete();
                    }
                });
            }
        };
        this.other.subscribe(otherObserver);
    }
}

