/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.impl.guesser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.rat.api.Document;
import org.apache.rat.document.impl.guesser.GuessUtils;

public class BinaryGuesser {
    private static final String DOT = ".";
    static final String FILE_ENCODING = "file.encoding";
    private static Charset CHARSET_FROM_FILE_ENCODING_OR_UTF8 = BinaryGuesser.getFileEncodingOrUTF8AsFallback();
    private static final String[] DATA_EXTENSIONS = new String[]{"DAT", "DOC", "NCB", "IDB", "SUO", "XCF", "RAJ", "CERT", "KS", "ODP", "SWF", "WOFF2", "WOFF", "TTF", "EOT"};
    private static final String[] EXE_EXTENSIONS = new String[]{"EXE", "DLL", "LIB", "SO", "A", "EXP"};
    private static final String[] KEYSTORE_EXTENSIONS = new String[]{"JKS", "KEYSTORE", "PEM", "CRL", "TRUSTSTORE"};
    private static final String[] IMAGE_EXTENSIONS = new String[]{"PNG", "PDF", "GIF", "GIFF", "TIF", "TIFF", "JPG", "JPEG", "ICO", "ICNS", "PSD"};
    private static final String[] BYTECODE_EXTENSIONS = new String[]{"CLASS", "PYD", "OBJ", "PYC"};
    private static final String[] AUDIO_EXTENSIONS = new String[]{"AIF", "IFF", "M3U", "M4A", "MID", "MP3", "MPA", "WAV", "WMA"};
    private static final String[] NON_BINARY_EXTENSIONS = new String[]{"AART", "AC", "AM", "BAT", "C", "CAT", "CGI", "CLASSPATH", "CMD", "CONFIG", "CPP", "CSS", "CWIKI", "DATA", "DCL", "DTD", "EGRM", "ENT", "FT", "FN", "FV", "GRM", "G", "GO", "H", "HTACCESS", "HTML", "IHTML", "IN", "JAVA", "JMX", "JSP", "JS", "JSON", "JUNIT", "JX", "M4", "MANIFEST", "MD", "MF", "META", "MOD", "N3", "PEN", "PL", "PM", "POD", "POM", "PROJECT", "PROPERTIES", "PY", "RB", "RDF", "RNC", "RNG", "RNX", "ROLES", "RSS", "SH", "SQL", "SVG", "TLD", "TXT", "TYPES", "VM", "VSL", "WSDD", "WSDL", "XARGS", "XCAT", "XCONF", "XEGRM", "XGRM", "XLEX", "XLOG", "XMAP", "XML", "XROLES", "XSAMPLES", "XSD", "XSL", "XSLT", "XSP", "XUL", "XWEB", "XWELCOME"};
    public static final String JAR_MANIFEST = "MANIFEST.MF";
    public static final String JAVA = "JAVA";
    public static final int HIGH_BYTES_RATIO = 100;
    public static final int TOTAL_READ_RATIO = 30;
    public static final int NON_ASCII_THRESHOLD = 256;
    public static final int ASCII_CHAR_THRESHOLD = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isBinaryDocument(Document document) {
        boolean result = false;
        InputStream stream = null;
        try {
            stream = document.inputStream();
            result = BinaryGuesser.isBinary(stream);
        }
        catch (IOException e) {
            result = false;
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
        return result;
    }

    private static boolean isBinary(CharSequence taste) {
        int highBytes = 0;
        int length = taste.length();
        for (int i = 0; i < length; ++i) {
            char c = taste.charAt(i);
            if (c <= '\u0100' && c > '\b') continue;
            ++highBytes;
        }
        return highBytes * 100 > length * 30;
    }

    public static boolean isBinary(Reader in) {
        char[] taste = new char[100];
        try {
            int bytesRead = in.read(taste);
            if (bytesRead > 0) {
                return BinaryGuesser.isBinary(new String(taste, 0, bytesRead));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isBinary(InputStream in) {
        try {
            byte[] taste = new byte[200];
            int bytesRead = in.read(taste);
            if (bytesRead > 0) {
                ByteBuffer bytes = ByteBuffer.wrap(taste, 0, bytesRead);
                CharBuffer chars = CharBuffer.allocate(2 * bytesRead);
                CharsetDecoder cd = CHARSET_FROM_FILE_ENCODING_OR_UTF8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                while (bytes.remaining() > 0) {
                    CoderResult res = cd.decode(bytes, chars, true);
                    if (res.isMalformed() || res.isUnmappable()) {
                        return true;
                    }
                    if (!res.isOverflow()) continue;
                    chars.limit(chars.position());
                    chars.rewind();
                    int c = chars.capacity() * 2;
                    CharBuffer on = CharBuffer.allocate(c);
                    on.put(chars);
                    chars = on;
                }
                chars.limit(chars.position());
                chars.rewind();
                return BinaryGuesser.isBinary(chars);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static Charset getFileEncodingOrUTF8AsFallback() {
        try {
            return Charset.forName(System.getProperty(FILE_ENCODING));
        }
        catch (UnsupportedCharsetException e) {
            return Charset.forName("UTF-8");
        }
    }

    public static final boolean isBinaryData(String name) {
        return BinaryGuesser.extensionMatches(name, DATA_EXTENSIONS);
    }

    public static final boolean isNonBinary(String name) {
        return name != null && BinaryGuesser.extensionMatches(name.toUpperCase(Locale.US), NON_BINARY_EXTENSIONS);
    }

    public static final boolean isExecutable(String name) {
        return name.equals(JAVA) || BinaryGuesser.extensionMatches(name, EXE_EXTENSIONS) || BinaryGuesser.containsExtension(name, EXE_EXTENSIONS);
    }

    public static boolean containsExtension(String name, String[] exts) {
        for (String ext : exts) {
            if (!name.contains(DOT + ext + DOT)) continue;
            return true;
        }
        return false;
    }

    public static boolean extensionMatches(String name, String[] exts) {
        for (String ext : exts) {
            if (!name.endsWith(DOT + ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBytecode(String name) {
        return BinaryGuesser.extensionMatches(name, BYTECODE_EXTENSIONS);
    }

    public static final boolean isImage(String name) {
        return BinaryGuesser.extensionMatches(name, IMAGE_EXTENSIONS);
    }

    public static final boolean isKeystore(String name) {
        return BinaryGuesser.extensionMatches(name, KEYSTORE_EXTENSIONS);
    }

    public static final boolean isAudio(String name) {
        return BinaryGuesser.extensionMatches(name, AUDIO_EXTENSIONS);
    }

    public static final boolean isBinary(String name) {
        if (name == null) {
            return false;
        }
        String normalisedName = GuessUtils.normalise(name);
        return JAR_MANIFEST.equalsIgnoreCase(name) || BinaryGuesser.isImage(normalisedName) || BinaryGuesser.isKeystore(normalisedName) || BinaryGuesser.isBytecode(normalisedName) || BinaryGuesser.isBinaryData(normalisedName) || BinaryGuesser.isExecutable(normalisedName) || BinaryGuesser.isAudio(normalisedName);
    }

    public static final boolean isBinary(Document document) {
        return BinaryGuesser.isBinary(document.getName()) || BinaryGuesser.isBinaryDocument(document);
    }
}

