/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes.local;

import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class StorageWithPlaceholders<T>
implements Cloneable {
    private int usedPlaceholders = 0;
    protected Map<String, StoragePlaceholder<T>> placeholdersWhenModified = new HashMap<String, StoragePlaceholder<T>>();
    private List<StoragePlaceholder<T>> placeholders = new ArrayList<StoragePlaceholder<T>>();

    public StoragePlaceholder<T> createPlaceholder() {
        StoragePlaceholder placeholder = new StoragePlaceholder();
        this.placeholders.add(placeholder);
        return placeholder;
    }

    public void closePlaceholder() {
        ++this.usedPlaceholders;
    }

    private int getPosition(String name) {
        StoragePlaceholder<T> previousPlaceholder = this.placeholdersWhenModified.get(name);
        if (previousPlaceholder == null) {
            return 0;
        }
        return this.placeholders.indexOf(previousPlaceholder) + 1;
    }

    protected int getPosition(StoragePlaceholder<T> placeholder) {
        return this.placeholders.indexOf(placeholder);
    }

    protected StoragePlaceholder<T> getFirstUnusedPlaceholder() {
        return this.placeholders.get(this.usedPlaceholders);
    }

    public void store(String name, T value) {
        this.placeholdersWhenModified.put(name, ArraysUtils.last(this.placeholders));
        this.doStore(name, value);
    }

    public void store(String name, List<T> value) {
        this.placeholdersWhenModified.put(name, ArraysUtils.last(this.placeholders));
        this.doStore(name, value);
    }

    protected List<StoragePlaceholder<T>> getPlaceholders() {
        return this.placeholders;
    }

    protected abstract void doStore(String var1, T var2);

    protected abstract void doStore(String var1, List<T> var2);

    protected boolean storedUnderPlaceholder(String name, StoragePlaceholder<T> placeholder) {
        return this.getPosition(name) <= this.getPosition(placeholder);
    }

    public String placeholdersReport() {
        return "registered: " + this.placeholders.size() + " used: " + this.usedPlaceholders;
    }

    public StorageWithPlaceholders<T> clone() {
        try {
            StorageWithPlaceholders clone = (StorageWithPlaceholders)super.clone();
            clone.placeholdersWhenModified = new HashMap<String, StoragePlaceholder<T>>(this.placeholdersWhenModified);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible state.");
        }
    }

    public static class StoragePlaceholder<T> {
    }
}

