/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.UUID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.LittleEndianBitConverter;

public class BitReader {
    private final long startPosition;
    private final long length;
    private BitSet bitSet;
    private long offset;

    public BitReader(byte[] array, int index) {
        this.startPosition = this.offset = (long)index * 8L - 1L;
        this.length = (long)array.length * 8L;
        this.bitSet = BitSet.valueOf(array);
    }

    private static String toBinaryString(BitSet bs, int nbits) {
        StringBuilder buffer = new StringBuilder(bs.size());
        for (int i = nbits - 1; i >= 0; --i) {
            if (i < bs.size()) {
                buffer.append(bs.get(i) ? "1" : "0");
                continue;
            }
            buffer.append("0");
        }
        return buffer.toString();
    }

    public boolean getCurrent() {
        return this.bitSet.get((int)this.offset);
    }

    public long readUInt64(int readingLength) throws IOException {
        byte[] uint64Bytes = this.getBytes(readingLength, 8);
        return LittleEndianBitConverter.toUInt64(uint64Bytes, 0);
    }

    public int readUInt32(int readingLength) throws IOException {
        byte[] uint32Bytes = this.getBytes(readingLength, 4);
        return LittleEndianBitConverter.toUInt32(uint32Bytes, 0);
    }

    public int readUInt16(int readingLength) throws IOException {
        byte[] uint16Bytes = this.getBytes(readingLength, 2);
        return LittleEndianBitConverter.ToUInt16(uint16Bytes, 0);
    }

    public byte[] readBytes(int readingLength) throws IOException {
        return this.getBytes(readingLength * 8, readingLength);
    }

    public short readInt16(int readingLength) throws IOException {
        byte[] uint16Bytes = this.getBytes(readingLength, 2);
        return LittleEndianBitConverter.toInt16(uint16Bytes, 0);
    }

    public int readInt32(int readingLength) throws IOException {
        byte[] uint32Bytes = this.getBytes(readingLength, 4);
        return LittleEndianBitConverter.toInt32(uint32Bytes, 0);
    }

    public UUID readGuid() throws IOException {
        return UUID.nameUUIDFromBytes(this.getBytes(128, 16));
    }

    public boolean moveNext() {
        return ++this.offset < this.length;
    }

    public void dispose() {
        this.bitSet = null;
    }

    public void reset() {
        this.offset = this.startPosition;
    }

    private byte[] getBytes(int needReadlength, int size) throws IOException {
        int i;
        BitSet retSet = new BitSet(size);
        for (i = 0; i < needReadlength; ++i) {
            if (!this.moveNext()) {
                throw new IOException("Unexpected to meet the byte array end.");
            }
            if (this.getCurrent()) {
                retSet.set(i);
                continue;
            }
            retSet.clear(i);
        }
        byte[] result = new byte[size];
        Arrays.fill(result, (byte)0);
        byte[] retSetBa = retSet.toByteArray();
        for (i = 0; i < retSetBa.length; ++i) {
            result[i] = retSetBa[i];
        }
        return result;
    }
}

