/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.CycleDetectedException;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectSorter;

public class DefaultProjectDependencyGraph
implements ProjectDependencyGraph {
    private final ProjectSorter sorter;
    private final List<MavenProject> allProjects;
    private final Map<MavenProject, Integer> order;
    private final Map<String, MavenProject> projects;

    public DefaultProjectDependencyGraph(Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this(projects, projects);
    }

    @Deprecated
    public DefaultProjectDependencyGraph(List<MavenProject> allProjects, Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this((Collection<MavenProject>)allProjects, projects);
    }

    public DefaultProjectDependencyGraph(Collection<MavenProject> allProjects, Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.allProjects = Collections.unmodifiableList(new ArrayList<MavenProject>(allProjects));
        this.sorter = new ProjectSorter(projects);
        this.order = new HashMap<MavenProject, Integer>();
        this.projects = new HashMap<String, MavenProject>();
        List<MavenProject> sorted = this.sorter.getSortedProjects();
        for (int index = 0; index < sorted.size(); ++index) {
            MavenProject project = sorted.get(index);
            String id = ProjectSorter.getId(project);
            this.projects.put(id, project);
            this.order.put(project, index);
        }
    }

    @Override
    public List<MavenProject> getAllProjects() {
        return this.allProjects;
    }

    @Override
    public List<MavenProject> getSortedProjects() {
        return new ArrayList<MavenProject>(this.sorter.getSortedProjects());
    }

    @Override
    public List<MavenProject> getDownstreamProjects(MavenProject project, boolean transitive) {
        Objects.requireNonNull(project, "project cannot be null");
        HashSet<String> projectIds = new HashSet<String>();
        this.getDownstreamProjects(ProjectSorter.getId(project), projectIds, transitive);
        return this.getSortedProjects(projectIds);
    }

    private void getDownstreamProjects(String projectId, Set<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependents(projectId)) {
            if (!projectIds.add(id) || !transitive) continue;
            this.getDownstreamProjects(id, projectIds, transitive);
        }
    }

    @Override
    public List<MavenProject> getUpstreamProjects(MavenProject project, boolean transitive) {
        Objects.requireNonNull(project, "project cannot be null");
        HashSet<String> projectIds = new HashSet<String>();
        this.getUpstreamProjects(ProjectSorter.getId(project), projectIds, transitive);
        return this.getSortedProjects(projectIds);
    }

    private void getUpstreamProjects(String projectId, Collection<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependencies(projectId)) {
            if (!projectIds.add(id) || !transitive) continue;
            this.getUpstreamProjects(id, projectIds, transitive);
        }
    }

    private List<MavenProject> getSortedProjects(Set<String> projectIds) {
        return projectIds.stream().map(this.projects::get).sorted(Comparator.comparingInt(this.order::get)).collect(Collectors.toList());
    }

    public String toString() {
        return this.sorter.getSortedProjects().toString();
    }
}

