/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal.dispatchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.components.secdispatcher.Cipher;
import org.codehaus.plexus.components.secdispatcher.Dispatcher;
import org.codehaus.plexus.components.secdispatcher.DispatcherMeta;
import org.codehaus.plexus.components.secdispatcher.MasterSource;
import org.codehaus.plexus.components.secdispatcher.MasterSourceMeta;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;

@Singleton
@Named(value="master")
public class MasterDispatcher
implements Dispatcher,
DispatcherMeta {
    public static final String NAME = "master";
    private static final String CONF_MASTER_CIPHER = "cipher";
    private static final String CONF_MASTER_SOURCE = "source";
    private static final String MASTER_CIPHER_ATTR = "cipher";
    protected final Map<String, Cipher> masterCiphers;
    protected final Map<String, MasterSource> masterSources;

    @Inject
    public MasterDispatcher(Map<String, Cipher> masterCiphers, Map<String, MasterSource> masterSources) {
        this.masterCiphers = masterCiphers;
        this.masterSources = masterSources;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String displayName() {
        return "Master Password Dispatcher";
    }

    @Override
    public Collection<DispatcherMeta.Field> fields() {
        return List.of(DispatcherMeta.Field.builder(CONF_MASTER_SOURCE).optional(false).description("Source of the master password").options(this.masterSources.entrySet().stream().map(e -> {
            MasterSource ms = (MasterSource)e.getValue();
            if (ms instanceof MasterSourceMeta) {
                MasterSourceMeta m = (MasterSourceMeta)((Object)ms);
                DispatcherMeta.Field.Builder b = DispatcherMeta.Field.builder((String)e.getKey()).description(m.description());
                if (m.configTemplate().isPresent()) {
                    b.defaultValue(m.configTemplate().get());
                }
                return b.build();
            }
            return DispatcherMeta.Field.builder((String)e.getKey()).description((String)e.getKey() + "(Field not described, needs manual configuration)").build();
        }).toList()).build(), DispatcherMeta.Field.builder("cipher").optional(false).description("Cipher to use with master password").options(this.masterCiphers.keySet().stream().map(c -> DispatcherMeta.Field.builder(c).description((String)c).build()).toList()).build());
    }

    @Override
    public Dispatcher.EncryptPayload encrypt(String str, Map<String, String> attributes, Map<String, String> config) throws SecDispatcherException {
        String masterCipher = this.getMasterCipher(config, true);
        String encrypted = this.requireCipher(masterCipher).encrypt(str, this.getMasterPassword(config));
        HashMap<String, String> attr = new HashMap<String, String>(attributes);
        attr.put("cipher", masterCipher);
        return new Dispatcher.EncryptPayload(attr, encrypted);
    }

    @Override
    public String decrypt(String str, Map<String, String> attributes, Map<String, String> config) throws SecDispatcherException {
        String masterCipher = this.getMasterCipher(attributes, false);
        return this.requireCipher(masterCipher).decrypt(str, this.getMasterPassword(config));
    }

    @Override
    public SecDispatcher.ValidationResponse validateConfiguration(Map<String, String> config) {
        HashMap<SecDispatcher.ValidationResponse.Level, List<String>> report = new HashMap<SecDispatcher.ValidationResponse.Level, List<String>>();
        ArrayList<SecDispatcher.ValidationResponse> subsystems = new ArrayList<SecDispatcher.ValidationResponse>();
        boolean valid = false;
        String masterCipher = config.get("cipher");
        if (masterCipher == null) {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Cipher configuration missing");
        } else if (!this.masterCiphers.containsKey(masterCipher)) {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Configured Cipher not supported");
        } else {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Configured Cipher supported");
        }
        String masterSource = config.get(CONF_MASTER_SOURCE);
        if (masterSource == null) {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Source configuration missing");
        } else {
            MasterSource masterPasswordSource;
            SecDispatcher.ValidationResponse masterSourceResponse = null;
            Iterator<MasterSource> iterator = this.masterSources.values().iterator();
            while (iterator.hasNext() && (masterSourceResponse = (masterPasswordSource = iterator.next()).validateConfiguration(masterSource)) == null) {
            }
            if (masterSourceResponse == null) {
                report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Configured Source configuration not handled");
            } else {
                subsystems.add(masterSourceResponse);
                if (!masterSourceResponse.isValid()) {
                    report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Configured Source configuration invalid");
                } else {
                    report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Configured Source configuration valid");
                    valid = true;
                }
            }
        }
        return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), valid, report, subsystems);
    }

    protected String getMasterPassword(Map<String, String> config) throws SecDispatcherException {
        String masterSource = config.get(CONF_MASTER_SOURCE);
        if (masterSource == null) {
            throw new SecDispatcherException("Invalid configuration: Missing configuration source");
        }
        for (MasterSource masterPasswordSource : this.masterSources.values()) {
            String masterPassword = masterPasswordSource.handle(masterSource);
            if (masterPassword == null) continue;
            return masterPassword;
        }
        throw new SecDispatcherException("No source handled the given masterSource: " + masterSource);
    }

    protected String getMasterCipher(Map<String, String> source, boolean config) throws SecDispatcherException {
        if (config) {
            String masterCipher = source.get("cipher");
            if (masterCipher == null) {
                throw new SecDispatcherException("Invalid configuration: Missing configuration cipher");
            }
            return masterCipher;
        }
        String masterCipher = source.get("cipher");
        if (masterCipher == null) {
            throw new SecDispatcherException("Malformed attributes: Missing attribute cipher");
        }
        return masterCipher;
    }

    protected Cipher requireCipher(String name) {
        Cipher masterCipher = this.masterCiphers.get(name);
        if (masterCipher == null) {
            throw new SecDispatcherException("No cipher exist with name " + name);
        }
        return masterCipher;
    }
}

