/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa.generic;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.pem.AbstractPEMResourceKeyPairParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSAUtils;

public class Ed25519PEMResourceKeyParser
extends AbstractPEMResourceKeyPairParser {
    public static final String BEGIN_MARKER = "BEGIN EDDSA PRIVATE KEY";
    public static final String BEGIN_ED25519_MARKER = "BEGIN ED25519 PRIVATE KEY";
    public static final List<String> BEGINNERS = GenericUtils.unmodifiableList("BEGIN EDDSA PRIVATE KEY", "BEGIN ED25519 PRIVATE KEY");
    public static final String END_MARKER = "END EDDSA PRIVATE KEY";
    public static final String END_ED25519_MARKER = "END ED25519 PRIVATE KEY";
    public static final List<String> ENDERS = GenericUtils.unmodifiableList("END EDDSA PRIVATE KEY", "END ED25519 PRIVATE KEY");
    public static final String ED25519_OID = "1.3.101.112";
    public static final Ed25519PEMResourceKeyParser INSTANCE = new Ed25519PEMResourceKeyParser();

    public Ed25519PEMResourceKeyParser() {
        super("Ed25519", ED25519_OID, BEGINNERS, ENDERS);
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, InputStream stream, Map<String, String> headers) throws IOException, GeneralSecurityException {
        KeyPair kp = Ed25519PEMResourceKeyParser.parseEd25519KeyPair(stream, false);
        return Collections.singletonList(kp);
    }

    public static KeyPair parseEd25519KeyPair(InputStream inputStream, boolean okToClose) throws IOException, GeneralSecurityException {
        try (DERParser parser = new DERParser(NoCloseInputStream.resolveInputStream(inputStream, okToClose));){
            KeyPair keyPair = Ed25519PEMResourceKeyParser.parseEd25519KeyPair(parser);
            return keyPair;
        }
    }

    public static KeyPair parseEd25519KeyPair(DERParser parser) throws IOException, GeneralSecurityException {
        List<Integer> curveOid;
        ASN1Object obj = parser.readObject();
        if (obj == null) {
            throw new StreamCorruptedException("Missing version value");
        }
        BigInteger version = obj.asInteger();
        if (!BigInteger.ZERO.equals(version)) {
            throw new StreamCorruptedException("Invalid version: " + version);
        }
        obj = parser.readObject();
        if (obj == null) {
            throw new StreamCorruptedException("Missing OID container");
        }
        ASN1Type objType = obj.getObjType();
        if (objType != ASN1Type.SEQUENCE) {
            throw new StreamCorruptedException("Unexpected OID object type: " + (Object)((Object)objType));
        }
        try (DERParser oidParser = obj.createParser();){
            obj = oidParser.readObject();
            if (obj == null) {
                throw new StreamCorruptedException("Missing OID value");
            }
            curveOid = obj.asOID();
        }
        String oid = GenericUtils.join(curveOid, '.');
        if (!ED25519_OID.equals(oid)) {
            throw new StreamCorruptedException("Unsupported curve OID: " + oid);
        }
        obj = parser.readObject();
        if (obj == null) {
            throw new StreamCorruptedException("Missing key data");
        }
        return Ed25519PEMResourceKeyParser.decodeEd25519KeyPair(obj.getValue());
    }

    public static KeyPair decodeEd25519KeyPair(byte[] keyData) throws IOException, GeneralSecurityException {
        PrivateKey privateKey = Ed25519PEMResourceKeyParser.decodeEdDSAPrivateKey(keyData);
        PublicKey publicKey = SecurityUtils.recoverEDDSAPublicKey(privateKey);
        return new KeyPair(publicKey, privateKey);
    }

    private static PrivateKey decodeEdDSAPrivateKey(byte[] keyData) throws IOException, GeneralSecurityException {
        try (DERParser parser = new DERParser(keyData);){
            ASN1Object obj = parser.readObject();
            if (obj == null) {
                throw new StreamCorruptedException("Missing key data container");
            }
            ASN1Type objType = obj.getObjType();
            if (objType != ASN1Type.OCTET_STRING) {
                throw new StreamCorruptedException("Mismatched key data container type: " + (Object)((Object)objType));
            }
            PrivateKey privateKey = EdDSAUtils.getPrivateKey(obj.getValue());
            return privateKey;
        }
    }
}

