/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.DHParameterSpec;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.pem.PEMResourceParserUtils;
import org.apache.sshd.common.random.JceRandomFactory;
import org.apache.sshd.common.random.RandomFactory;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.security.Decryptor;
import org.apache.sshd.common.util.security.KEM;
import org.apache.sshd.common.util.security.SecurityEntityFactory;
import org.apache.sshd.common.util.security.SecurityProviderChoice;
import org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SunECSecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SunJCESecurityProviderRegistrar;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleEncryptedPrivateKeyInfoDecryptor;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleGeneratorHostKeyProvider;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleKeyPairResourceParser;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleRandomFactory;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleSecurityProviderRegistrar;
import org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderRegistrar;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSAUtils;
import org.apache.sshd.common.util.security.eddsa.generic.OpenSSHEd25519PrivateKeyEntryDecoder;
import org.apache.sshd.common.util.security.eddsa.jce.JcePublicKeyFactory;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtils {
    public static final String BOUNCY_CASTLE = "BC";
    public static final String EDDSA = "EdDSA";
    public static final String ED25519 = "Ed25519";
    public static final String MIN_DHGEX_KEY_SIZE_PROP = "org.apache.sshd.minDHGexKeySize";
    public static final String MAX_DHGEX_KEY_SIZE_PROP = "org.apache.sshd.maxDHGexKeySize";
    public static final int MIN_DHGEX_KEY_SIZE = 2048;
    public static final int PREFERRED_DHGEX_KEY_SIZE = 4096;
    public static final int MAX_DHGEX_KEY_SIZE = 8192;
    public static final String SECURITY_PROVIDER_REGISTRARS = "org.apache.sshd.security.registrars";
    public static final List<String> DEFAULT_SECURITY_PROVIDER_REGISTRARS = Collections.unmodifiableList(Arrays.asList("org.apache.sshd.common.util.security.SunJCESecurityProviderRegistrar", "org.apache.sshd.common.util.security.SunECSecurityProviderRegistrar", "org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderRegistrar", "org.apache.sshd.common.util.security.bouncycastle.BouncyCastleSecurityProviderRegistrar"));
    public static final String PROP_DEFAULT_SECURITY_PROVIDER = "org.apache.sshd.security.defaultProvider";
    public static final String FIPS_ENABLED = "org.apache.sshd.security.fipsEnabled";
    private static final AtomicInteger MIN_DHG_KEY_SIZE_HOLDER = new AtomicInteger(0);
    private static final AtomicInteger MAX_DHG_KEY_SIZE_HOLDER = new AtomicInteger(0);
    private static final Map<String, Supplier<SecurityProviderRegistrar>> REGISTRAR_FACTORIES = SecurityUtils.buildRegistrarsMap();
    private static final Map<String, SecurityProviderRegistrar> REGISTERED_PROVIDERS = new LinkedHashMap<String, SecurityProviderRegistrar>();
    private static final AtomicReference<KeyPairResourceParser> KEYPAIRS_PARSER_HODLER = new AtomicReference();
    private static final Set<String> APRIORI_DISABLED_PROVIDERS = new TreeSet<String>();
    private static final AtomicBoolean REGISTRATION_STATE_HOLDER = new AtomicBoolean(false);
    private static final Map<Class<?>, Map<String, SecurityEntityFactory>> SECURITY_ENTITY_FACTORIES = new HashMap();
    private static final AtomicReference<SecurityProviderChoice> DEFAULT_PROVIDER_HOLDER = new AtomicReference();
    private static final AtomicReference<Boolean> FIPS_MODE = new AtomicReference();
    private static final AtomicReference<Boolean> EDDSA_SUPPORT_PRESENT = new AtomicReference();

    private SecurityUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    private static Map<String, Supplier<SecurityProviderRegistrar>> buildRegistrarsMap() {
        HashMap<String, Supplier<SecurityProviderRegistrar>> result = new HashMap<String, Supplier<SecurityProviderRegistrar>>();
        result.put("org.apache.sshd.common.util.security.SunJCESecurityProviderRegistrar", SunJCESecurityProviderRegistrar::new);
        result.put("org.apache.sshd.common.util.security.SunECSecurityProviderRegistrar", SunECSecurityProviderRegistrar::new);
        result.put("org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderRegistrar", EdDSASecurityProviderRegistrar::new);
        result.put("org.apache.sshd.common.util.security.bouncycastle.BouncyCastleSecurityProviderRegistrar", BouncyCastleSecurityProviderRegistrar::new);
        return Collections.unmodifiableMap(result);
    }

    public static void setFipsMode() {
        if (!FIPS_MODE.compareAndSet(null, Boolean.TRUE) && !Boolean.TRUE.equals(FIPS_MODE.get())) {
            throw new IllegalStateException("FIPS mode was already set to FALSE");
        }
    }

    public static boolean isFipsMode() {
        Boolean value = FIPS_MODE.get();
        if (FIPS_MODE.get() == null && !FIPS_MODE.compareAndSet(null, value = Boolean.valueOf(Boolean.getBoolean(FIPS_ENABLED)))) {
            value = FIPS_MODE.get();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAPrioriDisabledProvider(String name) {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No provider name specified");
        Set<String> set = APRIORI_DISABLED_PROVIDERS;
        synchronized (set) {
            return APRIORI_DISABLED_PROVIDERS.contains(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAPrioriDisabledProvider(String name, boolean disabled) {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No provider name specified");
        Set<String> set = APRIORI_DISABLED_PROVIDERS;
        synchronized (set) {
            if (disabled) {
                APRIORI_DISABLED_PROVIDERS.add(name);
            } else {
                APRIORI_DISABLED_PROVIDERS.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAPrioriDisabledProviders() {
        Set<String> set = APRIORI_DISABLED_PROVIDERS;
        synchronized (set) {
            return new TreeSet<String>(APRIORI_DISABLED_PROVIDERS);
        }
    }

    public static boolean isDHGroupExchangeSupported() {
        int maxSize = SecurityUtils.getMaxDHGroupExchangeKeySize();
        int minSize = SecurityUtils.getMinDHGroupExchangeKeySize();
        return minSize > 0 && maxSize > 0 && minSize <= maxSize;
    }

    public static boolean isDHOakelyGroupSupported(int keySize) {
        return SecurityUtils.isDHGroupExchangeSupported() && SecurityUtils.getMaxDHGroupExchangeKeySize() >= keySize;
    }

    public static int getMinDHGroupExchangeKeySize() {
        return SecurityUtils.resolveDHGEXKeySizeValue(MIN_DHG_KEY_SIZE_HOLDER, MIN_DHGEX_KEY_SIZE_PROP, 2048);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMinDHGroupExchangeKeySize(int keySize) {
        AtomicInteger atomicInteger = MIN_DHG_KEY_SIZE_HOLDER;
        synchronized (atomicInteger) {
            MIN_DHG_KEY_SIZE_HOLDER.set(keySize);
        }
    }

    public static int getMaxDHGroupExchangeKeySize() {
        return SecurityUtils.resolveDHGEXKeySizeValue(MAX_DHG_KEY_SIZE_HOLDER, MAX_DHGEX_KEY_SIZE_PROP, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxDHGroupExchangeKeySize(int keySize) {
        AtomicInteger atomicInteger = MAX_DHG_KEY_SIZE_HOLDER;
        synchronized (atomicInteger) {
            MAX_DHG_KEY_SIZE_HOLDER.set(keySize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int resolveDHGEXKeySizeValue(AtomicInteger holder, String propName, int maxKeySize) {
        int maxSupportedKeySize;
        AtomicInteger atomicInteger = holder;
        synchronized (atomicInteger) {
            maxSupportedKeySize = holder.get();
            if (maxSupportedKeySize != 0) {
                return maxSupportedKeySize;
            }
            String propValue = System.getProperty(propName);
            if (GenericUtils.isEmpty(propValue)) {
                maxSupportedKeySize = -1;
                for (int testKeySize = maxKeySize; testKeySize >= 2048; testKeySize -= 1024) {
                    if (!SecurityUtils.isDHGroupExchangeSupported(testKeySize)) continue;
                    maxSupportedKeySize = testKeySize;
                    break;
                }
            } else {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.info("Override DH group exchange key size via {}: {}", (Object)propName, (Object)propValue);
                maxSupportedKeySize = Integer.parseInt(propValue);
                ValidateUtils.checkTrue(maxSupportedKeySize != 0, "Configured " + propName + " value must be non-zero: %d", maxSupportedKeySize);
            }
            holder.set(maxSupportedKeySize);
        }
        return maxSupportedKeySize;
    }

    public static boolean isDHGroupExchangeSupported(int maxKeySize) {
        ValidateUtils.checkTrue(maxKeySize > 8, "Invalid max. key size: %d", maxKeySize);
        try {
            BigInteger r = BigInteger.ZERO.setBit(maxKeySize - 1);
            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(r, r);
            KeyPairGenerator kpg = SecurityUtils.getKeyPairGenerator("DH");
            kpg.initialize(dhSkipParamSpec);
            return true;
        }
        catch (GeneralSecurityException t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityProviderChoice getDefaultProviderChoice() {
        SecurityProviderChoice choice;
        AtomicReference<SecurityProviderChoice> atomicReference = DEFAULT_PROVIDER_HOLDER;
        synchronized (atomicReference) {
            choice = DEFAULT_PROVIDER_HOLDER.get();
            if (choice != null) {
                return choice;
            }
            String name = System.getProperty(PROP_DEFAULT_SECURITY_PROVIDER);
            choice = GenericUtils.isEmpty(name) || PropertyResolverUtils.isNoneValue(name) ? SecurityProviderChoice.EMPTY : SecurityProviderChoice.toSecurityProviderChoice(name);
            DEFAULT_PROVIDER_HOLDER.set(choice);
        }
        return choice;
    }

    public static void setDefaultProviderChoice(SecurityProviderChoice choice) {
        DEFAULT_PROVIDER_HOLDER.set(choice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getRegisteredProviders() {
        Map<String, SecurityProviderRegistrar> map = REGISTERED_PROVIDERS;
        synchronized (map) {
            return new TreeSet<String>(REGISTERED_PROVIDERS.keySet());
        }
    }

    public static boolean isBouncyCastleRegistered() {
        SecurityUtils.register();
        return SecurityUtils.isProviderRegistered(BOUNCY_CASTLE);
    }

    public static boolean isProviderRegistered(String provider) {
        return SecurityUtils.getRegisteredProvider(provider) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityProviderRegistrar getRegisteredProvider(String provider) {
        ValidateUtils.checkNotNullAndNotEmpty(provider, "No provider name specified");
        Map<String, SecurityProviderRegistrar> map = REGISTERED_PROVIDERS;
        synchronized (map) {
            return REGISTERED_PROVIDERS.get(provider);
        }
    }

    public static boolean isRegistrationCompleted() {
        return REGISTRATION_STATE_HOLDER.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register() {
        AtomicBoolean atomicBoolean = REGISTRATION_STATE_HOLDER;
        synchronized (atomicBoolean) {
            SecurityProviderChoice choice;
            if (REGISTRATION_STATE_HOLDER.get()) {
                return;
            }
            String regsList = System.getProperty(SECURITY_PROVIDER_REGISTRARS, GenericUtils.join(DEFAULT_SECURITY_PROVIDER_REGISTRARS, ','));
            boolean bouncyCastleRegistered = false;
            if (GenericUtils.length(regsList) > 0 && !PropertyResolverUtils.isNoneValue(regsList)) {
                String[] classes = GenericUtils.split(regsList, ',');
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                boolean debugEnabled = logger.isDebugEnabled();
                for (String registrarClass : classes) {
                    SecurityProviderRegistrar r;
                    Supplier<SecurityProviderRegistrar> factory = REGISTRAR_FACTORIES.get(registrarClass);
                    if (factory != null) {
                        r = factory.get();
                    } else {
                        try {
                            r = ThreadUtils.createDefaultInstance(SecurityUtils.class, SecurityProviderRegistrar.class, registrarClass);
                        }
                        catch (ReflectiveOperationException t) {
                            Throwable e = ExceptionUtils.peelException(t);
                            logger.error("Failed ({}) to create default {} registrar instance: {}", new Object[]{e.getClass().getSimpleName(), registrarClass, e.getMessage()});
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            if (e instanceof Error) {
                                throw (Error)e;
                            }
                            throw new IllegalStateException(e);
                        }
                    }
                    String name = r.getName();
                    SecurityProviderRegistrar registeredInstance = SecurityUtils.registerSecurityProvider(r);
                    if (registeredInstance == null) {
                        if (!debugEnabled) continue;
                        logger.debug("register({}) not registered - enabled={}, supported={}", new Object[]{name, r.isEnabled(), r.isSupported()});
                        continue;
                    }
                    if (!BOUNCY_CASTLE.equalsIgnoreCase(name)) continue;
                    bouncyCastleRegistered = true;
                }
            }
            if (((choice = SecurityUtils.getDefaultProviderChoice()) == null || choice == SecurityProviderChoice.EMPTY) && bouncyCastleRegistered) {
                SecurityUtils.setDefaultProviderChoice(SecurityProviderChoice.toSecurityProviderChoice(BOUNCY_CASTLE));
            }
            REGISTRATION_STATE_HOLDER.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityProviderRegistrar registerSecurityProvider(SecurityProviderRegistrar registrar) {
        Objects.requireNonNull(registrar, "No registrar instance to register");
        String name = registrar.getName();
        SecurityProviderRegistrar registeredInstance = SecurityUtils.getRegisteredProvider(name);
        if (registeredInstance == null && registrar.isEnabled() && registrar.isSupported()) {
            try {
                SecurityProviderRegistrar.registerSecurityProvider(registrar);
                Map<String, SecurityProviderRegistrar> map = REGISTERED_PROVIDERS;
                synchronized (map) {
                    REGISTERED_PROVIDERS.put(name, registrar);
                }
                return registrar;
            }
            catch (Throwable t) {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.error("Failed {} to register {} as a JCE provider: {}", new Object[]{t.getClass().getSimpleName(), name, t.getMessage()});
                throw new IllegalArgumentException("Failed to register " + name + " as a JCE provider", t);
            }
        }
        return registeredInstance;
    }

    public static Iterable<KeyPair> loadKeyPairIdentities(SessionContext session, NamedResource resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        KeyPairResourceParser parser = SecurityUtils.getKeyPairResourceParser();
        if (parser == null) {
            throw new NoSuchProviderException("No registered key-pair resource parser");
        }
        Collection<KeyPair> ids = parser.loadKeyPairs(session, resourceKey, provider, inputStream);
        int numLoaded = GenericUtils.size(ids);
        if (numLoaded <= 0) {
            return null;
        }
        return ids;
    }

    public static AbstractGeneratorHostKeyProvider createGeneratorHostKeyProvider(Path path) {
        ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        return new BouncyCastleGeneratorHostKeyProvider(path);
    }

    public static KeyPairResourceParser getBouncycastleKeyPairResourceParser() {
        ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        return BouncyCastleKeyPairResourceParser.INSTANCE;
    }

    public static Decryptor getBouncycastleEncryptedPrivateKeyInfoDecryptor() {
        ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        return BouncyCastleEncryptedPrivateKeyInfoDecryptor.INSTANCE;
    }

    public static RandomFactory getRandomFactory() {
        if (SecurityUtils.isBouncyCastleRegistered() && BouncyCastleRandomFactory.INSTANCE.isSupported()) {
            return BouncyCastleRandomFactory.INSTANCE;
        }
        return JceRandomFactory.INSTANCE;
    }

    public static boolean isEDDSACurveSupported() {
        Boolean isSupported = EDDSA_SUPPORT_PRESENT.get();
        if (isSupported == null) {
            SecurityUtils.register();
            try {
                KeyFactory factory = SecurityUtils.getKeyFactory(ED25519);
                isSupported = factory != null;
            }
            catch (GeneralSecurityException e) {
                isSupported = Boolean.FALSE;
            }
            if (!EDDSA_SUPPORT_PRESENT.compareAndSet(null, isSupported)) {
                isSupported = EDDSA_SUPPORT_PRESENT.get();
            }
        }
        return isSupported != null && isSupported != false;
    }

    public static PrivateKeyEntryDecoder getOpenSSHEDDSAPrivateKeyEntryDecoder() {
        return OpenSSHEd25519PrivateKeyEntryDecoder.INSTANCE;
    }

    public static boolean compareEDDSAPPublicKeys(PublicKey k1, PublicKey k2) {
        return EdDSAUtils.equals(k1, k2);
    }

    public static boolean compareEDDSAPrivateKeys(PrivateKey k1, PrivateKey k2) {
        return EdDSAUtils.equals(k1, k2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey recoverEDDSAPublicKey(PrivateKey key) throws GeneralSecurityException {
        Map<String, SecurityProviderRegistrar> map = REGISTERED_PROVIDERS;
        synchronized (map) {
            for (SecurityProviderRegistrar registrar : REGISTERED_PROVIDERS.values()) {
                PublicKey pk = registrar.getPublicKey(key);
                if (pk == null) continue;
                return pk;
            }
        }
        return new JcePublicKeyFactory().getPublicKey(key);
    }

    public static KeyPair extractEDDSAKeyPair(Buffer buffer, String keyType) throws GeneralSecurityException {
        if (!"ssh-ed25519".equals(keyType)) {
            throw new InvalidKeyException("Unsupported key type: " + keyType);
        }
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        throw new GeneralSecurityException("Full SSHD-440 implementation N/A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPairResourceParser getKeyPairResourceParser() {
        KeyPairResourceParser parser;
        AtomicReference<KeyPairResourceParser> atomicReference = KEYPAIRS_PARSER_HODLER;
        synchronized (atomicReference) {
            parser = KEYPAIRS_PARSER_HODLER.get();
            if (parser != null) {
                return parser;
            }
            parser = KeyPairResourceParser.aggregate(PEMResourceParserUtils.PROXY, OpenSSHKeyPairResourceParser.INSTANCE);
            KEYPAIRS_PARSER_HODLER.set(parser);
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKeyPairResourceParser(KeyPairResourceParser parser) {
        AtomicReference<KeyPairResourceParser> atomicReference = KEYPAIRS_PARSER_HODLER;
        synchronized (atomicReference) {
            KEYPAIRS_PARSER_HODLER.set(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityEntityFactory resolveSecurityEntityFactory(Class<?> entityType, String algorithm, Predicate<? super SecurityProviderRegistrar> entitySelector) {
        SecurityEntityFactory provider;
        Map factoriesMap;
        Map<Class<?>, Map<String, SecurityEntityFactory>> map = SECURITY_ENTITY_FACTORIES;
        synchronized (map) {
            factoriesMap = SECURITY_ENTITY_FACTORIES.computeIfAbsent(entityType, k -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        }
        Map map2 = factoriesMap;
        synchronized (map2) {
            provider = factoriesMap.computeIfAbsent(algorithm, k -> SecurityUtils.createSecurityEntityFactory(entitySelector));
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityEntityFactory createSecurityEntityFactory(Predicate<? super SecurityProviderRegistrar> entitySelector) {
        SecurityProviderRegistrar registrar;
        SecurityUtils.register();
        Map<String, SecurityProviderRegistrar> map = REGISTERED_PROVIDERS;
        synchronized (map) {
            registrar = SecurityProviderRegistrar.findSecurityProviderRegistrarBySecurityEntity(entitySelector, REGISTERED_PROVIDERS.values());
        }
        return SecurityUtils.getSecurityEntityProvider(registrar, SecurityUtils.getDefaultProviderChoice());
    }

    public static SecurityEntityFactory getSecurityEntityProvider(SecurityProviderRegistrar registrar, SecurityProviderChoice defaultProvider) {
        if (registrar == null) {
            if (defaultProvider == null || defaultProvider == SecurityProviderChoice.EMPTY) {
                return SecurityEntityFactory.Default.INSTANCE;
            }
            return defaultProvider.getFactory();
        }
        return registrar.getFactory();
    }

    public static AlgorithmParameters getAlgorithmParameters(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory factory = SecurityUtils.resolveSecurityEntityFactory(AlgorithmParameters.class, algorithm, r -> r.isSecurityEntitySupported(AlgorithmParameters.class, algorithm));
        return factory.createAlgorithmParameters(algorithm);
    }

    public static KeyFactory getKeyFactory(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory factory = SecurityUtils.resolveSecurityEntityFactory(KeyFactory.class, algorithm, r -> r.isKeyFactorySupported(algorithm));
        return factory.createKeyFactory(algorithm);
    }

    public static Cipher getCipher(String transformation) throws GeneralSecurityException {
        String algorithm = SecurityProviderRegistrar.getEffectiveSecurityEntityName(Cipher.class, transformation);
        SecurityEntityFactory factory = SecurityUtils.resolveSecurityEntityFactory(Cipher.class, algorithm, r -> r.isCipherSupported(algorithm));
        return factory.createCipher(transformation);
    }

    public static MessageDigest getMessageDigest(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory factory = SecurityUtils.resolveSecurityEntityFactory(MessageDigest.class, algorithm, r -> r.isMessageDigestSupported(algorithm));
        return factory.createMessageDigest(algorithm);
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory factory = SecurityUtils.resolveSecurityEntityFactory(KeyPairGenerator.class, algorithm, r -> r.isKeyPairGeneratorSupported(algorithm));
        return factory.createKeyPairGenerator(algorithm);
    }

    public static KeyAgreement getKeyAgreement(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory factory = SecurityUtils.resolveSecurityEntityFactory(KeyAgreement.class, algorithm, r -> r.isKeyAgreementSupported(algorithm));
        return factory.createKeyAgreement(algorithm);
    }

    public static Mac getMac(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory factory = SecurityUtils.resolveSecurityEntityFactory(Mac.class, algorithm, r -> r.isMacSupported(algorithm));
        return factory.createMac(algorithm);
    }

    public static Signature getSignature(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory factory = SecurityUtils.resolveSecurityEntityFactory(Signature.class, algorithm, r -> r.isSignatureSupported(algorithm));
        return factory.createSignature(algorithm);
    }

    public static CertificateFactory getCertificateFactory(String type) throws GeneralSecurityException {
        SecurityEntityFactory factory = SecurityUtils.resolveSecurityEntityFactory(CertificateFactory.class, type, r -> r.isCertificateFactorySupported(type));
        return factory.createCertificateFactory(type);
    }

    public static KEM getKEM(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory factory = SecurityUtils.resolveSecurityEntityFactory(KEM.class, algorithm, r -> r.isKEMSupported(algorithm));
        return factory.createKEM(algorithm);
    }
}

