/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa.generic;

import java.security.Signature;
import java.security.SignatureException;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.ValidateUtils;

public class SignatureEd25519
extends AbstractSignature {
    private static final int[] ED25519_ORDER = new int[]{237, 211, 245, 92, 26, 99, 18, 88, 214, 156, 247, 162, 222, 249, 222, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16};

    public SignatureEd25519() {
        super("Ed25519", "ssh-ed25519");
    }

    @Override
    public boolean verify(SessionContext session, byte[] sig) throws Exception {
        byte[] data = sig;
        Map.Entry<String, byte[]> encoding = this.extractEncodedSignature(data, "ssh-ed25519"::equalsIgnoreCase);
        if (encoding != null) {
            String keyType = encoding.getKey();
            ValidateUtils.checkTrue("ssh-ed25519".equals(keyType), "Mismatched key type: %s", (Object)keyType);
            data = encoding.getValue();
        }
        return this.doVerify(data);
    }

    @Override
    protected boolean doVerify(byte[] data) throws SignatureException {
        Signature verifier = Objects.requireNonNull(this.getSignature(), "Signature not initialized");
        if ("EdDSA".equals(verifier.getProvider().getName()) && (data.length != 64 || !SignatureEd25519.isValidFactor(data))) {
            return false;
        }
        return verifier.verify(data);
    }

    private static boolean isValidFactor(byte[] sig) {
        for (int i = 31; i >= 0; --i) {
            int y = (sig[i + 32] & 0xFF) - ED25519_ORDER[i];
            if (y == 0) continue;
            return y < 0;
        }
        return false;
    }
}

