/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.server.session.proxyprotocolv2.data;

import java.util.stream.Stream;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.contrib.server.session.proxyprotocolv2.exception.ProxyProtocolException;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;

public enum FamilyAndTransport {
    UNSPEC(0, 0, 0),
    TCP4(17, 4, 2),
    UDP4(18, 4, 2),
    TCP6(33, 16, 2),
    UDP6(34, 16, 2),
    SOCK_STREAM(49, 108, 0),
    SOCK_DGRAM(50, 108, 0);

    private final byte value;
    private final int addressLength;
    private final int portLength;

    private FamilyAndTransport(byte value, int addressLength, int portLength) {
        this.value = value;
        this.addressLength = addressLength;
        this.portLength = portLength;
    }

    public static FamilyAndTransport extractValue(Logger logger, ServerSession session, Buffer buffer) throws ProxyProtocolException {
        byte value = buffer.getByte();
        return Stream.of(FamilyAndTransport.values()).filter(val -> val.value == value).findFirst().orElseThrow(() -> ProxyProtocolException.buildFamilyAndTransport(logger, session, value));
    }

    public int getAddressLength() {
        return this.addressLength;
    }

    public int getDataLength() {
        return this.addressLength * 2 + this.portLength * 2;
    }

    public boolean hasInetAddress() {
        return this.addressLength > 0 && this.portLength > 0;
    }

    public boolean hasPort() {
        return this.portLength > 0;
    }

    public boolean hasSockAddress() {
        return this.addressLength > 0 && this.portLength == 0;
    }
}

