/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git;

import java.util.function.Supplier;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceProvider;
import org.apache.sshd.git.AbstractGitCommand;
import org.apache.sshd.git.GitLocationResolver;
import org.apache.sshd.git.GitLocationResolverCarrier;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.AbstractDelegatingCommandFactory;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.shell.UnknownCommand;

public abstract class AbstractGitCommandFactory
extends AbstractDelegatingCommandFactory
implements ExecutorServiceProvider,
GitLocationResolverCarrier {
    private final String cmdPrefix;
    private GitLocationResolver rootDirResolver;
    private Supplier<? extends CloseableExecutorService> executorsProvider;

    protected AbstractGitCommandFactory(String name, String cmdPrefix) {
        super(name);
        this.cmdPrefix = ValidateUtils.checkNotNullAndNotEmpty((String)cmdPrefix, (String)"No command prefix provided");
    }

    public String getCommandPrefix() {
        return this.cmdPrefix;
    }

    public Supplier<? extends CloseableExecutorService> getExecutorServiceProvider() {
        return this.executorsProvider;
    }

    public AbstractGitCommandFactory withExecutorServiceProvider(Supplier<? extends CloseableExecutorService> provider) {
        this.executorsProvider = provider;
        return this;
    }

    @Override
    public GitLocationResolver getGitLocationResolver() {
        return this.rootDirResolver;
    }

    public AbstractGitCommandFactory withGitLocationResolver(GitLocationResolver rootDirResolver) {
        this.rootDirResolver = rootDirResolver;
        return this;
    }

    public AbstractGitCommandFactory withDelegate(CommandFactory delegate) {
        this.setDelegateCommandFactory(delegate);
        return this;
    }

    public boolean isSupportedCommand(ChannelSession channel, String command) {
        if (GenericUtils.isEmpty((CharSequence)command)) {
            return false;
        }
        String prefix = this.getCommandPrefix();
        return command.startsWith(prefix);
    }

    protected Command executeSupportedCommand(ChannelSession channel, String command) {
        return this.createGitCommand(command);
    }

    protected Command createUnsupportedCommand(ChannelSession channel, String command) {
        return new UnknownCommand(command);
    }

    protected CloseableExecutorService resolveExecutorService(String command) {
        return this.resolveExecutorService();
    }

    protected abstract AbstractGitCommand createGitCommand(String var1);
}

