/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.exporter.util;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.commons.exporter.util.ComponentUtils;

public class PDFExporterUtil {
    private static void setPDFResponseHeaders(HttpServletResponse response, ByteArrayOutputStream byteArrayStream, String fileName) throws IOException {
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".pdf");
        response.setContentType("application/pdf");
        response.setContentLength(byteArrayStream.size());
        ServletOutputStream outputStream = response.getOutputStream();
        byteArrayStream.writeTo((OutputStream)outputStream);
        outputStream.flush();
    }

    private static void generateTableHeader(PdfPTable pdfTable, List columns) {
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = (UIColumn)columns.get(i);
            UIComponent columnHeaderCell = column.getHeader();
            if (!(columnHeaderCell instanceof ValueHolder)) continue;
            String cellValue = ComponentUtils.getStringValue(FacesContext.getCurrentInstance(), columnHeaderCell);
            pdfTable.addCell(cellValue);
        }
    }

    private static void generateTableContent(FacesContext facesContext, PdfPTable pdfTable, List columns, HtmlDataTable dataTable) {
        int numberOfColumns = columns.size();
        int numberOfRows = dataTable.getRowCount();
        int startFrom = 0;
        int endAt = numberOfRows;
        for (int i = startFrom; i < endAt; ++i) {
            dataTable.setRowIndex(i);
            for (int j = 0; j < numberOfColumns; ++j) {
                String cellValue = "";
                UIColumn currentColumn = (UIColumn)columns.get(j);
                for (int k = 0; k < currentColumn.getChildren().size(); ++k) {
                    if (!(currentColumn.getChildren().get(k) instanceof ValueHolder)) continue;
                    cellValue = cellValue + ((ValueHolder)currentColumn.getChildren().get(k)).getValue();
                }
                pdfTable.addCell(cellValue);
            }
        }
    }

    public static PdfPTable generatePDFTableModel(FacesContext facesContext, HtmlDataTable dataTable) {
        List columns = null;
        PdfPTable pdfTable = null;
        columns = ComponentUtils.getHTMLDataTableColumns(dataTable);
        if (columns.size() == 0) {
            return null;
        }
        int numberOfColumns = columns.size();
        pdfTable = new PdfPTable(numberOfColumns);
        PDFExporterUtil.generateTableHeader(pdfTable, columns);
        PDFExporterUtil.generateTableContent(facesContext, pdfTable, columns, dataTable);
        return pdfTable;
    }

    public static void generatePDF(FacesContext facesContext, HttpServletResponse response, String fileName, HtmlDataTable dataTable) throws Exception {
        Document document = new Document();
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        PdfWriter.getInstance((Document)document, (OutputStream)byteArrayStream);
        PdfPTable pdfTable = null;
        if (fileName == null) {
            fileName = dataTable.getId();
        }
        int currentRowIndex = dataTable.getRowIndex();
        pdfTable = PDFExporterUtil.generatePDFTableModel(facesContext, dataTable);
        document.open();
        document.add((Element)pdfTable);
        document.close();
        PDFExporterUtil.setPDFResponseHeaders(response, byteArrayStream, fileName);
        dataTable.setRowIndex(currentRowIndex);
    }
}

