/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TagUtils {
    private static final Log LOG = LogFactory.getLog(TagUtils.class);

    private TagUtils() {
    }

    public static ValueExpression getValueExpression(String valueExpression, Class<?> expectedType) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        ExpressionFactory fact = context.getApplication().getExpressionFactory();
        return fact.createValueExpression(elContext, valueExpression, expectedType);
    }

    public static void assertNotNull(Object object) {
        if (null == object) {
            throw new NullPointerException();
        }
    }

    public static String getString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static boolean getBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public static int getInteger(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    public static long getLong(Object value) {
        if (value == null) {
            return 0L;
        }
        return Long.valueOf(value.toString());
    }

    public static double getDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        return Double.valueOf(value.toString());
    }

    public static float getFloat(Object value) {
        if (value == null) {
            return 0.0f;
        }
        return Float.valueOf(value.toString()).floatValue();
    }

    public static String[] getStringArray(Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        return TagUtils.getTokensArray(value.toString());
    }

    public static Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return TagUtils.parseISODate(value.toString());
    }

    public static Locale getLocale(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Locale) {
            return (Locale)value;
        }
        return TagUtils.getLocaleInternal(value.toString());
    }

    public static boolean isValueReference(String expression) {
        int start;
        return null != expression && (start = expression.indexOf("#{")) >= 0 && expression.indexOf(125, start + 1) >= 0;
    }

    private static String[] getTokensArray(String tokenComposite) throws ParseException {
        if (tokenComposite == null || "".equals(tokenComposite)) {
            return null;
        }
        return TagUtils.parseNameTokens(tokenComposite);
    }

    private static final Date parseISODate(String stringValue) {
        try {
            return TagUtils.getDateFormat().parse(stringValue);
        }
        catch (ParseException pe) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("CANNOT_PARSE_VALUE_INTO_DATE_WITH_YYYY_MM_DD_PATTERN " + stringValue), (Throwable)pe);
            }
            return null;
        }
    }

    public static String[] parseNameTokens(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(5);
        int length = stringValue.length();
        boolean inSpace = true;
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char ch = stringValue.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (inSpace) continue;
                list.add(stringValue.substring(start, i));
                inSpace = true;
                continue;
            }
            if (!inSpace) continue;
            start = i;
            inSpace = false;
        }
        if (!inSpace) {
            list.add(stringValue.substring(start));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private static Locale getLocaleInternal(String locale) {
        String localeStr = locale.replace('-', '_');
        String[] tokens = localeStr.split("[_]", 3);
        Locale locl = null;
        if (tokens.length == 1) {
            locl = new Locale(tokens[0]);
        } else if (tokens.length == 2) {
            locl = new Locale(tokens[0], tokens[1]);
        } else if (tokens.length == 3) {
            locl = new Locale(tokens[0], tokens[1], tokens[2]);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"tokens length should not be greater than 3.");
        }
        return locl;
    }

    private static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }
}

