/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.myfaces.shared.util.ClassUtils;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public class IllegalXmlCharacterFilterWriter
extends FilterWriter {
    private static final char BLANK_CHAR = ' ';
    private static boolean java16;

    public IllegalXmlCharacterFilterWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        if (java16) {
            super.write(c);
            return;
        }
        if (IllegalXmlCharacterFilterWriter.isInvalidChar(c)) {
            super.write(32);
        } else {
            super.write(c);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (java16) {
            super.write(cbuf, off, len);
            return;
        }
        super.write(IllegalXmlCharacterFilterWriter.encodeCharArray(cbuf, off, len), off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (java16) {
            super.write(str, off, len);
            return;
        }
        super.write(IllegalXmlCharacterFilterWriter.encodeString(str, off, len), off, len);
    }

    @IgnoreJRERequirement
    private static String encodeString(String str, int off, int len) {
        if (str == null) {
            return null;
        }
        int to = off + len;
        boolean surrogateResolved = false;
        char[] encoded = null;
        for (int i = off; i < to; ++i) {
            char cNext;
            int c;
            if (surrogateResolved) {
                surrogateResolved = false;
                continue;
            }
            int codePoint = c = str.charAt(i);
            if (Character.isHighSurrogate((char)c) && i + 1 < to && Character.isLowSurrogate(cNext = str.charAt(i + 1))) {
                codePoint = Character.toCodePoint((char)c, cNext);
                surrogateResolved = true;
            }
            if ((surrogateResolved || !Character.isSurrogate((char)c)) && !IllegalXmlCharacterFilterWriter.isInvalidChar(codePoint)) continue;
            if (encoded == null) {
                encoded = str.toCharArray();
            }
            encoded[i] = 32;
            if (!surrogateResolved) continue;
            encoded[i + 1] = 32;
        }
        if (encoded != null) {
            return String.valueOf(encoded);
        }
        return str;
    }

    @IgnoreJRERequirement
    private static char[] encodeCharArray(char[] cbuf, int off, int len) {
        if (cbuf == null) {
            return null;
        }
        int to = off + len;
        boolean surrogateResolved = false;
        for (int i = off; i < to; ++i) {
            char cNext;
            int c;
            if (surrogateResolved) {
                surrogateResolved = false;
                continue;
            }
            int codePoint = c = cbuf[i];
            if (Character.isHighSurrogate((char)c) && i + 1 < to && Character.isLowSurrogate(cNext = cbuf[i + 1])) {
                codePoint = Character.toCodePoint((char)c, cNext);
                surrogateResolved = true;
            }
            if ((surrogateResolved || !Character.isSurrogate((char)c)) && !IllegalXmlCharacterFilterWriter.isInvalidChar(codePoint)) continue;
            cbuf[i] = 32;
            if (!surrogateResolved) continue;
            cbuf[i + 1] = 32;
        }
        return cbuf;
    }

    private static boolean isInvalidChar(int codePoint) {
        if (codePoint == 1113088) {
            return true;
        }
        if (codePoint == 9 || codePoint == 10 || codePoint == 13) {
            return false;
        }
        if (codePoint >= 32 && codePoint <= 55295) {
            return false;
        }
        if (codePoint >= 57344 && codePoint <= 65533) {
            return false;
        }
        return codePoint < 65536 || codePoint > 0x10FFFF;
    }

    static {
        try {
            java16 = ClassUtils.classForName("java.util.Objects") == null;
        }
        catch (Throwable e) {
            java16 = true;
        }
        if (java16) {
            System.err.println("Skip using " + IllegalXmlCharacterFilterWriter.class.getName() + ", it's only available in Java 1.6+");
        }
    }
}

