/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlForm;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonEventUtils;
import org.apache.myfaces.renderkit.html.util.CommonPropertyUtils;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.HttpPartWrapper;
import org.apache.myfaces.util.lang.Assert;

public class HtmlInputFileRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlInputFileRendererBase.class.getName());
    private static final String AUTOCOMPLETE_VALUE_OFF = "off";

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        try {
            Part part = ((HttpServletRequest)facesContext.getExternalContext().getRequest()).getPart(component.getClientId());
            if (part == null) {
                return;
            }
            ((UIInput)component).setSubmittedValue(new HttpPartWrapper(part));
        }
        catch (IOException | ServletException e) {
            throw new FacesException(e);
        }
        if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
            ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, component);
        }
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String content;
        UIForm form;
        this.renderInput(facesContext, component);
        if (!facesContext.isProjectStage(ProjectStage.Production) && facesContext.isPostback() && (facesContext.getPartialViewContext().isPartialRequest() || facesContext.getPartialViewContext().isAjaxRequest()) && (form = ComponentUtils.findClosest(UIForm.class, component)) != null && form instanceof HtmlForm && ((content = ((HtmlForm)form).getEnctype()) == null || !content.contains("multipart/form-data"))) {
            FacesMessage message = new FacesMessage("file upload requires a form with enctype equal to multipart/form-data");
            facesContext.addMessage(component.getClientId(), message);
        }
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Assert.notNull(context, "context");
        Assert.notNull(component, "component");
        return submittedValue;
    }

    protected String getInputHtmlType(UIComponent component) {
        return "file";
    }

    protected void renderValue(FacesContext facesContext, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected boolean isRenderOutputEventAttributes() {
        return true;
    }

    protected void renderInput(FacesContext facesContext, UIComponent component) throws IOException {
        this.renderInputBegin(facesContext, component);
        this.renderInputEnd(facesContext, component);
    }

    protected void renderInputBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.startElement("input", component);
        writer.writeAttribute("id", clientId, null);
        writer.writeAttribute("name", clientId, null);
        String inputHtmlType = this.getInputHtmlType(component);
        writer.writeAttribute("type", inputHtmlType, null);
        this.renderValue(facesContext, component, writer);
        Map<String, List<ClientBehavior>> behaviors = null;
        if (component instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)((Object)component)).getClientBehaviors();
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderChangeEventProperty(writer, commonPropertiesMarked, component);
                CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, component);
                CommonPropertyUtils.renderFieldEventPropertiesWithoutOnchange(writer, commonPropertiesMarked, component);
            } else {
                HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, component, behaviors);
                if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(component);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, component, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, component, behaviors);
                }
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderInputPassthroughPropertiesWithoutDisabledAndEvents(writer, commonPropertiesMarked, component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            CommonPropertyUtils.renderInputPassthroughPropertiesWithoutDisabled(writer, CommonPropertyUtils.getCommonPropertiesMarked(component), component);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (this.isDisabled(facesContext, component)) {
            writer.writeAttribute("disabled", "disabled", null);
        }
        if (this.isAutocompleteOff(facesContext, component)) {
            writer.writeAttribute("autocomplete", AUTOCOMPLETE_VALUE_OFF, "autocomplete");
        }
    }

    protected void renderInputEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("input");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlInputText) {
            return ((HtmlInputText)component).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(component, "disabled", false);
    }

    protected boolean isAutocompleteOff(FacesContext facesContext, UIComponent component) {
        String autocomplete;
        if (component instanceof HtmlInputText && (autocomplete = ((HtmlInputText)component).getAutocomplete()) != null) {
            return autocomplete.equals(AUTOCOMPLETE_VALUE_OFF);
        }
        return false;
    }

    public static void renderOutputText(FacesContext facesContext, UIComponent component, String text, boolean escape) throws IOException {
        if (text != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            boolean span = false;
            if (component.getId() != null && !component.getId().startsWith("j_id")) {
                span = true;
                writer.startElement("span", component);
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
            if (escape) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("renderOutputText writing '" + text + '\'');
                }
                writer.writeText(text, "value");
            } else {
                writer.write(text);
            }
            if (span) {
                writer.endElement("span");
            }
        }
    }
}

