/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push.cdi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import org.apache.myfaces.push.cdi.WebsocketChannel;
import org.apache.myfaces.push.cdi.WebsocketChannelMetadata;

@SessionScoped
public class WebsocketSessionBean
implements Serializable {
    private Map<String, List<WebsocketChannel>> channelTokenListMap = new ConcurrentHashMap<String, List<WebsocketChannel>>(2);
    private Map<String, WebsocketChannelMetadata> tokenMap = new ConcurrentHashMap<String, WebsocketChannelMetadata>();

    public void registerToken(String token, WebsocketChannelMetadata metadata) {
        this.tokenMap.put(token, metadata);
    }

    public void registerWebsocketSession(String token, WebsocketChannelMetadata metadata) {
        if ("session".equals(metadata.getScope())) {
            this.channelTokenListMap.putIfAbsent(metadata.getChannel(), new ArrayList(1));
            this.channelTokenListMap.get(metadata.getChannel()).add(new WebsocketChannel(token, metadata));
        }
    }

    public boolean isTokenValid(String token) {
        return this.tokenMap.containsKey(token);
    }

    public Serializable getUserFromChannelToken(String channelToken) {
        WebsocketChannelMetadata metadata;
        if (this.tokenMap != null && (metadata = this.tokenMap.get(channelToken)) != null) {
            return metadata.getUser();
        }
        return null;
    }

    public boolean isChannelAvailable(String channel) {
        return this.channelTokenListMap.containsKey(channel);
    }

    public List<String> getChannelTokensFor(String channel) {
        List<WebsocketChannel> list = this.channelTokenListMap.get(channel);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> value = new ArrayList<String>(list.size());
            for (WebsocketChannel md : list) {
                value.add(md.getChannelToken());
            }
            return value;
        }
        return Collections.emptyList();
    }

    public <S extends Serializable> List<String> getChannelTokensFor(String channel, S user) {
        List<WebsocketChannel> list = this.channelTokenListMap.get(channel);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> value = new ArrayList<String>(list.size());
            for (WebsocketChannel md : list) {
                if (!user.equals(md.getUser())) continue;
                value.add(md.getChannelToken());
            }
            return value;
        }
        return null;
    }

    @PreDestroy
    public void destroy() {
        this.channelTokenListMap.clear();
        this.tokenMap.clear();
    }

    public void destroyChannelToken(String channelToken) {
        String channel = null;
        for (Map.Entry<String, List<WebsocketChannel>> entry : this.channelTokenListMap.entrySet()) {
            Iterator<WebsocketChannel> it = entry.getValue().iterator();
            while (it.hasNext()) {
                WebsocketChannel wschannel = it.next();
                if (!channelToken.equals(wschannel.getChannelToken())) continue;
                it.remove();
                break;
            }
            if (!entry.getValue().isEmpty()) continue;
            channel = entry.getKey();
        }
        if (channel != null) {
            this.channelTokenListMap.remove(channel);
        }
        this.tokenMap.remove(channelToken);
    }
}

