/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.myfaces.lifecycle.LifecycleImpl;

public class LifecycleFactoryImpl
extends LifecycleFactory {
    private final Map<String, Lifecycle> _lifecycles = new ConcurrentHashMap<String, Lifecycle>();

    public LifecycleFactoryImpl() {
        this.addLifecycle("DEFAULT", new LifecycleImpl());
    }

    public void purgeLifecycle() {
        this._lifecycles.clear();
        this.addLifecycle("DEFAULT", new LifecycleImpl());
    }

    public void addLifecycle(String id, Lifecycle lifecycle) {
        if (this._lifecycles.get(id) != null) {
            throw new IllegalArgumentException("Lifecycle with id '" + id + "' already exists.");
        }
        this._lifecycles.put(id, lifecycle);
    }

    public Lifecycle getLifecycle(String id) throws FacesException {
        Lifecycle lifecycle = this._lifecycles.get(id);
        if (lifecycle == null) {
            throw new IllegalArgumentException("Unknown lifecycle '" + id + "'.");
        }
        return lifecycle;
    }

    public Iterator<String> getLifecycleIds() {
        return this._lifecycles.keySet().iterator();
    }
}

