/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.validator;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.FacesException;
import jakarta.faces.validator.Validator;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.cdi.util.AbstractDynamicProducer;
import org.apache.myfaces.cdi.validator.FacesValidatorAnnotationLiteral;
import org.apache.myfaces.cdi.validator.FacesValidatorInfo;
import org.apache.myfaces.shared.util.ClassUtils;

@Typed
public class FacesValidatorProducer
extends AbstractDynamicProducer<Validator> {
    public FacesValidatorProducer(BeanManager beanManager, FacesValidatorInfo typeInfo) {
        super(beanManager);
        String validatorId = typeInfo.getValidatorId() == null ? "" : typeInfo.getValidatorId();
        String id = "" + typeInfo.getType() + "_" + validatorId;
        FacesValidatorAnnotationLiteral literal = new FacesValidatorAnnotationLiteral(typeInfo.getValidatorId() == null ? "" : typeInfo.getValidatorId(), false, true);
        super.id(id).scope(Dependent.class).qualifiers(literal).types(new Type[]{typeInfo.getType(), Object.class}).beanClass(ClassUtils.simpleClassForName(typeInfo.getType().getTypeName())).create((CreationalContext<T> e) -> this.createValidator((CreationalContext<Validator>)e));
    }

    protected Validator createValidator(CreationalContext<Validator> cc) {
        Class<?> converterClass = this.getBeanClass();
        Validator converter = null;
        try {
            converter = (Validator)converterClass.newInstance();
        }
        catch (Exception ex) {
            Logger.getLogger(FacesValidatorProducer.class.getName()).log(Level.SEVERE, "Could not instantiate converter " + converterClass.getName(), ex);
            throw new FacesException("Could not instantiate converter: " + converterClass.getName(), ex);
        }
        return converter;
    }
}

