/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.view;

import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceVisitOption;
import jakarta.faces.application.ViewVisitOption;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.StateManagementStrategy;
import jakarta.faces.view.ViewMetadata;
import java.beans.BeanInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public abstract class ViewDeclarationLanguage {
    public static final String JSP_VIEW_DECLARATION_LANGUAGE_ID = "java.faces.JSP";
    public static final String FACELETS_VIEW_DECLARATION_LANGUAGE_ID = "java.faces.Facelets";

    public abstract void buildView(FacesContext var1, UIViewRoot var2) throws IOException;

    public abstract UIViewRoot createView(FacesContext var1, String var2);

    public abstract BeanInfo getComponentMetadata(FacesContext var1, Resource var2);

    public abstract Resource getScriptComponentResource(FacesContext var1, Resource var2);

    public abstract StateManagementStrategy getStateManagementStrategy(FacesContext var1, String var2);

    public abstract ViewMetadata getViewMetadata(FacesContext var1, String var2);

    public abstract void renderView(FacesContext var1, UIViewRoot var2) throws IOException;

    public abstract UIViewRoot restoreView(FacesContext var1, String var2);

    public void retargetAttachedObjects(FacesContext context, UIComponent topLevelComponent, List<AttachedObjectHandler> handlers) {
        throw new UnsupportedOperationException();
    }

    public void retargetMethodExpressions(FacesContext context, UIComponent topLevelComponent) {
        throw new UnsupportedOperationException();
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean viewExists(FacesContext facesContext, String viewId) {
        try {
            return facesContext.getExternalContext().getResource(viewId) != null;
        }
        catch (MalformedURLException e) {
            Logger log = Logger.getLogger(ViewDeclarationLanguage.class.getName());
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Malformed URL viewId: " + viewId, e);
            }
            return false;
        }
    }

    public UIComponent createComponent(FacesContext context, String taglibURI, String tagName, Map<String, Object> attributes) {
        return null;
    }

    public List<String> calculateResourceLibraryContracts(FacesContext context, String viewId) {
        return null;
    }

    public Stream<String> getViews(FacesContext facesContext, String path, ViewVisitOption ... options) {
        return this.getViews(facesContext, path, Integer.MAX_VALUE, options);
    }

    public Stream<String> getViews(FacesContext facesContext, String path, int maxDepth, ViewVisitOption ... options) {
        return facesContext.getApplication().getResourceHandler().getViewResources(facesContext, path, maxDepth, ResourceVisitOption.TOP_LEVEL_VIEWS_ONLY);
    }
}

