/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.application;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.FacesContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared.util.ConcurrentLRUCache;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

public class CheckedViewIdsCache {
    private static final Logger LOG = Logger.getLogger(CheckedViewIdsCache.class.getName());
    private static final String INSTANCE_KEY = CheckedViewIdsCache.class.getName();
    private static final String CHECKED_VIEWID_CACHE_SIZE_ATTRIBUTE = "org.apache.myfaces.CHECKED_VIEWID_CACHE_SIZE";
    private static final String CHECKED_VIEWID_CACHE_ENABLED_ATTRIBUTE = "org.apache.myfaces.CHECKED_VIEWID_CACHE_ENABLED";
    private volatile ConcurrentLRUCache<String, Boolean> cache = null;
    private boolean enabled;
    private int size;

    private CheckedViewIdsCache() {
    }

    public void init(FacesContext facesContext) {
        this.enabled = facesContext.isProjectStage(ProjectStage.Development) ? false : WebConfigParamUtils.getBooleanInitParameter(facesContext.getExternalContext(), CHECKED_VIEWID_CACHE_ENABLED_ATTRIBUTE, true);
        this.size = WebConfigParamUtils.getIntegerInitParameter(facesContext.getExternalContext(), CHECKED_VIEWID_CACHE_SIZE_ATTRIBUTE, 500);
        this.cache = new ConcurrentLRUCache((this.size * 4 + 3) / 3, this.size);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "MyFaces CheckedViewIdsCache enabled=" + this.enabled + ", size=" + this.size);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ConcurrentLRUCache<String, Boolean> getCache() {
        return this.cache;
    }

    public static CheckedViewIdsCache getInstance(FacesContext facesContext) {
        CheckedViewIdsCache instance = (CheckedViewIdsCache)facesContext.getExternalContext().getApplicationMap().get(INSTANCE_KEY);
        if (instance == null) {
            instance = new CheckedViewIdsCache();
            instance.init(facesContext);
            facesContext.getExternalContext().getApplicationMap().put(INSTANCE_KEY, instance);
        }
        return instance;
    }
}

