/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.MetadataTarget;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import org.apache.myfaces.view.facelets.tag.LambdaMetadataTargetImpl;

public final class BeanPropertyTagRule
extends MetaRule {
    public static final BeanPropertyTagRule INSTANCE = new BeanPropertyTagRule();

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta instanceof LambdaMetadataTargetImpl) {
            BiConsumer<Object, Object> f = ((LambdaMetadataTargetImpl)meta).getWriteFunction(name);
            if (f != null) {
                if (attribute.isLiteral()) {
                    return new LiteralPropertyMetadata(meta.getPropertyType(name), f, attribute);
                }
                return new DynamicPropertyMetadata(meta.getPropertyType(name), f, attribute);
            }
        } else {
            Method m = meta.getWriteMethod(name);
            if (m != null) {
                if (attribute.isLiteral()) {
                    return new LiteralPropertyMetadata(meta.getPropertyType(name), m, attribute);
                }
                return new DynamicPropertyMetadata(meta.getPropertyType(name), m, attribute);
            }
        }
        return null;
    }

    static final class DynamicPropertyMetadata
    extends Metadata {
        private final Class<?> propertyType;
        private final Method method;
        private final BiConsumer<Object, Object> function;
        private final TagAttribute attribute;

        public DynamicPropertyMetadata(Class<?> propertyType, Method method, TagAttribute attribute) {
            this.propertyType = propertyType;
            this.method = method;
            this.function = null;
            this.attribute = attribute;
        }

        public DynamicPropertyMetadata(Class<?> propertyType, BiConsumer<Object, Object> function, TagAttribute attribute) {
            this.propertyType = propertyType;
            this.method = null;
            this.function = function;
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            try {
                if (this.method != null) {
                    this.method.invoke(instance, this.attribute.getObject(ctx, this.propertyType));
                } else if (this.function != null) {
                    this.function.accept(instance, this.attribute.getObject(ctx, this.propertyType));
                }
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this.attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.attribute, (Throwable)e);
            }
        }
    }

    static final class LiteralPropertyMetadata
    extends Metadata {
        private final Class<?> propertyType;
        private final Method method;
        private final BiConsumer<Object, Object> function;
        private final TagAttribute attribute;
        private Object value;
        private Object[] valueArgs;

        public LiteralPropertyMetadata(Class<?> propertyType, Method method, TagAttribute attribute) {
            this.propertyType = propertyType;
            this.method = method;
            this.function = null;
            this.attribute = attribute;
        }

        public LiteralPropertyMetadata(Class<?> propertyType, BiConsumer<Object, Object> function, TagAttribute attribute) {
            this.propertyType = propertyType;
            this.method = null;
            this.function = function;
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            try {
                if (this.function != null) {
                    if (this.value == null) {
                        String str = this.attribute.getValue();
                        this.value = ctx.getExpressionFactory().coerceToType((Object)str, this.propertyType);
                    }
                    this.function.accept(instance, this.value);
                } else if (this.method != null) {
                    if (this.valueArgs == null) {
                        String str = this.attribute.getValue();
                        this.valueArgs = new Object[]{ctx.getExpressionFactory().coerceToType((Object)str, this.propertyType)};
                    }
                    this.method.invoke(instance, this.valueArgs);
                }
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this.attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.attribute, (Throwable)e);
            }
        }
    }
}

