/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.clientwindow;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.faces.lifecycle.ClientWindowScoped;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.myfaces.cdi.clientwindow.ClientWindowScopeContextualStorageHolder;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;

@Typed
public class ClientWindowScopeContext
implements Context {
    private BeanManager beanManager;

    public ClientWindowScopeContext(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return ClientWindowScoped.class;
    }

    @Override
    public boolean isActive() {
        return this.isActive(FacesContext.getCurrentInstance());
    }

    public boolean isActive(FacesContext facesContext) {
        return facesContext != null && facesContext.getExternalContext().getClientWindow() != null;
    }

    @Override
    public <T> T get(Contextual<T> bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        if (facesContext != null) {
            Map<Object, ContextualInstanceInfo<?>> contextMap;
            ContextualInstanceInfo<?> contextualInstanceInfo;
            T storage = this.getStorageHolder(facesContext).getContextualStorage(this.getCurrentClientWindowId(facesContext), false);
            if (storage != null && (contextualInstanceInfo = (contextMap = ((ContextualStorage)storage).getStorage()).get(((ContextualStorage)storage).getBeanKey(bean))) != null) {
                return (T)contextualInstanceInfo.getContextualInstance();
            }
        } else {
            throw new IllegalStateException("FacesContext cannot be found when resolving bean " + bean.toString());
        }
        return null;
    }

    @Override
    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        T storage = this.getStorageHolder(facesContext).getContextualStorage(this.getCurrentClientWindowId(facesContext), true);
        Map<Object, ContextualInstanceInfo<?>> contextMap = ((ContextualStorage)storage).getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(((ContextualStorage)storage).getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return ((ContextualStorage)storage).createContextualInstance(bean, creationalContext);
    }

    protected void checkActive(FacesContext facesContext) {
        if (!this.isActive(facesContext)) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    protected ClientWindowScopeContextualStorageHolder getStorageHolder(FacesContext context) {
        return ClientWindowScopeContextualStorageHolder.getInstance(context, true);
    }

    protected String getCurrentClientWindowId(FacesContext context) {
        return context.getExternalContext().getClientWindow().getId();
    }

    public static void destroyAll(FacesContext facesContext) {
        ClientWindowScopeContextualStorageHolder manager = ClientWindowScopeContextualStorageHolder.getInstance(facesContext);
        if (manager != null) {
            manager.destroyAll(facesContext);
        }
    }

    public static void destroyAll(FacesContext context, String clientWindowId) {
        ClientWindowScopeContextualStorageHolder manager = ClientWindowScopeContextualStorageHolder.getInstance(context);
        if (manager != null) {
            manager.destroyAll(context, clientWindowId);
        }
    }

    public static void pushClientWindow(FacesContext context, ClientWindow clientWindow) {
        ClientWindowScopeContextualStorageHolder manager = ClientWindowScopeContextualStorageHolder.getInstance(context, true);
        if (manager != null) {
            manager.pushClientWindow(context, clientWindow);
        }
    }
}

