/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.resource.DefaultResourceLibraryContractsProvider;
import org.apache.myfaces.spi.ResourceLibraryContractsProvider;
import org.apache.myfaces.spi.ResourceLibraryContractsProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.util.lang.ClassUtils;

public class DefaultResourceLibraryContractsProviderFactory
extends ResourceLibraryContractsProviderFactory {
    public static final String CONTRACTS_PROVIDER = ResourceLibraryContractsProvider.class.getName();
    public static final String CONTRACTS_PROVIDER_LIST = ResourceLibraryContractsProvider.class.getName() + ".LIST";

    private Logger getLogger() {
        return Logger.getLogger(DefaultResourceLibraryContractsProviderFactory.class.getName());
    }

    @Override
    public ResourceLibraryContractsProvider createResourceLibraryContractsProvider(ExternalContext externalContext) {
        ResourceLibraryContractsProvider returnValue = null;
        ExternalContext extContext = externalContext;
        try {
            returnValue = System.getSecurityManager() != null ? (ResourceLibraryContractsProvider)AccessController.doPrivileged(() -> this.resolveResourceLibraryContractsProviderFromService(extContext)) : this.resolveResourceLibraryContractsProviderFromService(extContext);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (PrivilegedActionException e) {
            throw new FacesException(e);
        }
        return returnValue;
    }

    private ResourceLibraryContractsProvider resolveResourceLibraryContractsProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(CONTRACTS_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(CONTRACTS_PROVIDER);
            externalContext.getApplicationMap().put(CONTRACTS_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(ResourceLibraryContractsProvider.class, classList, new DefaultResourceLibraryContractsProvider());
    }
}

