/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import org.apache.myfaces.util.lang.ClassUtils;

public final class WebConfigParamUtils {
    public static String getStringInitParameter(ExternalContext context, String name) {
        return WebConfigParamUtils.getStringInitParameter(context, name, null);
    }

    public static String getStringInitParameter(ExternalContext context, String name, String defaultValue) {
        if (name == null) {
            throw new NullPointerException();
        }
        String param = context.getInitParameter(name);
        if (param == null) {
            return defaultValue;
        }
        if ((param = param.trim()).length() == 0) {
            return defaultValue;
        }
        return param;
    }

    public static String getStringInitParameter(ExternalContext context, String[] names) {
        return WebConfigParamUtils.getStringInitParameter(context, names, null);
    }

    public static String getStringInitParameter(ExternalContext context, String[] names, String defaultValue) {
        if (names == null) {
            throw new NullPointerException();
        }
        String param = null;
        for (String name : names) {
            if (name == null) {
                throw new NullPointerException();
            }
            param = context.getInitParameter(name);
            if (param != null) break;
        }
        if (param == null) {
            return defaultValue;
        }
        if ((param = param.trim()).length() == 0) {
            return defaultValue;
        }
        return param;
    }

    public static boolean getBooleanInitParameter(ExternalContext context, String name) {
        return WebConfigParamUtils.getBooleanInitParameter(context, name, false);
    }

    public static boolean getBooleanInitParameter(ExternalContext context, String name, boolean defaultValue) {
        if (name == null) {
            throw new NullPointerException();
        }
        String param = WebConfigParamUtils.getStringInitParameter(context, name);
        if (param == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(param.toLowerCase());
    }

    public static boolean getBooleanInitParameter(ExternalContext context, String name, boolean defaultValue, String[] valuesIgnoreCase, boolean returnOnValueEqualsIgnoreCase) {
        if (name == null) {
            throw new NullPointerException();
        }
        String param = WebConfigParamUtils.getStringInitParameter(context, name);
        if (param == null) {
            return defaultValue;
        }
        if (valuesIgnoreCase != null) {
            for (String trueValue : valuesIgnoreCase) {
                if (!trueValue.equalsIgnoreCase(param)) continue;
                return returnOnValueEqualsIgnoreCase;
            }
            return defaultValue;
        }
        return Boolean.parseBoolean(param.toLowerCase());
    }

    public static boolean getBooleanInitParameter(ExternalContext context, String[] names) {
        return WebConfigParamUtils.getBooleanInitParameter(context, names, false);
    }

    public static boolean getBooleanInitParameter(ExternalContext context, String[] names, boolean defaultValue) {
        if (names == null) {
            throw new NullPointerException();
        }
        String param = null;
        for (String name : names) {
            if (name == null) {
                throw new NullPointerException();
            }
            param = WebConfigParamUtils.getStringInitParameter(context, name);
            if (param != null) break;
        }
        if (param == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(param.toLowerCase());
    }

    public static boolean getBooleanInitParameter(ExternalContext context, String[] names, boolean defaultValue, String[] valuesIgnoreCase, boolean returnOnValueEqualsIgnoreCase) {
        if (names == null) {
            throw new NullPointerException();
        }
        String param = null;
        for (String name : names) {
            if (name == null) {
                throw new NullPointerException();
            }
            param = WebConfigParamUtils.getStringInitParameter(context, name);
            if (param != null) break;
        }
        if (param == null) {
            return defaultValue;
        }
        if (valuesIgnoreCase != null) {
            for (String trueValue : valuesIgnoreCase) {
                if (!trueValue.equalsIgnoreCase(param)) continue;
                return returnOnValueEqualsIgnoreCase;
            }
            return defaultValue;
        }
        return Boolean.parseBoolean(param.toLowerCase());
    }

    public static int getIntegerInitParameter(ExternalContext context, String name) {
        return WebConfigParamUtils.getIntegerInitParameter(context, name, 0);
    }

    public static int getIntegerInitParameter(ExternalContext context, String name, int defaultValue) {
        if (name == null) {
            throw new NullPointerException();
        }
        String param = WebConfigParamUtils.getStringInitParameter(context, name);
        if (param == null) {
            return defaultValue;
        }
        return Integer.parseInt(param.toLowerCase());
    }

    public static int getIntegerInitParameter(ExternalContext context, String[] names) {
        return WebConfigParamUtils.getIntegerInitParameter(context, names, 0);
    }

    public static int getIntegerInitParameter(ExternalContext context, String[] names, int defaultValue) {
        if (names == null) {
            throw new NullPointerException();
        }
        String param = null;
        for (String name : names) {
            if (name == null) {
                throw new NullPointerException();
            }
            param = WebConfigParamUtils.getStringInitParameter(context, name);
            if (param != null) break;
        }
        if (param == null) {
            return defaultValue;
        }
        return Integer.parseInt(param.toLowerCase());
    }

    public static long getLongInitParameter(ExternalContext context, String name) {
        return WebConfigParamUtils.getLongInitParameter(context, name, 0L);
    }

    public static long getLongInitParameter(ExternalContext context, String name, long defaultValue) {
        if (name == null) {
            throw new NullPointerException();
        }
        String param = WebConfigParamUtils.getStringInitParameter(context, name);
        if (param == null) {
            return defaultValue;
        }
        return Long.parseLong(param.toLowerCase());
    }

    public static long getLongInitParameter(ExternalContext context, String[] names) {
        return WebConfigParamUtils.getLongInitParameter(context, names, 0L);
    }

    public static long getLongInitParameter(ExternalContext context, String[] names, long defaultValue) {
        if (names == null) {
            throw new NullPointerException();
        }
        String param = null;
        for (String name : names) {
            if (name == null) {
                throw new NullPointerException();
            }
            param = WebConfigParamUtils.getStringInitParameter(context, name);
            if (param != null) break;
        }
        if (param == null) {
            return defaultValue;
        }
        return Long.parseLong(param.toLowerCase());
    }

    public static <T> T getInstanceInitParameter(ExternalContext context, String name, String deprecatedName, T defaultValue) {
        String param = WebConfigParamUtils.getStringInitParameter(context, name, deprecatedName);
        if (param == null) {
            return defaultValue;
        }
        try {
            return ClassUtils.classForName(param).newInstance();
        }
        catch (Exception e) {
            throw new FacesException("Error Initializing Object[" + param + "]", e);
        }
    }
}

