/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.inject.Named;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.ConversationGroup;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.ConversationKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultConversationKey
implements ConversationKey {
    private static final long serialVersionUID = 3577945095460042939L;
    private Class<? extends Annotation> scopeType;
    private Class<?> groupKey;
    private HashSet<Annotation> qualifiers;

    DefaultConversationKey(Class<? extends Annotation> scopeType, Class<?> groupKey, Annotation ... qualifiers) {
        this.scopeType = scopeType;
        this.groupKey = groupKey;
        for (Annotation qualifier : qualifiers) {
            Class<? extends Annotation> annotationType = qualifier.annotationType();
            if (Any.class.isAssignableFrom(annotationType) || Default.class.isAssignableFrom(annotationType) || Named.class.isAssignableFrom(annotationType) || ConversationGroup.class.isAssignableFrom(annotationType)) continue;
            if (this.qualifiers == null) {
                this.qualifiers = new HashSet();
            }
            this.qualifiers.add(qualifier);
        }
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scopeType;
    }

    @Override
    public Class<?> getConversationGroup() {
        return this.groupKey;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        if (this.qualifiers == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultConversationKey)) {
            return false;
        }
        DefaultConversationKey that = (DefaultConversationKey)o;
        if (!this.groupKey.equals(that.groupKey)) {
            return false;
        }
        if (!this.scopeType.equals(that.scopeType)) {
            return false;
        }
        if (this.qualifiers == null && that.qualifiers == null) {
            return true;
        }
        if (this.qualifiers != null && that.qualifiers == null) {
            return false;
        }
        return that.qualifiers.equals(this.qualifiers);
    }

    public int hashCode() {
        int result = this.scopeType.hashCode();
        result = 31 * result + this.groupKey.hashCode();
        result = 31 * result + (this.qualifiers != null ? this.qualifiers.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("conversation-key\n");
        result.append("\tscope:\t\t");
        result.append(this.scopeType.getName());
        result.append("\n");
        result.append("\tgroup:\t\t");
        result.append(this.groupKey.getName());
        result.append("\n");
        result.append("\tqualifiers:\t");
        if (this.qualifiers != null) {
            for (Annotation qualifier : this.qualifiers) {
                result.append(qualifier.annotationType().getName());
                result.append(" ");
            }
        } else {
            result.append("---");
        }
        return result.toString();
    }
}

