/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.api.tools;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotation
implements Annotation,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = -2345068201195886173L;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static volatile Map<ClassLoader, Map<String, Annotation>> annotationCache = new WeakHashMap<ClassLoader, Map<String, Annotation>>();
    private Class<? extends Annotation> annotationClass;

    public static <T extends Annotation> T of(Class<T> annotationClass) {
        String key = annotationClass.getName();
        Map<String, Annotation> cache = DefaultAnnotation.getAnnotationCache();
        Annotation annotation = cache.get(key);
        if (annotation == null) {
            annotation = DefaultAnnotation.initAnnotation(key, annotationClass, cache);
        }
        return (T)annotation;
    }

    private static synchronized <T extends Annotation> Annotation initAnnotation(String key, Class<T> annotationClass, Map<String, Annotation> cache) {
        Annotation annotation = cache.get(key);
        if (annotation == null) {
            annotation = (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new DefaultAnnotation(annotationClass));
            cache.put(key, annotation);
        }
        return annotation;
    }

    private static Map<String, Annotation> getAnnotationCache() {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        Map<String, Annotation> cache = annotationCache.get(classLoader);
        if (cache == null) {
            cache = DefaultAnnotation.init(classLoader);
        }
        return cache;
    }

    private static synchronized Map<String, Annotation> init(ClassLoader classLoader) {
        Map<String, Annotation> cache = annotationCache.get(classLoader);
        if (cache == null) {
            cache = new ConcurrentHashMap<String, Annotation>();
            annotationCache.put(classLoader, cache);
        }
        return cache;
    }

    private DefaultAnnotation(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("equals".equals(method.getName())) {
            return this.equals(args[0]);
        }
        if ("annotationType".equals(method.getName())) {
            return this.annotationType();
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        return method.getDefaultValue();
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationClass;
    }

    @Override
    public String toString() {
        Method[] methods = this.annotationClass.getDeclaredMethods();
        StringBuilder sb = new StringBuilder("@" + this.annotationType().getName() + "(");
        int length = methods.length;
        for (int i = 0; i < length; ++i) {
            Object memberValue;
            sb.append(methods[i].getName()).append("=");
            try {
                memberValue = this.invoke(this, methods[i], EMPTY_OBJECT_ARRAY);
            }
            catch (Exception e) {
                memberValue = "";
            }
            sb.append(memberValue);
            if (i >= length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultAnnotation)) {
            return false;
        }
        DefaultAnnotation that = (DefaultAnnotation)o;
        return this.annotationClass.equals(that.annotationClass);
    }

    @Override
    public int hashCode() {
        return this.annotationClass.hashCode();
    }
}

