/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.FactoryFinder;
import org.apache.myfaces.orchestra.conversation.Conversation;
import org.apache.myfaces.orchestra.conversation.ConversationContext;
import org.apache.myfaces.orchestra.conversation.ConversationContextFactory;
import org.apache.myfaces.orchestra.conversation.ConversationFactory;
import org.apache.myfaces.orchestra.conversation.ConversationMessager;
import org.apache.myfaces.orchestra.conversation.ConversationRequestParameterProvider;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.lib.OrchestraException;
import org.apache.myfaces.orchestra.requestParameterProvider.RequestParameterProviderManager;

public class ConversationManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String CONVERSATION_CONTEXT_PARAM = "conversationContext";
    private static final String CONVERSATION_MANAGER_KEY = "org.apache.myfaces.ConversationManager";
    private static final String CONVERSATION_CONTEXT_REQ = "org.apache.myfaces.ConversationManager.conversationContext";
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    private static final Object DUMMY = new Integer(-1);
    private final Log log = LogFactory.getLog(ConversationManager.class);
    private long nextConversationContextId = 1L;
    private final Map conversationContexts = new HashMap();

    protected ConversationManager() {
    }

    public static ConversationManager getInstance() {
        return ConversationManager.getInstance(true);
    }

    public static ConversationManager getInstance(boolean create) {
        ConversationManager conversationManager;
        FrameworkAdapter frameworkAdapter = FrameworkAdapter.getCurrentInstance();
        if (frameworkAdapter == null) {
            if (!create) {
                return null;
            }
            throw new IllegalStateException("FrameworkAdapter not found");
        }
        Object cmObj = frameworkAdapter.getSessionAttribute(CONVERSATION_MANAGER_KEY);
        if (cmObj == DUMMY) {
            Log log = LogFactory.getLog(ConversationManager.class);
            log.debug((Object)"Method getInstance found dummy ConversationManager object");
            cmObj = null;
        }
        if ((conversationManager = (ConversationManager)cmObj) == null && create) {
            Log log = LogFactory.getLog(ConversationManager.class);
            log.debug((Object)"Register ConversationRequestParameterProvider");
            conversationManager = FactoryFinder.getConversationManagerFactory().createConversationManager();
            RequestParameterProviderManager.getInstance().register(new ConversationRequestParameterProvider());
            FrameworkAdapter.getCurrentInstance().setSessionAttribute(CONVERSATION_MANAGER_KEY, conversationManager);
        }
        return conversationManager;
    }

    private Long findConversationContextId() {
        FrameworkAdapter fa = FrameworkAdapter.getCurrentInstance();
        Long conversationContextId = (Long)fa.getRequestAttribute(CONVERSATION_CONTEXT_REQ);
        if (conversationContextId == null && fa.containsRequestParameterAttribute(CONVERSATION_CONTEXT_PARAM)) {
            String urlConversationContextId = fa.getRequestParameterAttribute(CONVERSATION_CONTEXT_PARAM).toString();
            conversationContextId = new Long(Long.parseLong(urlConversationContextId, 36));
        }
        return conversationContextId;
    }

    private Long getOrCreateConversationContextId() {
        Long conversationContextId = this.findConversationContextId();
        if (conversationContextId == null) {
            conversationContextId = this.createNextConversationContextId();
            FrameworkAdapter fa = FrameworkAdapter.getCurrentInstance();
            fa.setRequestAttribute(CONVERSATION_CONTEXT_REQ, conversationContextId);
        }
        return conversationContextId;
    }

    public Long getConversationContextId() {
        return this.getOrCreateConversationContextId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long createNextConversationContextId() {
        Long conversationContextId;
        ConversationManager conversationManager = this;
        synchronized (conversationManager) {
            conversationContextId = new Long(this.nextConversationContextId);
            ++this.nextConversationContextId;
        }
        return conversationContextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationContext getConversationContext(Long conversationContextId) {
        ConversationManager conversationManager = this;
        synchronized (conversationManager) {
            return (ConversationContext)this.conversationContexts.get(conversationContextId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConversationContext getOrCreateConversationContext(Long conversationContextId) {
        ConversationManager conversationManager = this;
        synchronized (conversationManager) {
            ConversationContext conversationContext = (ConversationContext)this.conversationContexts.get(conversationContextId);
            if (conversationContext == null) {
                ConversationContextFactory factory = FactoryFinder.getConversationContextFactory();
                conversationContext = factory.createConversationContext(null, conversationContextId);
                this.conversationContexts.put(conversationContextId, conversationContext);
                this.log.debug((Object)("Created context " + conversationContextId));
            }
            return conversationContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationContext createConversationContext(ConversationContext parent) {
        Long ctxId = this.createNextConversationContextId();
        ConversationContextFactory factory = FactoryFinder.getConversationContextFactory();
        ConversationContext ctx = factory.createConversationContext(parent, ctxId);
        ConversationManager conversationManager = this;
        synchronized (conversationManager) {
            this.conversationContexts.put(ctxId, ctx);
        }
        return ctx;
    }

    public void activateConversationContext(ConversationContext ctx) {
        FrameworkAdapter fa = FrameworkAdapter.getCurrentInstance();
        fa.setRequestAttribute(CONVERSATION_CONTEXT_REQ, ctx.getIdAsLong());
    }

    public void clearCurrentConversationContext() {
        ConversationContext conversationContext;
        Long conversationContextId = this.findConversationContextId();
        if (conversationContextId != null && (conversationContext = this.getConversationContext(conversationContextId)) != null) {
            conversationContext.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndInvalidateConversationContext(ConversationContext context) {
        if (context.hasChildren()) {
            throw new OrchestraException("Cannot remove context with children");
        }
        if (context.getIdAsLong().equals(this.findConversationContextId())) {
            throw new OrchestraException("Cannot remove current context");
        }
        Map map = this.conversationContexts;
        synchronized (map) {
            this.conversationContexts.remove(context.getIdAsLong());
        }
        ConversationContext parent = context.getParent();
        if (parent != null) {
            parent.removeChild(context);
        }
        context.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConversationContext(Long conversationContextId) {
        ConversationManager conversationManager = this;
        synchronized (conversationManager) {
            this.conversationContexts.remove(conversationContextId);
        }
    }

    public Conversation startConversation(String name, ConversationFactory factory) {
        ConversationContext conversationContext = this.getOrCreateCurrentConversationContext();
        return conversationContext.startConversation(name, factory);
    }

    protected void removeConversation(String name) {
        ConversationContext conversationContext;
        Long conversationContextId = this.findConversationContextId();
        if (conversationContextId != null && (conversationContext = this.getConversationContext(conversationContextId)) != null) {
            conversationContext.removeConversation(name);
        }
    }

    public Conversation getConversation(String name) {
        ConversationContext conversationContext = this.getCurrentConversationContext();
        if (conversationContext == null) {
            return null;
        }
        return conversationContext.getConversation(name);
    }

    public boolean hasConversation(String name) {
        ConversationContext conversationContext = this.getCurrentConversationContext();
        if (conversationContext == null) {
            return false;
        }
        return conversationContext.hasConversation(name);
    }

    public Iterator iterateConversations() {
        ConversationContext conversationContext = this.getCurrentConversationContext();
        if (conversationContext == null) {
            return EMPTY_ITERATOR;
        }
        return conversationContext.iterateConversations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationContext getCurrentConversationContext() {
        Long ccid = this.findConversationContextId();
        if (ccid == null) {
            return null;
        }
        ConversationContext ctx = this.getConversationContext(ccid);
        if (ctx == null) {
            this.log.warn((Object)"ConversationContextId specified but context does not exist");
            ConversationManager conversationManager = this;
            synchronized (conversationManager) {
                if (this.nextConversationContextId <= ccid) {
                    this.nextConversationContextId = ccid + 1L;
                }
            }
            return null;
        }
        return ctx;
    }

    ConversationContext getOrCreateCurrentConversationContext() {
        Long ccid = this.getOrCreateConversationContextId();
        return this.getOrCreateConversationContext(ccid);
    }

    public boolean hasConversationContext() {
        return this.getCurrentConversationContext() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationContext getCurrentRootConversationContext() {
        Long ccid = this.findConversationContextId();
        if (ccid == null) {
            return null;
        }
        ConversationManager conversationManager = this;
        synchronized (conversationManager) {
            ConversationContext conversationContext = this.getConversationContext(ccid);
            if (conversationContext == null) {
                return null;
            }
            return conversationContext.getRoot();
        }
    }

    public ConversationMessager getMessager() {
        return FrameworkAdapter.getCurrentInstance().getConversationMessager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        Map.Entry[] contexts;
        ConversationManager conversationManager = this;
        synchronized (conversationManager) {
            contexts = new Map.Entry[this.conversationContexts.size()];
            this.conversationContexts.entrySet().toArray(contexts);
        }
        long checkTime = System.currentTimeMillis();
        for (int i = 0; i < contexts.length; ++i) {
            Map.Entry context = contexts[i];
            ConversationContext conversationContext = (ConversationContext)context.getValue();
            if (conversationContext.hasChildren()) continue;
            conversationContext.checkConversationTimeout();
            if (conversationContext.getTimeout() <= -1L || conversationContext.getLastAccess() + conversationContext.getTimeout() >= checkTime) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("end conversation context due to timeout: " + conversationContext.getId()));
            }
            this.removeAndInvalidateConversationContext(conversationContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndInvalidateAllConversationContexts() {
        ConversationContext[] contexts;
        ConversationManager conversationManager = this;
        synchronized (conversationManager) {
            contexts = new ConversationContext[this.conversationContexts.size()];
            this.conversationContexts.values().toArray(contexts);
        }
        for (int i = 0; i < contexts.length; ++i) {
            ConversationContext context = contexts[i];
            this.removeAndInvalidateConversationContextAndChildren(context);
        }
    }

    private void removeAndInvalidateConversationContextAndChildren(ConversationContext conversationContext) {
        while (conversationContext.hasChildren()) {
            ConversationContext child = (ConversationContext)conversationContext.getChildren().iterator().next();
            this.removeAndInvalidateConversationContextAndChildren(child);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("end conversation context: " + conversationContext.getId()));
        }
        this.removeAndInvalidateConversationContext(conversationContext);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    private Object readResolve() throws ObjectStreamException {
        Log log = LogFactory.getLog(ConversationManager.class);
        log.debug((Object)"readResolve returning dummy ConversationManager object");
        return DUMMY;
    }
}

