/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContextListener;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.test.config.ResourceBundleVarNames;
import org.apache.myfaces.test.el.FacesImplicitObjectELResolver;
import org.apache.myfaces.test.el.FacesPropertyResolverChainWrapper;
import org.apache.myfaces.test.el.FacesResourceBundleELResolver;
import org.apache.myfaces.test.el.FacesScopedAttributeELResolver;
import org.apache.myfaces.test.el.FacesVariableResolverChainWrapper;
import org.apache.myfaces.test.el.MockExpressionFactory;
import org.apache.myfaces.test.el.ReservedWordsELResolver;
import org.apache.myfaces.test.mock.MockApplication;

public class MockApplication12
extends MockApplication {
    private Map bundles = new HashMap();
    private List elContextListeners = new ArrayList();
    private ExpressionFactory expressionFactory = null;
    private ELResolver resolver = null;
    private List resolvers = new ArrayList();

    public MockApplication12() {
        this.expressionFactory = new MockExpressionFactory();
    }

    public void addResourceBundle(String name, ResourceBundle bundle) {
        this.bundles.put(name, bundle);
    }

    public Map getResourceBundles() {
        return this.bundles;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public void addELContextListener(ELContextListener listener) {
        this.elContextListeners.add(listener);
    }

    public void addELResolver(ELResolver resolver) {
        if (this.resolver != null) {
            throw new IllegalStateException("Cannot add resolvers now");
        }
        this.resolvers.add(resolver);
    }

    public UIComponent createComponent(ValueExpression expression, FacesContext context, String componentType) {
        UIComponent component = null;
        try {
            component = (UIComponent)expression.getValue(context.getELContext());
            if (component == null) {
                component = this.createComponent(componentType);
                expression.setValue(context.getELContext(), (Object)component);
            }
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        return component;
    }

    public Object evaluateExpressionGet(FacesContext context, String expression, Class expectedType) throws ELException {
        ValueExpression ve = this.getExpressionFactory().createValueExpression(context.getELContext(), expression, expectedType);
        return ve.getValue(context.getELContext());
    }

    public ELContextListener[] getELContextListeners() {
        return this.elContextListeners.toArray(new ELContextListener[this.elContextListeners.size()]);
    }

    public ELResolver getELResolver() {
        if (this.resolver == null) {
            CompositeELResolver composite = new CompositeELResolver();
            composite.add((ELResolver)new FacesImplicitObjectELResolver());
            CompositeELResolver nested = new CompositeELResolver();
            nested.add((ELResolver)new FacesVariableResolverChainWrapper());
            nested.add((ELResolver)new FacesPropertyResolverChainWrapper());
            Iterator items = this.resolvers.iterator();
            while (items.hasNext()) {
                nested.add((ELResolver)items.next());
            }
            composite.add((ELResolver)nested);
            composite.add((ELResolver)new ResourceBundleELResolver());
            composite.add((ELResolver)new FacesResourceBundleELResolver());
            composite.add((ELResolver)new MapELResolver());
            composite.add((ELResolver)new ListELResolver());
            composite.add((ELResolver)new ArrayELResolver());
            composite.add((ELResolver)new BeanELResolver());
            composite.add((ELResolver)new FacesScopedAttributeELResolver());
            composite.add((ELResolver)new ReservedWordsELResolver());
            this.resolver = composite;
        }
        return this.resolver;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public ResourceBundle getResourceBundle(FacesContext context, String name) {
        if (context == null || name == null) {
            throw new NullPointerException();
        }
        Locale locale = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot != null) {
            locale = viewRoot.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(name, locale);
        }
        catch (MissingResourceException e) {
            String newName = ResourceBundleVarNames.getVarName(name);
            if (newName == null) {
                return null;
            }
            try {
                return ResourceBundle.getBundle(newName, locale);
            }
            catch (MissingResourceException exc) {
                return null;
            }
        }
    }

    public void removeELContextListener(ELContextListener listener) {
        this.elContextListeners.remove(listener);
    }
}

