// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIToolBar;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.ToolBarTagDeclaration}.
 */
public final class ToolBarTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(ToolBarTag.class);
  private javax.el.ValueExpression  labelPosition;
  private javax.el.ValueExpression  iconSize;
  private javax.el.ValueExpression  tip;
  private javax.el.ValueExpression  orientation;
  private javax.el.ValueExpression  markup;

  @Override
  public String getComponentType() {
    return UIToolBar.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "ToolBar";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIToolBar component = (UIToolBar) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (labelPosition != null) {
      component.setValueExpression("labelPosition", labelPosition);
    }

    if (iconSize != null) {
      component.setValueExpression("iconSize", iconSize);
    }

    if (tip != null) {
      component.setValueExpression("tip", tip);
    }

    if (orientation != null) {
      component.setValueExpression("orientation", orientation);
    }

    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
  }

  public javax.el.ValueExpression getLabelPosition() {
    return labelPosition;
  }

  public void setLabelPosition(final javax.el.ValueExpression labelPosition) {
    this.labelPosition = labelPosition;
  }

  public javax.el.ValueExpression getIconSize() {
    return iconSize;
  }

  public void setIconSize(final javax.el.ValueExpression iconSize) {
    this.iconSize = iconSize;
  }

  public javax.el.ValueExpression getTip() {
    return tip;
  }

  public void setTip(final javax.el.ValueExpression tip) {
    this.tip = tip;
  }

  public javax.el.ValueExpression getOrientation() {
    return orientation;
  }

  public void setOrientation(final javax.el.ValueExpression orientation) {
    this.orientation = orientation;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }



  @Override
  public void release() {
    super.release();
    labelPosition = null;
    iconSize = null;
    tip = null;
    orientation = null;
    markup = null;
  }
}