/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIFile;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.util.HttpPartWrapper;
import org.apache.myfaces.tobago.internal.util.PartUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.validator.FileItemValidator;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(FileRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        FacesContextUtils.setEnctype((FacesContext)facesContext, (String)"multipart/form-data");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtils.isOutputOnly((UIComponent)component)) {
            return;
        }
        AbstractUIFile file = (AbstractUIFile)component;
        boolean multiple = file.isMultiple() && !file.isRequired();
        Object request = facesContext.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest) {
            try {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                if (multiple) {
                    ArrayList<HttpPartWrapper> parts = new ArrayList<HttpPartWrapper>();
                    for (Part part : httpServletRequest.getParts()) {
                        if (file.getClientId(facesContext).equals(part.getName())) {
                            LOG.debug("Uploaded file '{}', size={}, type='{}'", new Object[]{PartUtils.getSubmittedFileName((Part)part), part.getSize(), part.getContentType()});
                            parts.add(new HttpPartWrapper(part));
                        }
                        file.setSubmittedValue((Object)parts.toArray(new Part[0]));
                    }
                } else {
                    Part part = httpServletRequest.getPart(file.getClientId(facesContext));
                    String submittedFileName = PartUtils.getSubmittedFileName((Part)part);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Uploaded file '{}', size={}, type='{}'", new Object[]{submittedFileName, part.getSize(), part.getContentType()});
                    }
                    if (submittedFileName.length() > 0) {
                        file.setSubmittedValue((Object)new HttpPartWrapper(part));
                    }
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
                file.setValid(false);
            }
        } else {
            LOG.warn("Unsupported request type: " + request.getClass().getName());
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String title;
        AbstractUIFile file = (AbstractUIFile)component;
        String clientId = file.getClientId(facesContext);
        Style style = new Style(facesContext, (LayoutBase)file);
        String accept = this.createAcceptFromValidators(file);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("div", (UIComponent)file);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(this.getCssClasses((UIComponent)file, null));
        this.writeDataAttributes(facesContext, writer, file);
        writer.writeStyleAttribute(style);
        this.writeVisibleInput(facesContext, writer, file, clientId, style);
        writer.startElement("input", (UIComponent)file);
        writer.writeAttribute("multiple", file.isMultiple());
        writer.writeIdAttribute(clientId + "::" + "real");
        writer.writeAttribute("type", "file", false);
        writer.writeAttribute("accept", accept, true);
        writer.writeClassAttribute(this.getCssClasses((UIComponent)file, "real"));
        writer.writeNameAttribute(clientId);
        String multiFormat = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.file.multiFormat");
        writer.writeAttribute("data-tobago-file-multi-format", multiFormat, true);
        writer.writeAttribute("disabled", file.isDisabled() || file.isReadonly());
        writer.writeAttribute("readonly", file.isReadonly());
        writer.writeAttribute("required", file.isRequired());
        writer.writeAttribute("size", "1024", false);
        Integer tabIndex = file.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        if ((title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)file)) != null) {
            writer.writeAttribute("title", title, true);
        }
        HtmlRendererUtils.renderCommandFacet((UIComponent)file, facesContext, writer);
        writer.endElement("input");
        writer.endElement("div");
    }

    private String createAcceptFromValidators(AbstractUIFile file) {
        StringBuilder builder = new StringBuilder();
        for (Validator validator : file.getValidators()) {
            if (!(validator instanceof FileItemValidator)) continue;
            FileItemValidator fileItemValidator = (FileItemValidator)validator;
            for (String contentType : fileItemValidator.getContentType()) {
                builder.append(",");
                builder.append(contentType);
            }
        }
        if (builder.length() > 0) {
            return builder.substring(1);
        }
        return null;
    }

    protected Classes getCssClasses(UIComponent component, String sub) {
        return Classes.create((UIComponent)component, (String)sub);
    }

    protected void writeDataAttributes(FacesContext facesContext, TobagoResponseWriter writer, AbstractUIFile file) throws IOException {
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)file);
    }

    protected void writeVisibleInput(FacesContext facesContext, TobagoResponseWriter writer, AbstractUIFile file, String clientId, Style style) throws IOException {
        Style inputStyle = new Style();
        Measure prettyWidthSub = this.getPrettyWidthSub(facesContext, file);
        inputStyle.setWidth(style.getWidth().subtract(prettyWidthSub));
        writer.startElement("input", (UIComponent)file);
        writer.writeIdAttribute(clientId + "::" + "pretty");
        writer.writeAttribute("type", "text", false);
        writer.writeClassAttribute(this.getCssClasses((UIComponent)file, "pretty"));
        writer.writeStyleAttribute(inputStyle);
        writer.writeAttribute("disabled", true);
        if (!file.isDisabled() && !file.isReadonly()) {
            writer.writeAttribute("placeholder", file.getPlaceholder(), true);
        }
        writer.endElement("input");
    }

    protected Measure getPrettyWidthSub(FacesContext facesContext, AbstractUIFile file) {
        return this.getResourceManager().getThemeMeasure(facesContext, (Configurable)file, "prettyWidthSub");
    }
}

