/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UICalendar;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalendarTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarTag.class);
    private ValueExpression markup;
    private ValueExpression value;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Calendar";
    }

    public String getRendererType() {
        return "Calendar";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UICalendar component = (UICalendar)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.value != null && !this.value.isLiteralText()) {
            component.setValueExpression("value", this.value);
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.value = null;
    }
}

