/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIToolBar;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolBarTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(ToolBarTag.class);
    private ValueExpression labelPosition;
    private ValueExpression iconSize;
    private ValueExpression tip;
    private ValueExpression orientation;
    private ValueExpression markup;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.ToolBar";
    }

    public String getRendererType() {
        return "ToolBar";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIToolBar component = (UIToolBar)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.labelPosition != null) {
            component.setValueExpression("labelPosition", this.labelPosition);
        }
        if (this.iconSize != null) {
            component.setValueExpression("iconSize", this.iconSize);
        }
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
        if (this.orientation != null) {
            component.setValueExpression("orientation", this.orientation);
        }
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
    }

    public ValueExpression getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(ValueExpression labelPosition) {
        this.labelPosition = labelPosition;
    }

    public ValueExpression getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(ValueExpression iconSize) {
        this.iconSize = iconSize;
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public ValueExpression getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ValueExpression orientation) {
        this.orientation = orientation;
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public void release() {
        super.release();
        this.labelPosition = null;
        this.iconSize = null;
        this.tip = null;
        this.orientation = null;
        this.markup = null;
    }
}

