// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIObject;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.ObjectTagDeclaration}.
 */
public final class ObjectTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(ObjectTag.class);
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  src;
  private javax.el.ValueExpression  sandbox;
  private javax.el.ValueExpression  name;

  @Override
  public String getComponentType() {
    return UIObject.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Object";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIObject component = (UIObject) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (src != null) {
      component.setValueExpression("src", src);
    }

    if (sandbox != null) {
      component.setValueExpression("sandbox", sandbox);
    }

    if (name != null) {
      component.setValueExpression("name", name);
    }

  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getSrc() {
    return src;
  }

  public void setSrc(final javax.el.ValueExpression src) {
    this.src = src;
  }

  public javax.el.ValueExpression getSandbox() {
    return sandbox;
  }

  public void setSandbox(final javax.el.ValueExpression sandbox) {
    this.sandbox = sandbox;
  }

  public javax.el.ValueExpression getName() {
    return name;
  }

  public void setName(final javax.el.ValueExpression name) {
    this.name = name;
  }



  @Override
  public void release() {
    super.release();
    markup = null;
    src = null;
    sandbox = null;
    name = null;
  }
}