/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.buffer;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.buffer.Buffer;
import org.apache.myfaces.renderkit.html.util.DummyFormUtils;
import org.apache.myfaces.renderkit.html.util.HtmlBufferResponseWriterWrapper;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;

public class BufferRenderer
extends Renderer {
    private static final Log log = LogFactory.getLog(BufferRenderer.class);
    public static final String RENDERER_TYPE = "org.apache.myfaces.Buffer";

    private HtmlBufferResponseWriterWrapper getResponseWriter(FacesContext context) {
        return HtmlBufferResponseWriterWrapper.getInstance(context.getResponseWriter());
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, Buffer.class);
        facesContext.setResponseWriter((ResponseWriter)this.getResponseWriter(facesContext));
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, Buffer.class);
        RendererUtils.renderChildren(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) {
        Buffer buffer = (Buffer)uiComponent;
        HtmlBufferResponseWriterWrapper writer = (HtmlBufferResponseWriterWrapper)facesContext.getResponseWriter();
        buffer.fill(writer.toString(), facesContext);
        facesContext.setResponseWriter(writer.getInitialWriter());
        if (DummyFormUtils.getDummyFormParameters(facesContext) != null) {
            try {
                if (DummyFormUtils.isWriteDummyForm(facesContext)) {
                    DummyFormUtils.setWriteDummyForm(facesContext, true);
                }
                Iterator i = DummyFormUtils.getDummyFormParameters(facesContext).iterator();
                while (i.hasNext()) {
                    DummyFormUtils.addDummyFormParameter(facesContext, i.next().toString());
                }
            }
            catch (Exception e) {
                log.warn((Object)"Dummy form parameters are not supported by this JSF implementation.");
            }
        }
    }
}

