/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutcomeTarget;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.component.html.HtmlMessages;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.shared_tomahawk.application.NavigationUtils;
import org.apache.myfaces.shared_tomahawk.component.DisplayValueOnlyCapable;
import org.apache.myfaces.shared_tomahawk.component.EscapeCapable;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlJavaScriptUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.JavascriptContext;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlRendererUtils {
    private static final Logger log = Logger.getLogger(HtmlRendererUtils.class.getName());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\r\n");
    private static final char TABULATOR = '\t';
    public static final String HIDDEN_COMMANDLINK_FIELD_NAME = "_idcl";
    public static final String HIDDEN_COMMANDLINK_FIELD_NAME_MYFACES_OLD = "_link_hidden_";
    public static final String HIDDEN_COMMANDLINK_FIELD_NAME_TRINIDAD = "source";
    public static final String CLEAR_HIDDEN_FIELD_FN_NAME = "clearFormHiddenParams";
    public static final String SUBMIT_FORM_FN_NAME = "oamSubmitForm";
    public static final String SUBMIT_FORM_FN_NAME_JSF2 = "myfaces.oam.submitForm";
    public static final String ALLOW_CDATA_SECTION_ON = "org.apache.myfaces.ResponseWriter.CdataSectionOn";
    public static final String NON_SUBMITTED_VALUE_WARNING = "There should always be a submitted value for an input if it is rendered, its form is submitted, and it was not originally rendered disabled or read-only.  You cannot submit a form after disabling an input element via javascript.  Consider setting read-only to true instead or resetting the disabled value back to false prior to form submission.";
    public static final String STR_EMPTY = "";
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static final String TEXT_ANY_CONTENT_TYPE = "text/*";
    private static final String ANY_CONTENT_TYPE = "*/*";
    public static final String DEFAULT_CHAR_ENCODING = "ISO-8859-1";
    private static final String XHTML_CONTENT_TYPE = "application/xhtml+xml";
    private static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml";
    private static final String[] SUPPORTED_CONTENT_TYPES = new String[]{"text/html", "application/xhtml+xml", "application/xml", "text/xml", "text/*", "*/*"};

    private HtmlRendererUtils() {
    }

    public static void decodeUIInput(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(facesContext);
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        if (paramMap.containsKey(clientId)) {
            ((EditableValueHolder)component).setSubmittedValue(paramMap.get(clientId));
        } else {
            log.warning("There should always be a submitted value for an input if it is rendered, its form is submitted, and it was not originally rendered disabled or read-only.  You cannot submit a form after disabling an input element via javascript.  Consider setting read-only to true instead or resetting the disabled value back to false prior to form submission. Component : " + RendererUtils.getPathToComponent(component));
        }
    }

    public static void decodeUISelectBoolean(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            String reqValue = (String)paramMap.get(clientId);
            if (reqValue.equalsIgnoreCase("on") || reqValue.equalsIgnoreCase("yes") || reqValue.equalsIgnoreCase("true")) {
                ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.TRUE);
            } else {
                ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.FALSE);
            }
        } else {
            ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.FALSE);
        }
    }

    public static boolean isDisabledOrReadOnly(UIComponent component) {
        return HtmlRendererUtils.isDisplayValueOnly(component) || HtmlRendererUtils.isDisabled(component) || HtmlRendererUtils.isReadOnly(component);
    }

    public static boolean isDisabled(UIComponent component) {
        return HtmlRendererUtils.isTrue(component.getAttributes().get("disabled"));
    }

    public static boolean isReadOnly(UIComponent component) {
        return HtmlRendererUtils.isTrue(component.getAttributes().get("readonly"));
    }

    private static boolean isTrue(Object obj) {
        if (obj instanceof String) {
            return new Boolean((String)obj);
        }
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public static void decodeUISelectMany(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramValuesMap = facesContext.getExternalContext().getRequestParameterValuesMap();
        String clientId = component.getClientId(facesContext);
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        if (paramValuesMap.containsKey(clientId)) {
            String[] reqValues = (String[])paramValuesMap.get(clientId);
            ((EditableValueHolder)component).setSubmittedValue((Object)reqValues);
        } else {
            ((EditableValueHolder)component).setSubmittedValue((Object)new String[0]);
        }
    }

    public static void decodeUISelectOne(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            ((EditableValueHolder)component).setSubmittedValue(paramMap.get(clientId));
        } else {
            ((EditableValueHolder)component).setSubmittedValue((Object)STR_EMPTY);
        }
    }

    public static void decodeClientBehaviors(FacesContext facesContext, UIComponent component) {
        block5: {
            List clientBehaviorList;
            Map paramMap;
            String behaviorEventName;
            ClientBehaviorHolder clientBehaviorHolder;
            Map clientBehaviors;
            if (!(component instanceof ClientBehaviorHolder) || (clientBehaviors = (clientBehaviorHolder = (ClientBehaviorHolder)component).getClientBehaviors()) == null || clientBehaviors.isEmpty() || (behaviorEventName = (String)(paramMap = facesContext.getExternalContext().getRequestParameterMap()).get("javax.faces.behavior.event")) == null || (clientBehaviorList = (List)clientBehaviors.get(behaviorEventName)) == null || clientBehaviorList.isEmpty()) break block5;
            String clientId = (String)paramMap.get("javax.faces.source");
            if (component.getClientId(facesContext).equals(clientId)) {
                if (clientBehaviorList instanceof RandomAccess) {
                    int size = clientBehaviorList.size();
                    for (int i = 0; i < size; ++i) {
                        ClientBehavior clientBehavior = (ClientBehavior)clientBehaviorList.get(i);
                        clientBehavior.decode(facesContext, component);
                    }
                } else {
                    for (ClientBehavior clientBehavior : clientBehaviorList) {
                        clientBehavior.decode(facesContext, component);
                    }
                }
            }
        }
    }

    public static void renderListbox(FacesContext facesContext, UISelectOne selectOne, boolean disabled, int size, Converter converter) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectOne, disabled, size, false, converter);
    }

    public static void renderListbox(FacesContext facesContext, UISelectMany selectMany, boolean disabled, int size, Converter converter) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectMany, disabled, size, true, converter);
    }

    public static void renderMenu(FacesContext facesContext, UISelectOne selectOne, boolean disabled, Converter converter) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectOne, disabled, 1, false, converter);
    }

    public static void renderMenu(FacesContext facesContext, UISelectMany selectMany, boolean disabled, Converter converter) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectMany, disabled, 1, true, converter);
    }

    private static void internalRenderSelect(FacesContext facesContext, UIComponent uiComponent, boolean disabled, int size, boolean selectMany, Converter converter) throws IOException {
        List selectItemList;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("select", uiComponent);
        if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext()) && !((ClientBehaviorHolder)uiComponent).getClientBehaviors().isEmpty()) {
            writer.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), null);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        writer.writeAttribute("name", (Object)uiComponent.getClientId(facesContext), null);
        if (selectMany) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
            selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent, facesContext);
        } else {
            selectItemList = RendererUtils.getSelectItemList((UISelectOne)uiComponent, facesContext);
        }
        if (size == Integer.MIN_VALUE) {
            writer.writeAttribute("size", (Object)Integer.toString(selectItemList.size()), null);
        } else {
            writer.writeAttribute("size", (Object)Integer.toString(size), null);
        }
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
            HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (HtmlRendererUtils.isReadOnly(uiComponent)) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(selectMany, uiComponent, facesContext, converter);
        HtmlRendererUtils.renderSelectOptions(facesContext, uiComponent, converter, lookupSet, selectItemList);
        writer.writeText((Object)STR_EMPTY, null);
        writer.endElement("select");
    }

    public static Set getSubmittedOrSelectedValuesAsSet(boolean selectMany, UIComponent uiComponent, FacesContext facesContext, Converter converter) {
        Set<String> lookupSet;
        if (selectMany) {
            UISelectMany uiSelectMany = (UISelectMany)uiComponent;
            lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            if (lookupSet == null) {
                lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            }
        } else {
            UISelectOne uiSelectOne = (UISelectOne)uiComponent;
            Object lookup = uiSelectOne.getSubmittedValue();
            if (lookup == null) {
                lookup = uiSelectOne.getValue();
                String lookupString = RendererUtils.getConvertedStringValue(facesContext, uiComponent, converter, lookup);
                lookupSet = Collections.singleton(lookupString);
            } else {
                lookupSet = STR_EMPTY.equals(lookup) ? Collections.EMPTY_SET : Collections.singleton(lookup);
            }
        }
        return lookupSet;
    }

    public static Converter findUISelectManyConverterFailsafe(FacesContext facesContext, UIComponent uiComponent) {
        return HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, uiComponent, false);
    }

    public static Converter findUISelectManyConverterFailsafe(FacesContext facesContext, UIComponent uiComponent, boolean considerValueType) {
        Converter converter;
        try {
            converter = RendererUtils.findUISelectManyConverter(facesContext, (UISelectMany)uiComponent, considerValueType);
        }
        catch (FacesException e) {
            log.log(Level.SEVERE, "Error finding Converter for component with id " + uiComponent.getClientId(facesContext), e);
            converter = null;
        }
        return converter;
    }

    public static Converter findUIOutputConverterFailSafe(FacesContext facesContext, UIComponent uiComponent) {
        Converter converter;
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)uiComponent);
        }
        catch (FacesException e) {
            log.log(Level.SEVERE, "Error finding Converter for component with id " + uiComponent.getClientId(facesContext), e);
            converter = null;
        }
        return converter;
    }

    public static void renderSelectOptions(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List selectItemList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean hideNoSelectionOption = HtmlRendererUtils.isHideNoSelectionOption(component);
        boolean componentDisabled = HtmlRendererUtils.isTrue(component.getAttributes().get("disabled"));
        for (SelectItem selectItem : selectItemList) {
            boolean escape;
            boolean disabled;
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", (Object)selectItem.getLabel(), null);
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                HtmlRendererUtils.renderSelectOptions(context, component, converter, lookupSet, Arrays.asList(selectItems));
                writer.endElement("optgroup");
                continue;
            }
            String itemStrValue = RendererUtils.getConvertedStringValue(context, component, converter, selectItem);
            boolean selected = lookupSet.contains(itemStrValue);
            if (hideNoSelectionOption && selectItem.isNoSelectionOption() && lookupSet.size() != 0 && (lookupSet.size() != 1 || !lookupSet.contains(STR_EMPTY)) && !selected) continue;
            writer.write(9);
            writer.startElement("option", component);
            if (itemStrValue != null) {
                writer.writeAttribute("value", (Object)itemStrValue, null);
            } else {
                writer.writeAttribute("value", (Object)STR_EMPTY, null);
            }
            if (selected) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            if (disabled = selectItem.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            String labelClass = null;
            labelClass = componentDisabled || disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
            if (labelClass != null) {
                writer.writeAttribute("class", (Object)labelClass, "labelClass");
            }
            if (component instanceof EscapeCapable) {
                escape = ((EscapeCapable)component).isEscape();
                if (escape && selectItem.isEscape()) {
                    writer.writeText((Object)selectItem.getLabel(), null);
                } else {
                    writer.write(selectItem.getLabel());
                }
            } else {
                escape = RendererUtils.getBooleanAttribute(component, "escape", false);
                if (escape || selectItem.isEscape()) {
                    writer.writeText((Object)selectItem.getLabel(), null);
                } else {
                    writer.write(selectItem.getLabel());
                }
            }
            writer.endElement("option");
        }
    }

    public static void writePrettyLineSeparator(FacesContext facesContext) throws IOException {
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml()) {
            facesContext.getResponseWriter().write(LINE_SEPARATOR);
        }
    }

    public static void writePrettyIndent(FacesContext facesContext) throws IOException {
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml()) {
            facesContext.getResponseWriter().write(9);
        }
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, String componentProperty, String attrName, Object value) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            String htmlAttrName = attrName.equals("styleClass") ? "class" : attrName;
            writer.writeAttribute(htmlAttrName, value, componentProperty);
            return true;
        }
        return false;
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
        Object value = component.getAttributes().get(componentProperty);
        return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, value);
    }

    public static boolean renderHTMLAttributes(ResponseWriter writer, UIComponent component, String[] attributes) throws IOException {
        boolean somethingDone = false;
        for (String attrName : attributes) {
            if (!HtmlRendererUtils.renderHTMLAttribute(writer, component, attrName, attrName)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    public static boolean renderHTMLAttributeWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String attrName, Object value, boolean startElementWritten) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderHTMLAttributesWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean startElementWritten = false;
        for (String attrName : attributes) {
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderOptionalEndElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean endElementNeeded = false;
        for (String attrName : attributes) {
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            endElementNeeded = true;
            break;
        }
        if (endElementNeeded) {
            writer.endElement(elementName);
            return true;
        }
        return false;
    }

    public static void writeIdIfNecessary(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        if (component.getId() != null && !component.getId().startsWith("j_id")) {
            writer.writeAttribute("id", (Object)component.getClientId(facesContext), null);
        }
    }

    public static void writeIdAndNameIfNecessary(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        if (component.getId() != null && !component.getId().startsWith("j_id")) {
            String clientId = component.getClientId(facesContext);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
        }
    }

    public static final boolean renderHTMLStringPreserveEmptyAttribute(ResponseWriter writer, UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
        String value = (String)component.getAttributes().get(componentProperty);
        if (!HtmlRendererUtils.isDefaultStringPreserveEmptyAttributeValue(value)) {
            writer.writeAttribute(htmlAttrName, (Object)value, componentProperty);
            return true;
        }
        return false;
    }

    public static final boolean renderHTMLStringPreserveEmptyAttribute(ResponseWriter writer, String componentProperty, String htmlAttrName, String value) throws IOException {
        if (!HtmlRendererUtils.isDefaultStringPreserveEmptyAttributeValue(value)) {
            writer.writeAttribute(htmlAttrName, (Object)value, componentProperty);
            return true;
        }
        return false;
    }

    private static final boolean isDefaultStringPreserveEmptyAttributeValue(String value) {
        return value == null;
    }

    public static final boolean renderHTMLStringAttribute(ResponseWriter writer, UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
        String value = (String)component.getAttributes().get(componentProperty);
        if (!HtmlRendererUtils.isDefaultStringAttributeValue(value)) {
            writer.writeAttribute(htmlAttrName, (Object)value, componentProperty);
            return true;
        }
        return false;
    }

    public static final boolean renderHTMLStringAttribute(ResponseWriter writer, String componentProperty, String htmlAttrName, String value) throws IOException {
        if (!HtmlRendererUtils.isDefaultStringAttributeValue(value)) {
            writer.writeAttribute(htmlAttrName, (Object)value, componentProperty);
            return true;
        }
        return false;
    }

    private static final boolean isDefaultStringAttributeValue(String value) {
        if (value == null) {
            return true;
        }
        return value.length() == 0;
    }

    public static boolean renderHTMLStringNoStyleAttributes(ResponseWriter writer, UIComponent component, String[] attributes) throws IOException {
        boolean somethingDone = false;
        for (String attrName : attributes) {
            if (!HtmlRendererUtils.renderHTMLStringAttribute(writer, component, attrName, attrName)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    public static void writeIdAndName(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        String clientId = component.getClientId(facesContext);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
    }

    public static void renderDisplayValueOnlyForSelects(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        HtmlRendererUtils.renderDisplayValueOnlyForSelects(facesContext, uiComponent, false);
    }

    public static void renderDisplayValueOnlyForSelects(FacesContext facesContext, UIComponent uiComponent, boolean considerValueType) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        List selectItemList = null;
        Converter converter = null;
        boolean isSelectOne = false;
        if (uiComponent instanceof UISelectBoolean) {
            converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, uiComponent);
            writer.startElement("span", uiComponent);
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            HtmlRendererUtils.renderDisplayValueOnlyAttributes(uiComponent, writer);
            writer.writeText((Object)RendererUtils.getConvertedStringValue(facesContext, uiComponent, converter, ((UISelectBoolean)uiComponent).getValue()), "value");
            writer.endElement("span");
        } else {
            if (uiComponent instanceof UISelectMany) {
                isSelectOne = false;
                selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent, facesContext);
                converter = HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, uiComponent, considerValueType);
            } else if (uiComponent instanceof UISelectOne) {
                isSelectOne = true;
                selectItemList = RendererUtils.getSelectItemList((UISelectOne)uiComponent, facesContext);
                converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, uiComponent);
            }
            writer.startElement(isSelectOne ? "span" : "ul", uiComponent);
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            HtmlRendererUtils.renderDisplayValueOnlyAttributes(uiComponent, writer);
            Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(uiComponent instanceof UISelectMany, uiComponent, facesContext, converter);
            HtmlRendererUtils.renderSelectOptionsAsText(facesContext, uiComponent, converter, lookupSet, selectItemList, isSelectOne);
            writer.writeText((Object)STR_EMPTY, null);
            writer.endElement(isSelectOne ? "span" : "ul");
        }
    }

    public static void renderDisplayValueOnlyAttributes(UIComponent uiComponent, ResponseWriter writer) throws IOException {
        if (!(uiComponent instanceof DisplayValueOnlyCapable)) {
            log.severe("Wrong type of uiComponent. needs DisplayValueOnlyCapable.");
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            return;
        }
        if (HtmlRendererUtils.getDisplayValueOnlyStyle(uiComponent) != null || HtmlRendererUtils.getDisplayValueOnlyStyleClass(uiComponent) != null) {
            if (HtmlRendererUtils.getDisplayValueOnlyStyle(uiComponent) != null) {
                writer.writeAttribute("style", (Object)HtmlRendererUtils.getDisplayValueOnlyStyle(uiComponent), null);
            } else if (uiComponent.getAttributes().get("style") != null) {
                writer.writeAttribute("style", uiComponent.getAttributes().get("style"), null);
            }
            if (HtmlRendererUtils.getDisplayValueOnlyStyleClass(uiComponent) != null) {
                writer.writeAttribute("class", (Object)HtmlRendererUtils.getDisplayValueOnlyStyleClass(uiComponent), null);
            } else if (uiComponent.getAttributes().get("styleClass") != null) {
                writer.writeAttribute("class", uiComponent.getAttributes().get("styleClass"), null);
            }
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_STYLE);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
        }
    }

    private static void renderSelectOptionsAsText(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List selectItemList, boolean isSelectOne) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (SelectItem selectItem : selectItemList) {
            if (selectItem instanceof SelectItemGroup) {
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                HtmlRendererUtils.renderSelectOptionsAsText(context, component, converter, lookupSet, Arrays.asList(selectItems), isSelectOne);
                continue;
            }
            String itemStrValue = RendererUtils.getConvertedStringValue(context, component, converter, selectItem);
            if (!lookupSet.contains(itemStrValue)) continue;
            if (!isSelectOne) {
                writer.startElement("li", component);
            }
            writer.writeText((Object)selectItem.getLabel(), null);
            if (!isSelectOne) {
                writer.endElement("li");
            }
            if (!isSelectOne) continue;
            return;
        }
    }

    public static void renderTableCaption(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        String captionStyle;
        String captionClass;
        UIComponent captionFacet = component.getFacet("caption");
        if (captionFacet == null) {
            return;
        }
        if (component instanceof HtmlPanelGrid) {
            HtmlPanelGrid panelGrid = (HtmlPanelGrid)component;
            captionClass = panelGrid.getCaptionClass();
            captionStyle = panelGrid.getCaptionStyle();
        } else if (component instanceof HtmlDataTable) {
            HtmlDataTable dataTable = (HtmlDataTable)component;
            captionClass = dataTable.getCaptionClass();
            captionStyle = dataTable.getCaptionStyle();
        } else {
            captionClass = (String)component.getAttributes().get("captionClass");
            captionStyle = (String)component.getAttributes().get("captionStyle");
        }
        HtmlRendererUtils.writePrettyLineSeparator(context);
        writer.startElement("caption", component);
        if (captionClass != null) {
            writer.writeAttribute("class", (Object)captionClass, null);
        }
        if (captionStyle != null) {
            writer.writeAttribute("style", (Object)captionStyle, null);
        }
        captionFacet.encodeAll(context);
        writer.endElement("caption");
    }

    public static String getDisplayValueOnlyStyleClass(UIComponent component) {
        if (component instanceof DisplayValueOnlyCapable) {
            if (((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyleClass() != null) {
                return ((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyleClass();
            }
            UIComponent parent = component;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof DisplayValueOnlyCapable) || ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyleClass() == null) continue;
                return ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyleClass();
            }
        }
        return null;
    }

    public static String getDisplayValueOnlyStyle(UIComponent component) {
        if (component instanceof DisplayValueOnlyCapable) {
            if (((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyle() != null) {
                return ((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyle();
            }
            UIComponent parent = component;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof DisplayValueOnlyCapable) || ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyle() == null) continue;
                return ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyle();
            }
        }
        return null;
    }

    public static boolean isDisplayValueOnly(UIComponent component) {
        if (component instanceof DisplayValueOnlyCapable) {
            if (((DisplayValueOnlyCapable)component).isSetDisplayValueOnly()) {
                return ((DisplayValueOnlyCapable)component).isDisplayValueOnly();
            }
            UIComponent parent = component;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof DisplayValueOnlyCapable) || !((DisplayValueOnlyCapable)parent).isSetDisplayValueOnly()) continue;
                return ((DisplayValueOnlyCapable)parent).isDisplayValueOnly();
            }
        }
        return false;
    }

    public static void renderDisplayValueOnly(FacesContext facesContext, UIInput input) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("span", (UIComponent)input);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)input, facesContext);
        HtmlRendererUtils.renderDisplayValueOnlyAttributes((UIComponent)input, writer);
        String strValue = RendererUtils.getStringValue(facesContext, (UIComponent)input);
        writer.write(HTMLEncoder.encode(strValue, true, true));
        writer.endElement("span");
    }

    public static void appendClearHiddenCommandFormParamsFunctionCall(StringBuilder buf, String formName) {
        HtmlJavaScriptUtils.appendClearHiddenCommandFormParamsFunctionCall(buf, formName);
    }

    public static void renderFormSubmitScript(FacesContext facesContext) throws IOException {
        HtmlJavaScriptUtils.renderFormSubmitScript(facesContext);
    }

    public static void appendAutoScrollAssignment(StringBuilder onClickValue, String formName) {
        HtmlJavaScriptUtils.appendAutoScrollAssignment(onClickValue, formName);
    }

    public static void appendAutoScrollAssignment(FacesContext context, StringBuilder onClickValue, String formName) {
        HtmlJavaScriptUtils.appendAutoScrollAssignment(context, onClickValue, formName);
    }

    public static void renderAutoScrollHiddenInput(FacesContext facesContext, ResponseWriter writer) throws IOException {
        HtmlJavaScriptUtils.renderAutoScrollHiddenInput(facesContext, writer);
    }

    public static void renderAutoScrollFunction(FacesContext facesContext, ResponseWriter writer) throws IOException {
        HtmlJavaScriptUtils.renderAutoScrollFunction(facesContext, writer);
    }

    public static String getAutoScrollFunction(FacesContext facesContext) {
        return HtmlJavaScriptUtils.getAutoScrollFunction(facesContext);
    }

    public static boolean isAllowedCdataSection(FacesContext fc) {
        Boolean value = null;
        if (fc != null) {
            value = (Boolean)fc.getExternalContext().getRequestMap().get(ALLOW_CDATA_SECTION_ON);
        }
        return value != null && value != false;
    }

    public static void allowCdataSection(FacesContext fc, boolean cdataSectionAllowed) {
        fc.getExternalContext().getRequestMap().put(ALLOW_CDATA_SECTION_ON, cdataSectionAllowed);
    }

    public static void renderHiddenCommandFormParams(ResponseWriter writer, Set dummyFormParams) throws IOException {
        for (Object name : dummyFormParams) {
            HtmlRendererUtils.renderHiddenInputField(writer, name, null);
        }
    }

    public static void renderHiddenInputField(ResponseWriter writer, Object name, Object value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", name, null);
        if (value != null) {
            writer.writeAttribute("value", value, null);
        }
        writer.endElement("input");
    }

    @Deprecated
    public static void renderLabel(ResponseWriter writer, UIComponent component, String forClientId, String labelValue, boolean disabled) throws IOException {
        writer.startElement("label", component);
        writer.writeAttribute("for", (Object)forClientId, null);
        String labelClass = null;
        labelClass = disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
        if (labelClass != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        if (labelValue != null && labelValue.length() > 0) {
            writer.write("&#160;");
            writer.writeText((Object)labelValue, null);
        }
        writer.endElement("label");
    }

    public static void renderLabel(ResponseWriter writer, UIComponent component, String forClientId, SelectItem item, boolean disabled) throws IOException {
        writer.startElement("label", component);
        writer.writeAttribute("for", (Object)forClientId, null);
        String labelClass = null;
        labelClass = disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
        if (labelClass != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        if (item.getLabel() != null && item.getLabel().length() > 0) {
            writer.write(" ");
            if (item.isEscape()) {
                writer.writeText((Object)item.getLabel(), null);
            } else {
                writer.write(item.getLabel());
            }
        }
        writer.endElement("label");
    }

    public static void renderLabel(ResponseWriter writer, UIComponent component, String forClientId, SelectItem item, boolean disabled, boolean selected) throws IOException {
        writer.startElement("label", component);
        writer.writeAttribute("for", (Object)forClientId, null);
        String labelClass = null;
        labelClass = disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
        String labelSelectedClass = null;
        labelSelectedClass = selected ? (String)component.getAttributes().get("selectedClass") : (String)component.getAttributes().get("unselectedClass");
        if (labelSelectedClass != null) {
            labelClass = labelClass == null ? labelSelectedClass : labelClass + " " + labelSelectedClass;
        }
        if (labelClass != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        if (item.getLabel() != null && item.getLabel().length() > 0) {
            writer.write("&#160;");
            if (item.isEscape()) {
                writer.writeText((Object)item.getLabel(), null);
            } else {
                writer.write(item.getLabel());
            }
        }
        writer.endElement("label");
    }

    public static void renderClearHiddenCommandFormParamsFunction(ResponseWriter writer, String formName, Set dummyFormParams, String formTarget) throws IOException {
        HtmlJavaScriptUtils.renderClearHiddenCommandFormParamsFunction(writer, formName, dummyFormParams, formTarget);
    }

    public static String getClearHiddenCommandFormParamsFunctionName(String formName) {
        return HtmlJavaScriptUtils.getClearHiddenCommandFormParamsFunctionName(formName);
    }

    public static String getClearHiddenCommandFormParamsFunctionNameMyfacesLegacy(String formName) {
        return HtmlJavaScriptUtils.getClearHiddenCommandFormParamsFunctionNameMyfacesLegacy(formName);
    }

    public static String getHiddenCommandLinkFieldName(FormInfo formInfo) {
        if (RendererUtils.isAdfOrTrinidadForm(formInfo.getForm())) {
            return HIDDEN_COMMANDLINK_FIELD_NAME_TRINIDAD;
        }
        return formInfo.getFormName() + UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()) + HIDDEN_COMMANDLINK_FIELD_NAME;
    }

    public static String getHiddenCommandLinkFieldName(FormInfo formInfo, FacesContext facesContext) {
        if (RendererUtils.isAdfOrTrinidadForm(formInfo.getForm())) {
            return HIDDEN_COMMANDLINK_FIELD_NAME_TRINIDAD;
        }
        return formInfo.getFormName() + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + HIDDEN_COMMANDLINK_FIELD_NAME;
    }

    public static boolean isPartialOrBehaviorSubmit(FacesContext facesContext, String clientId) {
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String sourceId = (String)params.get("javax.faces.source");
        if (sourceId == null || !sourceId.equals(clientId)) {
            return false;
        }
        boolean partialOrBehaviorSubmit = false;
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (behaviorEvent != null && (partialOrBehaviorSubmit = "action".equals(behaviorEvent))) {
            return partialOrBehaviorSubmit;
        }
        String partialEvent = (String)params.get("javax.faces.partial.event");
        if (partialEvent != null) {
            partialOrBehaviorSubmit = "click".equals(partialEvent);
        }
        return partialOrBehaviorSubmit;
    }

    public static String getHiddenCommandLinkFieldNameMyfacesOld(FormInfo formInfo) {
        return formInfo.getFormName() + UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()) + HIDDEN_COMMANDLINK_FIELD_NAME_MYFACES_OLD;
    }

    public static String getOutcomeTargetHref(FacesContext facesContext, UIOutcomeTarget component) throws IOException {
        Map<String, List<String>> navigationCaseParams;
        String outcome = component.getOutcome();
        outcome = outcome == null ? facesContext.getViewRoot().getViewId() : outcome;
        outcome = outcome == null ? STR_EMPTY : outcome.trim();
        NavigationHandler nh = facesContext.getApplication().getNavigationHandler();
        if (!(nh instanceof ConfigurableNavigationHandler)) {
            throw new FacesException("Navigation handler must be an instance of ConfigurableNavigationHandler for using h:link or h:button");
        }
        ConfigurableNavigationHandler navigationHandler = (ConfigurableNavigationHandler)nh;
        NavigationCase navigationCase = navigationHandler.getNavigationCase(facesContext, null, outcome);
        if (navigationCase == null) {
            log.warning("Could not determine NavigationCase for UIOutcomeTarget component " + RendererUtils.getPathToComponent((UIComponent)component));
            return null;
        }
        Map<String, List<Object>> parameters = null;
        if (component.getChildCount() > 0) {
            List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, component.getChildren(), true, false);
            if (validParams.size() > 0) {
                parameters = new HashMap();
            }
            int size = validParams.size();
            for (int i = 0; i < size; ++i) {
                UIParameter param = validParams.get(i);
                String name = param.getName();
                Object value = param.getValue();
                if (parameters.containsKey(name)) {
                    ((List)parameters.get(name)).add(value.toString());
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(value.toString());
                parameters.put(name, list);
            }
        }
        if ((navigationCaseParams = NavigationUtils.getEvaluatedNavigationParameters(facesContext, navigationCase.getParameters())) != null) {
            if (parameters == null) {
                parameters = new HashMap();
            }
            for (Map.Entry<String, List<String>> entry : navigationCaseParams.entrySet()) {
                if (parameters.containsKey(entry.getKey())) continue;
                parameters.put(entry.getKey(), entry.getValue());
            }
        }
        if (parameters == null) {
            parameters = Collections.emptyMap();
        }
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String href = viewHandler.getBookmarkableURL(facesContext, navigationCase.getToViewId(facesContext), parameters, navigationCase.isIncludeViewParams() || component.isIncludeViewParams());
        String fragment = (String)component.getAttributes().get("fragment");
        if (fragment != null && (fragment = fragment.trim()).length() > 0) {
            href = href + "#" + fragment;
        }
        return href;
    }

    @Deprecated
    public static String selectContentType(String contentTypeListString) {
        if (contentTypeListString == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (context != null && (contentTypeListString = (String)context.getExternalContext().getRequestHeaderMap().get("Accept")) != null && contentTypeListString.startsWith("application/vnd.wap.mms-message;*/*")) {
                contentTypeListString = ANY_CONTENT_TYPE;
            }
            if (contentTypeListString == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("No content type list given, creating HtmlResponseWriterImpl with default content type.");
                }
                contentTypeListString = HTML_CONTENT_TYPE;
            }
        }
        List contentTypeList = HtmlRendererUtils.splitContentTypeListString(contentTypeListString);
        String[] supportedContentTypeArray = HtmlRendererUtils.getSupportedContentTypes();
        String selectedContentType = null;
        for (int i = 0; i < supportedContentTypeArray.length; ++i) {
            String supportedContentType = supportedContentTypeArray[i].trim();
            for (int j = 0; j < contentTypeList.size(); ++j) {
                String contentType = (String)contentTypeList.get(j);
                if (contentType.indexOf(supportedContentType) == -1) continue;
                if (HtmlRendererUtils.isHTMLContentType(contentType)) {
                    selectedContentType = HTML_CONTENT_TYPE;
                    break;
                }
                if (!HtmlRendererUtils.isXHTMLContentType(contentType)) break;
                selectedContentType = XHTML_CONTENT_TYPE;
                break;
            }
            if (selectedContentType != null) break;
        }
        if (selectedContentType == null) {
            throw new IllegalArgumentException("ContentTypeList does not contain a supported content type: " + contentTypeListString);
        }
        return selectedContentType;
    }

    public static String[] getSupportedContentTypes() {
        return SUPPORTED_CONTENT_TYPES;
    }

    private static boolean isHTMLContentType(String contentType) {
        return contentType.indexOf(HTML_CONTENT_TYPE) != -1 || contentType.indexOf(ANY_CONTENT_TYPE) != -1 || contentType.indexOf(TEXT_ANY_CONTENT_TYPE) != -1;
    }

    public static boolean isXHTMLContentType(String contentType) {
        return contentType.indexOf(XHTML_CONTENT_TYPE) != -1 || contentType.indexOf(APPLICATION_XML_CONTENT_TYPE) != -1 || contentType.indexOf(TEXT_XML_CONTENT_TYPE) != -1;
    }

    private static List splitContentTypeListString(String contentTypeListString) {
        ArrayList<String> contentTypeList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(contentTypeListString, ",");
        while (st.hasMoreTokens()) {
            String contentType = st.nextToken().trim();
            int semicolonIndex = contentType.indexOf(";");
            if (semicolonIndex != -1) {
                contentType = contentType.substring(0, semicolonIndex);
            }
            contentTypeList.add(contentType);
        }
        return contentTypeList;
    }

    public static String getJavascriptLocation(UIComponent component) {
        if (component == null) {
            return null;
        }
        return (String)component.getAttributes().get("javascriptLocation");
    }

    public static String getImageLocation(UIComponent component) {
        if (component == null) {
            return null;
        }
        return (String)component.getAttributes().get("imageLocation");
    }

    public static String getStyleLocation(UIComponent component) {
        if (component == null) {
            return null;
        }
        return (String)component.getAttributes().get("styleLocation");
    }

    public static boolean hasClientBehavior(String eventName, Map<String, List<ClientBehavior>> behaviors, FacesContext facesContext) {
        if (behaviors == null) {
            return false;
        }
        return behaviors.get(eventName) != null;
    }

    public static Collection<ClientBehaviorContext.Parameter> getClientBehaviorContextParameters(Map<String, String> params) {
        ArrayList<ClientBehaviorContext.Parameter> paramList = null;
        if (params != null) {
            paramList = new ArrayList<ClientBehaviorContext.Parameter>(params.size());
            for (Map.Entry<String, String> paramEntry : params.entrySet()) {
                paramList.add(new ClientBehaviorContext.Parameter(paramEntry.getKey(), (Object)paramEntry.getValue()));
            }
        }
        return paramList;
    }

    private static boolean getClientBehaviorScript(FacesContext facesContext, UIComponent uiComponent, String eventName, Map<String, List<ClientBehavior>> clientBehaviors, ScriptContext target, Collection<ClientBehaviorContext.Parameter> params) {
        return HtmlRendererUtils.getClientBehaviorScript(facesContext, uiComponent, uiComponent.getClientId(facesContext), eventName, clientBehaviors, target, params);
    }

    private static boolean getClientBehaviorScript(FacesContext facesContext, UIComponent uiComponent, String targetClientId, String eventName, Map<String, List<ClientBehavior>> clientBehaviors, ScriptContext target, Collection<ClientBehaviorContext.Parameter> params) {
        boolean renderClientBehavior;
        if (!(uiComponent instanceof ClientBehaviorHolder)) {
            target.append(STR_EMPTY);
            return false;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        boolean bl = renderClientBehavior = JavascriptUtils.isJavascriptAllowed(externalContext) && clientBehaviors != null && clientBehaviors.size() > 0;
        if (!renderClientBehavior) {
            target.append(STR_EMPTY);
            return false;
        }
        List<ClientBehavior> attachedEventBehaviors = clientBehaviors.get(eventName);
        if (attachedEventBehaviors == null || attachedEventBehaviors.size() == 0) {
            target.append(STR_EMPTY);
            return false;
        }
        ClientBehaviorContext context = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)uiComponent, (String)eventName, (String)targetClientId, params);
        boolean submitting = false;
        if (attachedEventBehaviors instanceof RandomAccess) {
            int size = attachedEventBehaviors.size();
            for (int i = 0; i < size; ++i) {
                ClientBehavior clientBehavior = attachedEventBehaviors.get(i);
                submitting = HtmlRendererUtils._appendClientBehaviourScript(target, context, submitting, i < size - 1, clientBehavior);
            }
        } else {
            Iterator<ClientBehavior> clientIterator = attachedEventBehaviors.iterator();
            while (clientIterator.hasNext()) {
                ClientBehavior clientBehavior = clientIterator.next();
                submitting = HtmlRendererUtils._appendClientBehaviourScript(target, context, submitting, clientIterator.hasNext(), clientBehavior);
            }
        }
        return submitting;
    }

    private static boolean _appendClientBehaviourScript(ScriptContext target, ClientBehaviorContext context, boolean submitting, boolean hasNext, ClientBehavior clientBehavior) {
        String script = clientBehavior.getScript(context);
        if (script != null) {
            target.append("'" + HtmlRendererUtils.escapeJavaScriptForChain(script) + "'");
            if (hasNext) {
                target.append(", ");
            }
        }
        if (!submitting) {
            submitting = clientBehavior.getHints().contains(ClientBehaviorHint.SUBMITTING);
        }
        return submitting;
    }

    public static String buildBehaviorChain(FacesContext facesContext, UIComponent uiComponent, String eventName, Collection<ClientBehaviorContext.Parameter> params, Map<String, List<ClientBehavior>> clientBehaviors, String userEventCode, String serverEventCode) {
        return HtmlRendererUtils.buildBehaviorChain(facesContext, uiComponent, uiComponent.getClientId(facesContext), eventName, params, clientBehaviors, userEventCode, serverEventCode);
    }

    public static String buildBehaviorChain(FacesContext facesContext, UIComponent uiComponent, String targetClientId, String eventName, Collection<ClientBehaviorContext.Parameter> params, Map<String, List<ClientBehavior>> clientBehaviors, String userEventCode, String serverEventCode) {
        Iterator it;
        ExternalContext externalContext = facesContext.getExternalContext();
        boolean renderCode = JavascriptUtils.isJavascriptAllowed(externalContext);
        if (!renderCode) {
            return STR_EMPTY;
        }
        ArrayList<String> finalParams = new ArrayList<String>(3);
        if (userEventCode != null && !userEventCode.trim().equals(STR_EMPTY)) {
            finalParams.add('\'' + HtmlRendererUtils.escapeJavaScriptForChain(userEventCode) + '\'');
        }
        MyfacesConfig currentInstance = MyfacesConfig.getCurrentInstance(externalContext);
        ScriptContext behaviorCode = new ScriptContext();
        ScriptContext retVal = new ScriptContext(currentInstance.isPrettyHtml());
        HtmlRendererUtils.getClientBehaviorScript(facesContext, uiComponent, targetClientId, eventName, clientBehaviors, behaviorCode, params);
        if (behaviorCode != null && !behaviorCode.toString().trim().equals(STR_EMPTY)) {
            finalParams.add(behaviorCode.toString());
        }
        if (serverEventCode != null && !serverEventCode.trim().equals(STR_EMPTY)) {
            finalParams.add('\'' + HtmlRendererUtils.escapeJavaScriptForChain(serverEventCode) + '\'');
        }
        if ((it = finalParams.iterator()).hasNext()) {
            retVal.append("jsf.util.chain(document.getElementById('" + targetClientId + "'), event,");
            while (it.hasNext()) {
                retVal.append((String)it.next());
                if (!it.hasNext()) continue;
                retVal.append(", ");
            }
            retVal.append(");");
        }
        return retVal.toString();
    }

    public static String buildBehaviorChain(FacesContext facesContext, UIComponent uiComponent, String eventName1, Collection<ClientBehaviorContext.Parameter> params, String eventName2, Collection<ClientBehaviorContext.Parameter> params2, Map<String, List<ClientBehavior>> clientBehaviors, String userEventCode, String serverEventCode) {
        return HtmlRendererUtils.buildBehaviorChain(facesContext, uiComponent, uiComponent.getClientId(facesContext), eventName1, params, eventName2, params2, clientBehaviors, userEventCode, serverEventCode);
    }

    public static String buildBehaviorChain(FacesContext facesContext, UIComponent uiComponent, String targetClientId, String eventName1, Collection<ClientBehaviorContext.Parameter> params, String eventName2, Collection<ClientBehaviorContext.Parameter> params2, Map<String, List<ClientBehavior>> clientBehaviors, String userEventCode, String serverEventCode) {
        int size;
        boolean submitting;
        ExternalContext externalContext = facesContext.getExternalContext();
        boolean renderCode = JavascriptUtils.isJavascriptAllowed(externalContext);
        if (!renderCode) {
            return STR_EMPTY;
        }
        ArrayList<String> finalParams = new ArrayList<String>(3);
        if (userEventCode != null && !userEventCode.trim().equals(STR_EMPTY)) {
            finalParams.add('\'' + HtmlRendererUtils.escapeJavaScriptForChain(userEventCode) + '\'');
        }
        MyfacesConfig currentInstance = MyfacesConfig.getCurrentInstance(externalContext);
        ScriptContext behaviorCode = new ScriptContext();
        ScriptContext retVal = new ScriptContext(currentInstance.isPrettyHtml());
        boolean submitting1 = HtmlRendererUtils.getClientBehaviorScript(facesContext, uiComponent, targetClientId, eventName1, clientBehaviors, behaviorCode, params);
        ScriptContext behaviorCode2 = new ScriptContext();
        boolean submitting2 = HtmlRendererUtils.getClientBehaviorScript(facesContext, uiComponent, targetClientId, eventName2, clientBehaviors, behaviorCode2, params2);
        boolean bl = submitting = submitting1 || submitting2;
        if (behaviorCode != null && !behaviorCode.toString().trim().equals(STR_EMPTY)) {
            finalParams.add(behaviorCode.toString());
        }
        if (behaviorCode2 != null && !behaviorCode2.toString().trim().equals(STR_EMPTY)) {
            finalParams.add(behaviorCode2.toString());
        }
        if (serverEventCode != null && !serverEventCode.trim().equals(STR_EMPTY)) {
            finalParams.add('\'' + HtmlRendererUtils.escapeJavaScriptForChain(serverEventCode) + '\'');
        }
        if ((size = finalParams.size()) > 0) {
            if (!submitting) {
                retVal.append("return ");
            }
            retVal.append("jsf.util.chain(document.getElementById('" + targetClientId + "'), event,");
            int cursor = 0;
            while (cursor != size) {
                retVal.append((String)finalParams.get(cursor));
                if (++cursor == size) continue;
                retVal.append(", ");
            }
            retVal.append(");");
            if (submitting) {
                retVal.append(" return false;");
            }
        }
        return retVal.toString();
    }

    public static String escapeJavaScriptForChain(String javaScript) {
        return HtmlJavaScriptUtils.escapeJavaScriptForChain(javaScript);
    }

    public static Map<String, String> mapAttachedParamsToStringValues(FacesContext facesContext, UIComponent uiComponent) {
        Map<String, String> retVal = null;
        if (uiComponent.getChildCount() > 0) {
            List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, uiComponent.getChildren(), true, true);
            int size = validParams.size();
            for (int i = 0; i < size; ++i) {
                UIParameter param = validParams.get(i);
                String name = param.getName();
                Object value = param.getValue();
                if (retVal == null) {
                    retVal = new HashMap<String, String>();
                }
                if (value instanceof String) {
                    retVal.put(name, (String)value);
                    continue;
                }
                retVal.put(name, value.toString());
            }
        }
        if (retVal == null) {
            retVal = Collections.emptyMap();
        }
        return retVal;
    }

    public static List<UIParameter> getValidUIParameterChildren(FacesContext facesContext, List<UIComponent> children, boolean skipNullValue, boolean skipUnrendered) {
        return HtmlRendererUtils.getValidUIParameterChildren(facesContext, children, skipNullValue, skipUnrendered, true);
    }

    public static List<UIParameter> getValidUIParameterChildren(FacesContext facesContext, List<UIComponent> children, boolean skipNullValue, boolean skipUnrendered, boolean skipNullName) {
        List<UIParameter> params = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            UIParameter param;
            UIComponent child = children.get(i);
            if (!(child instanceof UIParameter) || (param = (UIParameter)child).isDisable() || skipUnrendered && !param.isRendered()) continue;
            String name = param.getName();
            if (skipNullName && (name == null || STR_EMPTY.equals(name))) {
                log.log(Level.WARNING, "The UIParameter " + RendererUtils.getPathToComponent((UIComponent)param) + " has a name of null or empty string and thus will not be added to the URL.");
                continue;
            }
            if (skipNullValue && param.getValue() == null) {
                if (!facesContext.isProjectStage(ProjectStage.Development)) continue;
                log.log(Level.INFO, "The UIParameter " + RendererUtils.getPathToComponent((UIComponent)param) + " has a value of null and thus will not be added to the URL.");
                continue;
            }
            if (params == null) {
                params = new ArrayList<UIParameter>();
            }
            params.add(param);
        }
        if (params == null) {
            params = Collections.emptyList();
        }
        return params;
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, eventName, clientBehaviors, componentProperty);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String targetClientId, String eventName, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, targetClientId, eventName, clientBehaviors, componentProperty);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, eventName, null, clientBehaviors, htmlAttrName, (String)component.getAttributes().get(componentProperty));
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String targetClientId, String eventName, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, targetClientId, eventName, null, clientBehaviors, htmlAttrName, (String)component.getAttributes().get(componentProperty));
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, component.getClientId(facesContext), eventName, eventParameters, clientBehaviors, htmlAttrName, attributeValue);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String targetClientId, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue) throws IOException {
        List<ClientBehavior> cbl;
        List<ClientBehavior> list = cbl = clientBehaviors != null ? clientBehaviors.get(eventName) : null;
        if (cbl == null || cbl.size() == 0) {
            return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, (Object)attributeValue);
        }
        if (cbl.size() > 1 || cbl.size() == 1 && attributeValue != null) {
            return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, (Object)HtmlRendererUtils.buildBehaviorChain(facesContext, component, targetClientId, eventName, eventParameters, clientBehaviors, attributeValue, STR_EMPTY));
        }
        return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, (Object)cbl.get(0).getScript(ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)component, (String)eventName, (String)targetClientId, eventParameters)));
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue, String serverSideScript) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, component.getClientId(facesContext), eventName, eventParameters, clientBehaviors, htmlAttrName, attributeValue, serverSideScript);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String targetClientId, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue, String serverSideScript) throws IOException {
        List<ClientBehavior> cbl = clientBehaviors != null ? clientBehaviors.get(eventName) : null;
        if ((cbl != null ? cbl.size() : 0) + (attributeValue != null ? 1 : 0) + (serverSideScript != null ? 1 : 0) <= 1) {
            if (cbl == null || cbl.size() == 0) {
                if (attributeValue != null) {
                    return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, attributeValue);
                }
                return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, serverSideScript);
            }
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, cbl.get(0).getScript(ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)component, (String)eventName, (String)targetClientId, eventParameters)));
        }
        return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, HtmlRendererUtils.buildBehaviorChain(facesContext, component, targetClientId, eventName, eventParameters, clientBehaviors, attributeValue, serverSideScript));
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, String eventName2, Collection<ClientBehaviorContext.Parameter> eventParameters2, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue, String serverSideScript) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, component.getClientId(facesContext), eventName, eventParameters, eventName2, eventParameters2, clientBehaviors, htmlAttrName, attributeValue, serverSideScript);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String targetClientId, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, String eventName2, Collection<ClientBehaviorContext.Parameter> eventParameters2, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue, String serverSideScript) throws IOException {
        List<ClientBehavior> cb2;
        List<ClientBehavior> cb1 = clientBehaviors != null ? clientBehaviors.get(eventName) : null;
        if ((cb1 != null ? cb1.size() : 0) + ((cb2 = clientBehaviors != null ? clientBehaviors.get(eventName2) : null) != null ? cb2.size() : 0) + (attributeValue != null ? 1 : 0) <= 1) {
            if (attributeValue != null) {
                return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, attributeValue);
            }
            if (serverSideScript != null) {
                return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, serverSideScript);
            }
            if ((cb1 != null ? cb1.size() : 0) > 0) {
                return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, cb1.get(0).getScript(ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)component, (String)eventName, (String)targetClientId, eventParameters)));
            }
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, cb2.get(0).getScript(ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)component, (String)eventName2, (String)targetClientId, eventParameters2)));
        }
        return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, HtmlRendererUtils.buildBehaviorChain(facesContext, component, targetClientId, eventName, eventParameters, eventName2, eventParameters2, clientBehaviors, attributeValue, serverSideScript));
    }

    public static void renderBehaviorizedEventHandlers(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, uiComponent.getClientId(facesContext), clientBehaviors);
    }

    public static void renderBehaviorizedEventHandlers(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onclick", uiComponent, targetClientId, "click", clientBehaviors, "onclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, targetClientId, "dblclick", clientBehaviors, "ondblclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, targetClientId, "mousedown", clientBehaviors, "onmousedown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, targetClientId, "mouseup", clientBehaviors, "onmouseup");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, targetClientId, "mouseover", clientBehaviors, "onmouseover");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, targetClientId, "mousemove", clientBehaviors, "onmousemove");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, targetClientId, "mouseout", clientBehaviors, "onmouseout");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, targetClientId, "keypress", clientBehaviors, "onkeypress");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, targetClientId, "keydown", clientBehaviors, "onkeydown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, targetClientId, "keyup", clientBehaviors, "onkeyup");
    }

    public static void renderBehaviorizedEventHandlersWithoutOnclick(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, "dblclick", clientBehaviors, "ondblclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, "mousedown", clientBehaviors, "onmousedown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, "mouseup", clientBehaviors, "onmouseup");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, "mouseover", clientBehaviors, "onmouseover");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, "mousemove", clientBehaviors, "onmousemove");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, "mouseout", clientBehaviors, "onmouseout");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, "keypress", clientBehaviors, "onkeypress");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, "keydown", clientBehaviors, "onkeydown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, "keyup", clientBehaviors, "onkeyup");
    }

    public static void renderBehaviorizedEventHandlersWithoutOnmouseoverAndOnmouseout(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onclick", uiComponent, "click", clientBehaviors, "onclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, "dblclick", clientBehaviors, "ondblclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, "mousedown", clientBehaviors, "onmousedown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, "mouseup", clientBehaviors, "onmouseup");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, "mousemove", clientBehaviors, "onmousemove");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, "keypress", clientBehaviors, "onkeypress");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, "keydown", clientBehaviors, "onkeydown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, "keyup", clientBehaviors, "onkeyup");
    }

    public static void renderBehaviorizedFieldEventHandlers(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, "focus", clientBehaviors, "onfocus");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, "blur", clientBehaviors, "onblur");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, "change", clientBehaviors, "onchange");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, "select", clientBehaviors, "onselect");
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnfocus(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, "blur", clientBehaviors, "onblur");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, "change", clientBehaviors, "onchange");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, "select", clientBehaviors, "onselect");
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchange(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, "focus", clientBehaviors, "onfocus");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, "blur", clientBehaviors, "onblur");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, "select", clientBehaviors, "onselect");
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchange(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, targetClientId, "focus", clientBehaviors, "onfocus");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, targetClientId, "blur", clientBehaviors, "onblur");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, targetClientId, "select", clientBehaviors, "onselect");
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, "focus", clientBehaviors, "onfocus");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, "blur", clientBehaviors, "onblur");
    }

    public static boolean renderBehaviorizedOnchangeEventHandler(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        boolean hasChange = HtmlRendererUtils.hasClientBehavior("change", clientBehaviors, facesContext);
        boolean hasValueChange = HtmlRendererUtils.hasClientBehavior("valueChange", clientBehaviors, facesContext);
        if (hasChange && hasValueChange) {
            String chain = HtmlRendererUtils.buildBehaviorChain(facesContext, uiComponent, "change", null, "valueChange", null, clientBehaviors, (String)uiComponent.getAttributes().get("onchange"), null);
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, "onchange", "onchange", chain);
        }
        if (hasChange) {
            return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, "change", clientBehaviors, "onchange");
        }
        if (hasValueChange) {
            return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, "valueChange", clientBehaviors, "onchange");
        }
        return HtmlRendererUtils.renderHTMLStringAttribute(writer, uiComponent, "onchange", "onchange");
    }

    public static boolean renderBehaviorizedOnchangeEventHandler(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        boolean hasChange = HtmlRendererUtils.hasClientBehavior("change", clientBehaviors, facesContext);
        boolean hasValueChange = HtmlRendererUtils.hasClientBehavior("valueChange", clientBehaviors, facesContext);
        if (hasChange && hasValueChange) {
            String chain = HtmlRendererUtils.buildBehaviorChain(facesContext, uiComponent, targetClientId, "change", null, "valueChange", null, clientBehaviors, (String)uiComponent.getAttributes().get("onchange"), null);
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, "onchange", "onchange", chain);
        }
        if (hasChange) {
            return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, targetClientId, "change", clientBehaviors, "onchange");
        }
        if (hasValueChange) {
            return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, targetClientId, "valueChange", clientBehaviors, "onchange");
        }
        return HtmlRendererUtils.renderHTMLStringAttribute(writer, uiComponent, "onchange", "onchange");
    }

    public static void renderViewStateJavascript(FacesContext facesContext, String hiddenId, String serializedState) throws IOException {
        HtmlJavaScriptUtils.renderViewStateJavascript(facesContext, hiddenId, serializedState);
    }

    public static boolean isHideNoSelectionOption(UIComponent component) {
        Object hideNoSelectionOptionAttr = component.getAttributes().get("hideNoSelectionOption");
        return hideNoSelectionOptionAttr instanceof String && "true".equalsIgnoreCase((String)hideNoSelectionOptionAttr) || hideNoSelectionOptionAttr instanceof Boolean && (Boolean)hideNoSelectionOptionAttr != false;
    }

    public static void renderUnhandledFacesMessages(FacesContext facesContext) throws IOException {
        HtmlMessages messages = (HtmlMessages)facesContext.getApplication().createComponent("javax.faces.HtmlMessages");
        messages.setId("javax_faces_developmentstage_messages");
        messages.setTitle("Project Stage[Development]: Unhandled Messages");
        messages.setStyle("color:orange");
        messages.setRedisplay(false);
        messages.encodeAll(facesContext);
    }

    public static class ScriptContext
    extends JavascriptContext {
        public ScriptContext() {
        }

        public ScriptContext(boolean prettyPrint) {
            super(prettyPrint);
        }

        public ScriptContext(StringBuilder buf, boolean prettyPrint) {
            super(buf, prettyPrint);
        }
    }

    public static class LinkParameter {
        private String _name;
        private Object _value;

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object value) {
            this._value = value;
        }
    }
}

