/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import javax.faces.component.ActionSource;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXSingleStep
extends UIXComponentBase
implements ActionSource {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey SELECTED_STEP_KEY = TYPE.registerKey("selectedStep", Integer.class, (Object)1);
    public static final PropertyKey MAX_STEP_KEY = TYPE.registerKey("maxStep", Integer.class, (Object)-1);
    public static final PropertyKey PREVIOUS_ACTION_LISTENER_KEY = TYPE.registerKey("previousActionListener", MethodBinding.class, 9);
    public static final PropertyKey NEXT_ACTION_LISTENER_KEY = TYPE.registerKey("nextActionListener", MethodBinding.class, 9);
    public static final PropertyKey NEXT_ACTION_KEY = TYPE.registerKey("nextAction", MethodBinding.class, 9);
    public static final PropertyKey PREVIOUS_ACTION_KEY = TYPE.registerKey("previousAction", MethodBinding.class, 9);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.SingleStep";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.SingleStep";
    private Object _actionType = NEXT_ACTION_TYPE;
    public static final Object NEXT_ACTION_TYPE = new Object();
    public static final Object PREVIOUS_ACTION_TYPE = new Object();

    public UIXSingleStep() {
        super("org.apache.myfaces.trinidad.ButtonBar");
    }

    public void queueEvent(FacesEvent e) {
        if (e.getSource() == this) {
            if (this.getActionType() == PREVIOUS_ACTION_TYPE) {
                e.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                e.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(e);
    }

    public Object getActionType() {
        return this._actionType;
    }

    public void setActionType(Object actionType) {
        this._actionType = actionType;
    }

    public Object saveState(FacesContext context) {
        return super.saveState(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        FacesContext context = this.getFacesContext();
        if (event instanceof ActionEvent) {
            if (this.getActionType() == PREVIOUS_ACTION_TYPE) {
                this.broadcastToMethodBinding(event, this.getPreviousActionListener());
            } else {
                this.broadcastToMethodBinding(event, this.getNextActionListener());
            }
            ActionListener defaultActionListener = context.getApplication().getActionListener();
            if (defaultActionListener != null) {
                defaultActionListener.processAction((ActionEvent)event);
            }
        }
    }

    public MethodBinding getAction() {
        if (this.getActionType() == PREVIOUS_ACTION_TYPE) {
            return this.getPreviousAction();
        }
        return this.getNextAction();
    }

    public void setAction(MethodBinding action) {
        if (this.getActionType() == PREVIOUS_ACTION_TYPE) {
            this.setPreviousAction(action);
        } else {
            this.setNextAction(action);
        }
    }

    public MethodBinding getActionListener() {
        if (this.getActionType() == PREVIOUS_ACTION_TYPE) {
            return this.getPreviousActionListener();
        }
        return this.getNextActionListener();
    }

    public void setActionListener(MethodBinding listener) {
        if (this.getActionType() == PREVIOUS_ACTION_TYPE) {
            this.setPreviousActionListener(listener);
        } else {
            this.setNextActionListener(listener);
        }
    }

    public boolean isImmediate() {
        return this.getActionType() == PREVIOUS_ACTION_TYPE;
    }

    public void setImmediate(boolean immediate) {
    }

    public final int getSelectedStep() {
        return ComponentUtils.resolveInteger(this.getProperty(SELECTED_STEP_KEY), 1);
    }

    public final void setSelectedStep(int selectedStep) {
        this.setProperty(SELECTED_STEP_KEY, selectedStep);
    }

    public final void setSelectedStep(long selectedStep) {
        this.setProperty(SELECTED_STEP_KEY, selectedStep);
    }

    public final int getMaxStep() {
        return ComponentUtils.resolveInteger(this.getProperty(MAX_STEP_KEY), -1);
    }

    public final void setMaxStep(int maxStep) {
        this.setProperty(MAX_STEP_KEY, maxStep);
    }

    public final void setMaxStep(long maxStep) {
        this.setProperty(MAX_STEP_KEY, maxStep);
    }

    public final MethodBinding getPreviousActionListener() {
        return (MethodBinding)this.getProperty(PREVIOUS_ACTION_LISTENER_KEY);
    }

    public final void setPreviousActionListener(MethodBinding previousActionListener) {
        this.setProperty(PREVIOUS_ACTION_LISTENER_KEY, previousActionListener);
    }

    public final MethodBinding getNextActionListener() {
        return (MethodBinding)this.getProperty(NEXT_ACTION_LISTENER_KEY);
    }

    public final void setNextActionListener(MethodBinding nextActionListener) {
        this.setProperty(NEXT_ACTION_LISTENER_KEY, nextActionListener);
    }

    public final MethodBinding getNextAction() {
        return (MethodBinding)this.getProperty(NEXT_ACTION_KEY);
    }

    public final void setNextAction(MethodBinding nextAction) {
        this.setProperty(NEXT_ACTION_KEY, nextAction);
    }

    public final MethodBinding getPreviousAction() {
        return (MethodBinding)this.getProperty(PREVIOUS_ACTION_KEY);
    }

    public final void setPreviousAction(MethodBinding previousAction) {
        this.setProperty(PREVIOUS_ACTION_KEY, previousAction);
    }

    public final void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public final void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public final ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.SingleStep";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXSingleStep(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.SingleStep", "org.apache.myfaces.trinidad.ButtonBar");
    }
}

