/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputLabel;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AccessKeyUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ValueRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.util.MessageUtils;

public class OutputLabelRenderer
extends ValueRenderer {
    private PropertyKey _accessKeyKey;
    private PropertyKey _forKey;
    private PropertyKey _messageTypeKey;
    private PropertyKey _showRequiredKey;

    public OutputLabelRenderer() {
        this(CoreOutputLabel.TYPE);
    }

    protected OutputLabelRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._accessKeyKey = type.findKey("accessKey");
        this._forKey = type.findKey("for");
        this._messageTypeKey = type.findKey("messageType");
        this._showRequiredKey = type.findKey("showRequired");
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        boolean noSpanNeeded;
        ResponseWriter rw = context.getResponseWriter();
        String value = this.getConvertedString(context, component, bean);
        String forId = this.getForId(context, component, bean);
        FormData fd = arc.getFormData();
        if (fd != null) {
            fd.addLabel(forId, value);
        }
        String messageType = this._getMessageType(context, bean, forId);
        boolean bl = noSpanNeeded = value == null && (messageType == null || "none".equals(messageType));
        if (!noSpanNeeded) {
            rw.startElement("span", (UIComponent)(this.needComponentInStartElement() ? component : null));
            this.renderId(context, component);
            this.renderAllAttributes(context, arc, bean);
        }
        boolean encodedIcons = this.encodeIcons(context, arc, component, bean, messageType, forId);
        if (value != null) {
            char accessKey;
            int accessKeyIndex;
            boolean needsLabel;
            if (encodedIcons) {
                rw.writeText((Object)XhtmlConstants.NBSP_STRING, null);
            }
            if (needsLabel = this.isLabelTagNeeded(arc, bean, forId, accessKeyIndex = AccessKeyUtils.getAccessKeyIndex(value, accessKey = OutputLabelRenderer.supportsAccessKeys(arc) ? (char)this.getAccessKey(bean) : (char)'\uffff'))) {
                rw.startElement("label", (UIComponent)(this.needComponentInStartElement() ? component : null));
                if (forId != null) {
                    rw.writeAttribute("for", (Object)forId, "for");
                    HiddenLabelUtils.rememberLabel(arc, forId);
                }
                if (accessKey != '\uffff') {
                    rw.writeAttribute("accesskey", (Object)Character.valueOf(accessKey), "accessKey");
                }
            }
            AccessKeyUtils.renderAccessKeyText(context, (Object)value, accessKey, "AFAccessKeyStyle");
            if (needsLabel) {
                rw.endElement("label");
            }
        }
        if (!noSpanNeeded) {
            rw.endElement("span");
        }
    }

    protected boolean needComponentInStartElement() {
        return true;
    }

    protected boolean encodeIcons(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, String messageType, String forId) throws IOException {
        boolean isInline;
        boolean encodedIcons = false;
        boolean bl = isInline = RequestContext.getCurrentInstance().getClientValidation() == RequestContext.ClientValidation.INLINE;
        if (this._shouldRenderMessageSymbol(arc, messageType, isInline, forId)) {
            String vAlign = this.getDefaultValign(bean);
            String destination = this.getMessageDescUrl(bean);
            String targetFrame = this.getMessageTargetFrame(bean);
            String anchor = MessageUtils.getAnchor(forId);
            ResponseWriter rw = context.getResponseWriter();
            if (isInline) {
                rw.startElement("span", component);
                rw.writeAttribute("id", (Object)(forId + "::icon"), null);
                if (null == messageType || "none".equals(messageType)) {
                    messageType = "error";
                    rw.writeAttribute("style", (Object)"display:none;", null);
                }
            }
            encodedIcons = this.renderMessageSymbol(context, arc, messageType, destination, anchor, targetFrame, vAlign);
            if (isInline) {
                rw.endElement("span");
            }
        }
        if (this.getShowRequired(bean)) {
            Icon icon = arc.getIcon("AFRequiredIcon");
            if (icon != null) {
                String vAlign = this.getDefaultValign(bean);
                this._renderIcon(context, arc, icon, null, null, null, "REQUIRED_TIP", vAlign);
            }
            encodedIcons = true;
        }
        return encodedIcons;
    }

    protected boolean isLabelTagNeeded(RenderingContext arc, FacesBean bean, String forId, int accessKeyIndex) {
        return forId != null && !OutputLabelRenderer.isInaccessibleMode((RenderingContext)arc) || accessKeyIndex >= 0;
    }

    protected boolean renderMessageSymbol(FacesContext context, RenderingContext arc, Object type, Object destination, Object anchor, Object targetFrame, Object vAlign) throws IOException {
        Icon icon;
        String iconName = null;
        String altTextKey = null;
        if ("error".equals(type)) {
            iconName = destination == null ? "AFErrorIcon" : "AFErrorAnchorIcon";
            altTextKey = "ERROR_TIP";
        } else if ("info".equals(type)) {
            iconName = destination == null ? "AFInfoIcon" : "AFInfoAnchorIcon";
            altTextKey = "INFO_TIP";
        } else if ("warning".equals(type)) {
            iconName = destination == null ? "AFWarningIcon" : "AFWarningAnchorIcon";
            altTextKey = "WARNING_TIP";
        }
        if (iconName != null && (icon = arc.getIcon(iconName)) != null) {
            this._renderIcon(context, arc, icon, destination, anchor, targetFrame, altTextKey, vAlign);
            return true;
        }
        return false;
    }

    protected String getDefaultStyleClass(FacesBean bean) {
        return "af|outputLabel";
    }

    private void _renderIcon(FacesContext context, RenderingContext arc, Icon icon, Object destination, Object anchor, Object targetFrame, String altTextKey, Object vAlign) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean renderedAnchor = false;
        if ((destination != null || anchor != null) && OutputLabelRenderer.supportsNavigation(arc)) {
            writer.startElement("a", null);
            this.renderEncodedActionURI(context, "href", destination);
            writer.writeAttribute("target", targetFrame, null);
            writer.writeAttribute("name", anchor, null);
            renderedAnchor = true;
        }
        String altText = arc.getTranslatedString(altTextKey);
        if (vAlign == null) {
            vAlign = OutputUtils.getMiddleIconAlignment(arc);
        }
        OutputUtils.renderIcon(context, arc, icon, altText, vAlign, renderedAnchor);
        if (renderedAnchor) {
            writer.endElement("a");
        }
    }

    private String _getMessageType(FacesContext context, FacesBean bean, String forId) throws IOException {
        FacesMessage message;
        String messageType = this.getMessageType(bean);
        if (null == messageType && (message = MessageUtils.getFacesMessage(context, forId)) != null) {
            messageType = MessageUtils.getMessageTypeFromSeverity(message.getSeverity());
        }
        return messageType;
    }

    protected boolean getShowRequired(FacesBean bean) {
        Object o = bean.getProperty(this._showRequiredKey);
        if (o == null) {
            o = this._showRequiredKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getDefaultValign(FacesBean bean) {
        return null;
    }

    protected char getAccessKey(FacesBean bean) {
        return OutputLabelRenderer.toChar((Object)bean.getProperty(this._accessKeyKey));
    }

    protected String getFor(FacesBean bean) {
        return OutputLabelRenderer.toString((Object)bean.getProperty(this._forKey));
    }

    protected String getForId(FacesContext context, UIComponent component, FacesBean bean) {
        String forValue = this.getFor(bean);
        if (forValue == null) {
            return null;
        }
        return MessageUtils.getClientIdFor(context, component, forValue);
    }

    protected String getMessageType(FacesBean bean) {
        if (this._messageTypeKey == null) {
            return null;
        }
        return OutputLabelRenderer.toString((Object)bean.getProperty(this._messageTypeKey));
    }

    protected String getMessageDescUrl(FacesBean bean) {
        return null;
    }

    protected String getMessageTargetFrame(FacesBean bean) {
        return null;
    }

    private boolean _shouldRenderMessageSymbol(RenderingContext arc, String messageType, boolean isInline, String forId) {
        if (null != messageType && !"none".equals(messageType) || forId != null && isInline) {
            Agent agent = arc.getAgent();
            return agent == null || !"blackberry".equals(agent.getAgentName()) || null != messageType && !"none".equals(messageType);
        }
        return false;
    }
}

