/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.Version;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IconNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.SkinPropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheetNode {
    private final List<StyleNode> _styles;
    private final List<IconNode> _icons;
    private List<SkinPropertyNode> _skinProperties;
    private final Set<Locale> _locales;
    private final int _direction;
    private final Map<Integer, Set<Version>> _agentVersions;
    private final Set<Integer> _platforms;
    private final int _mode;
    private final Set<String> _accProps;
    private final int _id;
    private static final int _ACC_EXACT_MATCH = 0x2000000;
    private static final int _ACC_UNKNOWN_MATCH = 0x1000000;
    private static final int _MODE_EXACT_MATCH = 0x200000;
    private static final int _MODE_UNKNOWN_MATCH = 0x100000;
    private static final int _LOCALE_EXACT_MATCH = 262144;
    private static final int _LOCALE_PARTIAL_MATCH = 131072;
    private static final int _LOCALE_UNKNOWN_MATCH = 65536;
    private static final int _DIRECTION_EXACT_MATCH = 8192;
    private static final int _DIRECTION_UNKNOWN_MATCH = 4096;
    private static final int _BROWSER_EXACT_MATCH = 512;
    private static final int _BROWSER_UNKNOWN_MATCH = 256;
    private static final int _VERSION_EXACT_MATCH = 32;
    private static final int _VERSION_UNKNOWN_MATCH = 32;
    private static final int _OS_EXACT_MATCH = 4;
    private static final int _OS_PARTIAL_MATCH = 2;
    private static final int _OS_UNKNOWN_MATCH = 1;
    private static final String _EMPTY_STRING = "\"\"";
    private static final int[] _UNIX_PLATFORMS = new int[]{3, 4};
    static final int __OS_UNIX = Integer.MAX_VALUE;

    public StyleSheetNode(StyleNode[] styles, Collection<IconNode> icons, Collection<SkinPropertyNode> skinProperties, Locale[] locales, int direction, Map<Integer, Set<Version>> agentVersions, int[] platforms, int mode, Set<String> accessibilityProperties) {
        this._styles = styles != null ? Collections.unmodifiableList(Arrays.asList(styles)) : Collections.emptyList();
        this._icons = icons != null ? Collections.unmodifiableList(new ArrayList<IconNode>(icons)) : Collections.emptyList();
        this._skinProperties = skinProperties != null ? Collections.unmodifiableList(new ArrayList<SkinPropertyNode>(skinProperties)) : Collections.emptyList();
        if (locales != null) {
            Set<Locale> localesSet = StyleSheetNode._copyLocaleArrayToSet(locales);
            this._locales = Collections.unmodifiableSet(localesSet);
        } else {
            this._locales = Collections.emptySet();
        }
        this._agentVersions = agentVersions != null ? Collections.unmodifiableMap(agentVersions) : Collections.emptyMap();
        if (platforms != null) {
            Set<Integer> platformsSet = StyleSheetNode._copyIntArrayToSet(platforms);
            this._platforms = Collections.unmodifiableSet(platformsSet);
        } else {
            this._platforms = Collections.emptySet();
        }
        if (accessibilityProperties != null) {
            Set<String> accPropsSet = StyleSheetNode._copyAccessibilityProperties(accessibilityProperties);
            this._accProps = Collections.unmodifiableSet(accPropsSet);
        } else {
            this._accProps = Collections.emptySet();
        }
        this._mode = mode;
        this._direction = direction;
        this._id = this._computeStyleSheetId();
    }

    public Collection<StyleNode> getStyles() {
        return this._styles;
    }

    public Collection<IconNode> getIcons() {
        return this._icons;
    }

    public Collection<SkinPropertyNode> getSkinProperties() {
        return this._skinProperties;
    }

    public int getReadingDirection() {
        return this._direction;
    }

    public int getMode() {
        return this._mode;
    }

    public Collection<Locale> getLocales() {
        return this._locales;
    }

    public Map<Integer, Set<Version>> getAgentVersions() {
        return this._agentVersions;
    }

    public Collection<Integer> getPlatforms() {
        return this._platforms;
    }

    public Collection<String> getAccessibilityProperties() {
        return this._accProps;
    }

    public int compareVariants(Locale locale, int direction, TrinidadAgent agent, int mode, AccessibilityProfile accessibilityProfile) {
        int localeMatch = this._compareLocale(locale);
        if (localeMatch == 0) {
            return 0;
        }
        int directionMatch = this._compareDirection(direction);
        if (directionMatch == 0) {
            return 0;
        }
        int browser = agent.getAgentApplication();
        int browserAndVersionMatch = this._compareBrowserAndVersion(browser, agent);
        if (browserAndVersionMatch == 0) {
            return 0;
        }
        int modeMatch = this._compareMode(mode);
        if (modeMatch == 0) {
            return 0;
        }
        int osMatch = this._compareOS(agent.getAgentOS());
        if (osMatch == 0) {
            return 0;
        }
        int accessibilityMatch = this._compareAccessibility(accessibilityProfile);
        if (accessibilityMatch == 0) {
            return 0;
        }
        return localeMatch | browserAndVersionMatch | osMatch | accessibilityMatch;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[" + "locales=" + (this._locales != null ? this._locales.toString() : "") + ", " + "direction=" + this._getDirectionString() + ", " + "agentVersions=" + (this._agentVersions != null ? this._agentVersions.toString() : "") + ", " + "platforms=" + (this._platforms != null ? this._platforms.toString() : "") + ", " + "styles=" + (this._styles != null ? this._styles.toString() : "") + ", " + "icons=" + (this._icons != null ? this._icons.toString() : "") + ", " + "accessibility-profile=" + (this._accProps != null ? this._accProps.toString() : "") + "]";
    }

    public int getStyleSheetId() {
        return this._id;
    }

    private int _computeStyleSheetId() {
        int hash = 17;
        hash = 37 * hash + this._mode;
        hash = 37 * hash + this._direction;
        hash = 37 * hash + ((Object)this._locales).hashCode();
        hash = 37 * hash + ((Object)this._agentVersions).hashCode();
        hash = 37 * hash + ((Object)this._platforms).hashCode();
        hash = 37 * hash + ((Object)this._styles).hashCode();
        hash = 37 * hash + ((Object)this._accProps).hashCode();
        return hash;
    }

    private int _compareLocale(Locale locale) {
        if (this._locales.isEmpty()) {
            return 65536;
        }
        if (locale == null) {
            return 0;
        }
        int match = 0;
        for (Locale tmpLocale : this._locales) {
            if (!tmpLocale.getLanguage().equals(locale.getLanguage())) continue;
            if (tmpLocale.getCountry().equals(locale.getCountry())) {
                match = 262144;
                break;
            }
            match = 131072;
        }
        return match;
    }

    private int _compareDirection(int direction) {
        if (this._direction == 0) {
            return 4096;
        }
        if (direction == this._direction) {
            return 8192;
        }
        return 0;
    }

    private int _compareMode(int mode) {
        if (this._mode == 0) {
            return 0x100000;
        }
        if (mode == this._mode) {
            return 0x200000;
        }
        return 0;
    }

    private int _compareBrowserAndVersion(int browser, TrinidadAgent agent) {
        if (this._agentVersions.isEmpty()) {
            return 256;
        }
        if (browser == 0) {
            return 0;
        }
        Integer browserNum = browser;
        if (this._agentVersions.containsKey(browserNum)) {
            Set<Version> versions = this._agentVersions.get(browserNum);
            if (versions.isEmpty()) {
                return 544;
            }
            Version version = new Version(agent.getAgentVersion());
            for (Version av : versions) {
                if (av.compareTo(version) != 0) continue;
                return 544;
            }
            return 0;
        }
        return 0;
    }

    private int _compareOS(int os) {
        if (this._platforms.isEmpty()) {
            return 1;
        }
        if (os == 0) {
            return 0;
        }
        if (this._platforms.contains(os)) {
            return 4;
        }
        if (StyleSheetNode._isUnixPlatform(os) && this._platforms.contains(Integer.MAX_VALUE)) {
            return 2;
        }
        return 0;
    }

    private int _compareAccessibility(AccessibilityProfile accProfile) {
        if (this._accProps.isEmpty()) {
            return 0x1000000;
        }
        for (String accProp : this._accProps) {
            if (!(this._isCompoundAccessibilityProperty(accProp) ? this._matchCompoundAccessibilityProperty(accProp, accProfile) : this._matchAccessibilityProperty(accProp, accProfile))) continue;
            return 0x2000000;
        }
        return 0;
    }

    private boolean _isCompoundAccessibilityProperty(String propertyName) {
        return propertyName.contains("&");
    }

    private boolean _matchCompoundAccessibilityProperty(String propertyName, AccessibilityProfile accProfile) {
        StringTokenizer tokens = new StringTokenizer(propertyName, "&");
        while (tokens.hasMoreTokens()) {
            if (this._matchAccessibilityProperty(tokens.nextToken(), accProfile)) continue;
            return false;
        }
        return true;
    }

    private boolean _matchAccessibilityProperty(String propertyName, AccessibilityProfile accProfile) {
        if ("high-contrast".equals(propertyName)) {
            return accProfile.isHighContrast();
        }
        if ("large-fonts".equals(propertyName)) {
            return accProfile.isLargeFonts();
        }
        assert (false);
        return false;
    }

    private String _getDirectionString() {
        if (this._direction == 0) {
            return _EMPTY_STRING;
        }
        return NameUtils.getDirectionName(this._direction);
    }

    private static boolean _containsInt(int n, int[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != n) continue;
            return true;
        }
        return false;
    }

    private static Set<Integer> _copyIntArrayToSet(int[] array) {
        int arrayCount = array != null ? array.length : 0;
        HashSet<Integer> set = new HashSet<Integer>(arrayCount);
        for (int i = 0; i < arrayCount; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    private static Set<Locale> _copyLocaleArrayToSet(Locale[] array) {
        int arrayCount = array != null ? array.length : 0;
        HashSet<Locale> set = new HashSet<Locale>(arrayCount);
        for (int i = 0; i < arrayCount; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    private static Set<String> _copyAccessibilityProperties(Set<String> accProps) {
        return new HashSet<String>(accProps);
    }

    private static boolean _isUnixPlatform(int os) {
        return StyleSheetNode._containsInt(os, _UNIX_PLATFORMS);
    }
}

