/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormInputRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.util.MessageUtils;

public abstract class InputLabelAndMessageRenderer
extends LabelAndMessageRenderer {
    private PropertyKey _simpleKey;
    private PropertyKey _disabledKey;
    private PropertyKey _readOnlyKey;

    protected InputLabelAndMessageRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._simpleKey = type.findKey("simple");
        this._disabledKey = type.findKey("disabled");
        this._readOnlyKey = type.findKey("readOnly");
    }

    public void decode(FacesContext context, UIComponent component) {
        this.getFormInputRenderer().decode(context, component);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        return this.getFormInputRenderer().getConvertedValue(context, component, submittedValue);
    }

    protected String getLabelFor(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) {
        if (!this.getFormInputRenderer().renderAsElement(context, arc, bean)) {
            return null;
        }
        return InputLabelAndMessageRenderer.__getCachedClientId(arc);
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (this.getSimple(bean)) {
            FacesMessage msg;
            String clientId = component.getClientId(context);
            if (this.isLeafRenderer() && this.canSkipRendering(arc, clientId)) {
                return;
            }
            String saved = arc.getCurrentClientId();
            arc.setCurrentClientId(clientId);
            String value = this.getLabel(bean);
            FormData fd = arc.getFormData();
            if (fd != null) {
                fd.addLabel(clientId, value);
            }
            if ((msg = MessageUtils.getFacesMessage(context, clientId)) != null) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("a", null);
                String anchor = MessageUtils.getAnchor(clientId);
                writer.writeAttribute("name", (Object)anchor, null);
                writer.endElement("a");
            }
            this.delegateRenderer(context, arc, component, bean, this.getFormInputRenderer());
            arc.setCurrentClientId(saved);
        } else {
            super.encodeAll(context, arc, component, bean);
        }
    }

    protected boolean isContentEditable(FacesBean bean) {
        return !this.getFormInputRenderer().getReadOnly(FacesContext.getCurrentInstance(), bean);
    }

    protected void renderFieldCellContents(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        this.delegateRenderer(context, arc, component, bean, this.getFormInputRenderer());
    }

    protected boolean getSimple(FacesBean bean) {
        Object o = bean.getProperty(this._simpleKey);
        if (o == null) {
            o = this._simpleKey.getDefault();
        }
        return !Boolean.FALSE.equals(o);
    }

    protected void renderRootDomElementStyles(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        List<String> parsedStyleClasses;
        String styleClass = this.getStyleClass(bean);
        String contentStyleClass = this.getRootStyleClass(bean);
        String disabledStyleClass = null;
        String readOnlyStyleClass = null;
        String requiredStyleClass = null;
        if (this.isReadOnly(bean)) {
            readOnlyStyleClass = "p_AFReadOnly";
        } else if (this.isDisabled(bean)) {
            disabledStyleClass = "p_AFDisabled";
        }
        if (this.labelShowRequired(bean)) {
            requiredStyleClass = "p_AFRequired";
        }
        int userStyleClassCount = (parsedStyleClasses = OutputUtils.parseStyleClassList(styleClass)) == null ? (styleClass == null ? 0 : 1) : parsedStyleClasses.size();
        String[] styleClasses = new String[userStyleClassCount + 4];
        if (parsedStyleClasses != null) {
            for (int i = 0; i < userStyleClassCount; ++i) {
                styleClasses[i] = parsedStyleClasses.get(i);
            }
        } else if (styleClass != null) {
            styleClasses[i++] = styleClass;
        }
        styleClasses[i++] = contentStyleClass;
        styleClasses[i++] = disabledStyleClass;
        styleClasses[i++] = readOnlyStyleClass;
        styleClasses[i++] = requiredStyleClass;
        InputLabelAndMessageRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])styleClasses);
        this.renderInlineStyle(context, arc, bean);
    }

    protected boolean isDisabled(FacesBean bean) {
        Object o = bean.getProperty(this._disabledKey);
        if (o == null) {
            o = this._disabledKey.getDefault();
        }
        return !Boolean.FALSE.equals(o);
    }

    protected boolean isReadOnly(FacesBean bean) {
        Object o = bean.getProperty(this._readOnlyKey);
        if (o == null) {
            o = this._readOnlyKey.getDefault();
        }
        return !Boolean.FALSE.equals(o);
    }

    protected abstract FormInputRenderer getFormInputRenderer();
}

