/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.trinidad.component.UIXTreeTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;

public final class ColumnData {
    public static final int TEXT_FORMAT = 0;
    public static final int NUMBER_FORMAT = 1;
    public static final int ICON_FORMAT = 2;
    public static final int SPECIAL_COLUMN_INDEX = -1;
    private boolean _isColumnGroupHeader = false;
    private String _currHeaderID = null;
    private boolean _currHeaderNoWrap = false;
    private int _headerRowSpan = 1;
    private int _physicalColumn = -1;
    private int _logicalColumn = -1;
    private int _colCount = 0;
    private int _firstFooterPhysicalColumn = -1;
    private int _objectNameColumn = 0;
    private int _rowIndex = -1;
    private final Dimension _currentSpan = new Dimension(1, 1);
    private final List<Data> _data = new ArrayList<Data>(10);
    private boolean _assertInitMode = true;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ColumnData.class);

    public int getRowIndex() {
        return this._rowIndex;
    }

    public void setRowIndex(int index) {
        this._rowIndex = index;
    }

    public int getColumnCount() {
        return this._colCount;
    }

    public void setColumnCount(int columns) {
        this._colCount = columns;
    }

    public int getObjectNameColumnIndex() {
        return this._objectNameColumn;
    }

    public int getPhysicalIndexOfFirstFooter() {
        return this._firstFooterPhysicalColumn;
    }

    public void setCurrentColumnHasFooter() {
        if (this._firstFooterPhysicalColumn == -1 || this._physicalColumn < this._firstFooterPhysicalColumn) {
            this._firstFooterPhysicalColumn = this._physicalColumn;
        }
    }

    public int getPhysicalColumnIndex() {
        return this._physicalColumn;
    }

    public int getLogicalColumnIndex() {
        return this._logicalColumn;
    }

    public void setColumnIndex(int physical, int logical) {
        this._physicalColumn = physical;
        this._logicalColumn = logical;
    }

    public void incrementColumnIndex() {
        ++this._physicalColumn;
        ++this._logicalColumn;
    }

    public void setCurrentSpan(int rowSpan, int colSpan) {
        this._currentSpan.width = colSpan;
        this._currentSpan.height = rowSpan;
    }

    public Dimension getCurrentSpan() {
        return this._currentSpan;
    }

    public int getHeaderRowSpan() {
        assert (this._assertInitModeOff());
        return this._headerRowSpan;
    }

    public void setHeaderRowSpan(int span) {
        assert (this._assertInitMode);
        if (span > this._headerRowSpan) {
            this._headerRowSpan = span;
        }
    }

    public String getHeaderIDs(int physicalIndex) {
        return this._get((int)physicalIndex).headerIDs;
    }

    public String getHeaderID(int physicalIndex) {
        return this._get((int)physicalIndex).headerID;
    }

    public void setHeaderID(int physicalIndex, String headerID) {
        this._get((int)physicalIndex).headerID = headerID;
    }

    public void setHeaderIDs(int physicalIndex, String headerIDs) {
        this._get((int)physicalIndex).headerIDs = headerIDs;
    }

    public void setCurrentHeaderID(String id) {
        this._currHeaderID = id;
    }

    public String getCurrentHeaderID() {
        return this._currHeaderID;
    }

    public void setCurrentHeaderNoWrap(boolean isNoWrap) {
        this._currHeaderNoWrap = isNoWrap;
    }

    public boolean getCurrentHeaderNoWrap() {
        return this._currHeaderNoWrap;
    }

    public boolean useSeparateRows(int physicalIndex) {
        return this._get((int)physicalIndex).useSeparateRows;
    }

    public boolean isRowHeader(int physicalIndex) {
        return this._get((int)physicalIndex).isRowHeader;
    }

    public void setColumnData(Object width, Object align, boolean noWrap, boolean headerNoWrap, boolean separateRows, boolean rowHeader) {
        assert (this._assertInitMode);
        int physicalIndex = this.getPhysicalColumnIndex();
        Data d = this._create(physicalIndex);
        this._setWidth(d, width);
        this._setDataFormat(d, align);
        d.noWrap = noWrap;
        d.headerNoWrap = headerNoWrap;
        d.useSeparateRows = separateRows;
        d.isRowHeader = rowHeader;
    }

    public void setSpecialColumnData(TableRenderingContext tContext, RenderingContext arc, boolean noWrap, boolean allowHeaderWrap, String formatType) {
        assert (this._assertInitMode);
        int physicalIndex = this.getPhysicalColumnIndex();
        Data d = this._create(physicalIndex);
        d.headerNoWrap = !allowHeaderWrap;
        d.noWrap = noWrap;
        this._setDataFormat(d, formatType);
        d.width = ColumnData._getSpecialWidth(tContext, arc);
    }

    public Object getWidth(int physicalIndex) {
        assert (this._assertInitModeOff());
        return this._get((int)physicalIndex).width;
    }

    private int _getDataFormat(int physicalIndex) {
        assert (this._assertInitModeOff());
        return this._get((int)physicalIndex).dataFormat;
    }

    public boolean getNoWrap(int physicalIndex) {
        assert (this._assertInitModeOff());
        return this._get((int)physicalIndex).noWrap;
    }

    public boolean getHeaderNoWrap(int physicalIndex) {
        assert (this._assertInitModeOff());
        return this._get((int)physicalIndex).headerNoWrap;
    }

    public boolean isColumnGroupHeader() {
        return this._isColumnGroupHeader;
    }

    public void setColumnGroupHeader(boolean isColumnGroupHeader) {
        this._isColumnGroupHeader = isColumnGroupHeader;
    }

    private void _setWidth(Data data, Object width) {
        if (width != null) {
            data.width = width;
        }
    }

    public void setDataFormat(int physicalIndex, Object format) {
        this._setDataFormat(this._get(physicalIndex), format);
    }

    private void _setDataFormat(Data data, Object format) {
        if (format != null && !"start".equals(format) && !"left".equals(format)) {
            if ("end".equals(format) || "right".equals(format)) {
                data.dataFormat = 1;
            } else if ("center".equals(format)) {
                data.dataFormat = 2;
            } else {
                _LOG.warning("UNKNOWN_VALUE_FOR_ALIGN", format);
            }
        }
    }

    private Data _get(int physicalIndex) {
        Data d = this._data.get(physicalIndex);
        assert (d != null) : "no column data for physicalIndex:" + physicalIndex;
        return d;
    }

    private Data _create(int physicalIndex) {
        Data d;
        int sz = this._data.size();
        if (physicalIndex < sz) {
            d = this._get(physicalIndex);
        } else {
            assert (physicalIndex == sz) : "physicalIndex:" + physicalIndex + ",size:" + sz;
            d = new Data();
            this._data.add(d);
        }
        return d;
    }

    private boolean _assertInitModeOff() {
        this._assertInitMode = false;
        return true;
    }

    public static String selectFormat(TableRenderingContext tContext, String textClass, String numberClass, String iconClass) {
        ColumnData colData = tContext.getColumnData();
        int dataFormat = colData._getDataFormat(colData.getPhysicalColumnIndex());
        switch (dataFormat) {
            case 1: {
                return numberClass;
            }
            case 2: {
                return iconClass;
            }
        }
        return textClass;
    }

    private static Object _getSpecialWidth(TableRenderingContext tContext, RenderingContext arc) {
        if (tContext.getTable() instanceof UIXTreeTable) {
            return XhtmlRenderer.isIE((RenderingContext)arc) ? "1" : "1%";
        }
        return "1%";
    }

    private static final class Data {
        public int dataFormat = 0;
        public Object width = null;
        public boolean useSeparateRows = false;
        public boolean isRowHeader = false;
        public boolean noWrap = false;
        public boolean headerNoWrap = false;
        public String headerIDs = null;
        public String headerID = null;

        private Data() {
        }
    }
}

