/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.share.expl.ExpressionParser;
import org.apache.myfaces.trinidadinternal.share.expl.Function;
import org.apache.myfaces.trinidadinternal.share.util.NamespaceMap;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.ParserExtension;
import org.apache.myfaces.trinidadinternal.share.xml.ParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserManager
implements Cloneable {
    private NamespaceMap _functions = new NamespaceMap();
    private NamespaceMap _factories = new NamespaceMap();
    private ArrayMap<String, ParserExtension> _extensions = new ArrayMap(5);
    private ArrayMap<String, String> _aliases = new ArrayMap(5);
    private ArrayMap<String, ExpressionParser> _bindingParsers = new ArrayMap(2);
    private ExpressionParser _defaultExpressionParser = null;
    private boolean _sharedState = false;
    private static final ParserManager _sDefaultInstance = new ParserManager();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ParserManager.class);

    public static ParserManager getDefaultParserManager() {
        return _sDefaultInstance;
    }

    public final NodeParser getParser(ParseContext context, Class<?> expectedType, String namespaceURI, String localName) {
        ParserFactory factory = this.getFactory(expectedType, namespaceURI);
        if (factory == null) {
            return null;
        }
        return factory.getParser(context, namespaceURI, localName);
    }

    public ParserFactory getFactory(Class<?> expectedType, String namespaceURI) {
        return (ParserFactory)this._factories.get(this.resolveNamespaceAlias(namespaceURI), expectedType);
    }

    public synchronized void registerFactory(Class<?> expectedType, String namespaceURI, ParserFactory factory) {
        this._unshareState();
        this._factories.put(this.resolveNamespaceAlias(namespaceURI), expectedType, factory);
    }

    public synchronized void unregisterFactory(Class<?> expectedType, String namespaceURI) {
        this._unshareState();
        this._factories.remove(this.resolveNamespaceAlias(namespaceURI), expectedType);
    }

    public ParserExtension getExtension(String namespaceURI) {
        return (ParserExtension)this._extensions.get((Object)this.resolveNamespaceAlias(namespaceURI));
    }

    public synchronized void registerExtension(String namespaceURI, ParserExtension extension) {
        this._unshareState();
        this._extensions.put((Object)this.resolveNamespaceAlias(namespaceURI), (Object)extension);
    }

    public synchronized void unregisterExtension(String namespaceURI) {
        this._unshareState();
        this._extensions.remove((Object)this.resolveNamespaceAlias(namespaceURI));
    }

    public synchronized void registerNamespaceAlias(String mainNamespaceURI, String aliasURI) {
        this._unshareState();
        this._aliases.put((Object)aliasURI, (Object)mainNamespaceURI);
    }

    public String resolveNamespaceAlias(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        Object o = this._aliases.get((Object)namespaceURI);
        if (o == null) {
            return namespaceURI;
        }
        return (String)o;
    }

    public final ExpressionParser getExpressionParser(String name) {
        return name == null ? this._defaultExpressionParser : (ExpressionParser)this._bindingParsers.get((Object)name);
    }

    public final synchronized void registerExpressionParser(ExpressionParser bindingParser) {
        this._unshareState();
        this._bindingParsers.put((Object)bindingParser.getName(), (Object)bindingParser);
    }

    public final void setDefaultExpressionParser(ExpressionParser parser) {
        if (parser == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_PARSER"));
        }
        this._defaultExpressionParser = parser;
    }

    public final Function getFunction(String namespace, String name) {
        return (Function)this._functions.get(namespace, name);
    }

    public final synchronized void registerFunction(String namespace, String name, Function method) {
        this._unshareState();
        this._functions.put(namespace, name, method);
    }

    public synchronized Object clone() {
        try {
            this._sharedState = true;
            ParserManager pm = (ParserManager)super.clone();
            return pm;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    private synchronized void _unshareState() {
        if (this._sharedState) {
            this._functions = (NamespaceMap)this._functions.clone();
            this._factories = (NamespaceMap)this._factories.clone();
            this._extensions = (ArrayMap)this._extensions.clone();
            this._aliases = (ArrayMap)this._aliases.clone();
            this._bindingParsers = (ArrayMap)this._bindingParsers.clone();
            this._sharedState = false;
        }
    }
}

