/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.XhtmlScriptletFactory;
import org.apache.myfaces.trinidadinternal.share.util.FastMessageFormat;

public class XhtmlUtils {
    public static final String CORE_LIB = "Core";
    private static final Object _CLIENT_BEHAVIORS_KEY = new Object();
    private static Map<Object, Scriptlet> _sScriptletTable = Collections.synchronizedMap(new HashMap(37));
    private static final Object _PORTLET_LIB_TABLE_KEY = new Object();
    private static final Set<String> _NON_STRUCTURAL_COMPONENT_FAMILIES = new HashSet<String>();
    private static final TrinidadLogger _LOG;

    public static UIComponent getStructuralParent(UIComponent component) {
        do {
            if ((component = component.getParent()) != null) continue;
            return null;
        } while (_NON_STRUCTURAL_COMPONENT_FAMILIES.contains(component.getFamily()));
        return component;
    }

    public static final boolean supportsSeparateWindow(Agent agent) {
        return Boolean.TRUE.equals(agent.getCapabilities().get(TrinidadAgent.CAP_MULTIPLE_WINDOWS)) && Boolean.TRUE.equals(agent.getCapabilities().get(TrinidadAgent.CAP_PARTIAL_RENDERING));
    }

    public static String getCompositeId(String baseid, String suffix) {
        int length = baseid.length() + "__xc_".length();
        if (suffix != null) {
            length += suffix.length();
        }
        StringBuilder compID = new StringBuilder(length);
        compID.append(baseid);
        compID.append("__xc_");
        if (suffix != null) {
            compID.append(suffix);
        }
        return compID.toString();
    }

    public static void registerScriptlet(Object key, Scriptlet scriptlet) {
        _sScriptletTable.put(key, scriptlet);
    }

    public static void addLib(FacesContext context, RenderingContext rc, Object libKey) throws IOException {
        if (XhtmlRenderer.supportsScripting(rc) && libKey != null) {
            Scriptlet scriptlet = _sScriptletTable.get(libKey);
            if (scriptlet == null) {
                if (_LOG.isWarning()) {
                    _LOG.warning("CANNOT_FIND_SCRIPTLET", libKey);
                }
            } else {
                scriptlet.outputScriptlet(context, rc);
            }
        }
    }

    public static void writeLibImport(FacesContext context, RenderingContext rc, Object libURL) throws IOException {
        Map props = rc.getProperties();
        if (props.containsKey(libURL)) {
            return;
        }
        props.put(libURL, Boolean.TRUE);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        XhtmlRenderer.renderScriptDeferAttribute(context, rc);
        XhtmlRenderer.renderScriptTypeAttribute(context, rc);
        libURL = context.getExternalContext().encodeResourceURL(libURL.toString());
        writer.writeURIAttribute("src", libURL, null);
        writer.endElement("script");
    }

    public static String getChainedJS(String evh1, String evh2, boolean shortCircuit) {
        if (evh1 == null) {
            return evh2;
        }
        if (evh2 == null) {
            return evh1;
        }
        int evh1Length = evh1.length();
        if (evh1Length == 0) {
            return evh2;
        }
        int evh2Length = evh2.length();
        if (evh2Length == 0) {
            return evh1;
        }
        StringBuilder outBuilder = new StringBuilder(15 + evh1Length * 2 + 3 + evh2Length * 2 + 18);
        outBuilder.append("return _chain('");
        XhtmlUtils._escapeSingleQuotes(outBuilder, evh1);
        outBuilder.append("','");
        XhtmlUtils._escapeSingleQuotes(outBuilder, evh2);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        boolean isDesktop = arc.getAgent().getType().equals(Agent.TYPE_DESKTOP);
        if (isDesktop) {
            if (shortCircuit) {
                outBuilder.append("',this,event,true)");
            } else {
                outBuilder.append("',this,event)");
            }
        } else if (shortCircuit) {
            outBuilder.append("',this,null,true)");
        } else {
            outBuilder.append("',this,null)");
        }
        return outBuilder.toString();
    }

    public static String getChainedJS(boolean shortCircuit, String ... scripts) {
        if (scripts.length == 0) {
            return null;
        }
        if (scripts.length <= 2) {
            return XhtmlUtils.getChainedJS(scripts[0], scripts.length == 2 ? scripts[1] : null, shortCircuit);
        }
        StringBuilder builder = new StringBuilder(100);
        builder.append("return _chainMultiple([");
        int firstNonNullScript = -1;
        int numScripts = 0;
        int size = scripts.length;
        for (int i = 0; i < size; ++i) {
            String script = scripts[i];
            if (script == null || (script = script.trim()).length() == 0) continue;
            ++numScripts;
            if (firstNonNullScript == -1) {
                builder.append('\'');
                firstNonNullScript = i;
            } else {
                builder.append(",'");
            }
            XhtmlUtils.escapeJS(builder, script, true);
            builder.append('\'');
        }
        if (numScripts == 0) {
            return null;
        }
        if (numScripts == 1) {
            return scripts[firstNonNullScript];
        }
        RenderingContext rc = RenderingContext.getCurrentInstance();
        if (rc.getAgent().getType().equals(Agent.TYPE_DESKTOP)) {
            if (shortCircuit) {
                builder.append("],this,event,true);");
            } else {
                builder.append("],this,event);");
            }
        } else if (shortCircuit) {
            builder.append("],this,null,true);");
        } else {
            builder.append("],this,null);");
        }
        return builder.toString();
    }

    public static String escapeJS(String inString) {
        return XhtmlUtils.escapeJS(inString, false);
    }

    public static String escapeJS(String inString, boolean inQuotes) {
        int charCount = inString.length();
        StringBuilder outBuilder = new StringBuilder(charCount * 2);
        XhtmlUtils.escapeJS(outBuilder, inString, inQuotes);
        if (charCount != outBuilder.length()) {
            return outBuilder.toString();
        }
        return inString;
    }

    public static void escapeJS(StringBuilder outBuilder, String inString) {
        XhtmlUtils.escapeJS(outBuilder, inString, false);
    }

    public static void escapeJS(StringBuilder outBuilder, String inString, boolean inQuotes) {
        XhtmlUtils.escapeJS(outBuilder, inString, inQuotes, 1);
    }

    public static void escapeJS(StringBuilder outBuilder, String inString, boolean inQuotes, int escapeCount) {
        int leadSlashCount = (int)Math.pow(2.0, escapeCount) - 2;
        int charCount = inString.length();
        int prevChar = 0;
        for (int i = 0; i < charCount; ++i) {
            char currChar = inString.charAt(i);
            if (currChar == '\'') {
                if (!inQuotes || prevChar != 92) {
                    inQuotes = !inQuotes;
                }
                for (int j = 0; j < leadSlashCount; ++j) {
                    outBuilder.append('\\');
                }
                outBuilder.append('\\');
                outBuilder.append(currChar);
            } else if (inQuotes) {
                if (currChar > '\u00ff') {
                    outBuilder.append("\\u");
                    XhtmlUtils._appendHexString(outBuilder, currChar, 4);
                } else if (currChar > '\u001f' && currChar < '\u0080') {
                    if (currChar == '\\') {
                        outBuilder.append('\\');
                    }
                    outBuilder.append(currChar);
                } else {
                    outBuilder.append("\\x");
                    XhtmlUtils._appendHexString(outBuilder, currChar, 2);
                }
            } else {
                if (currChar == '\\') {
                    outBuilder.append('\\');
                }
                outBuilder.append(currChar);
            }
            prevChar = currChar;
        }
    }

    private static void _appendHexString(StringBuilder builder, int number, int minDigits) {
        String hexString = Integer.toHexString(number);
        int hexLength = hexString.length();
        int zeroPadding = minDigits - hexLength;
        if (zeroPadding > 0) {
            builder.append('0');
            while (zeroPadding > 1) {
                builder.append('0');
                --zeroPadding;
            }
        } else if (zeroPadding < 0) {
            throw new IllegalArgumentException();
        }
        builder.append(hexString);
    }

    private static void _escapeSingleQuotes(StringBuilder outBuilder, String inString) {
        int charCount = inString.length();
        int prevChar = 0;
        boolean inQuotes = false;
        for (int i = 0; i < charCount; ++i) {
            char currChar = inString.charAt(i);
            if (currChar == '\'') {
                if (!inQuotes || prevChar != 92) {
                    inQuotes = !inQuotes;
                }
                outBuilder.append('\\');
            } else if (currChar == '\\' && inQuotes) {
                outBuilder.append('\\');
            }
            outBuilder.append(currChar);
            prevChar = currChar;
        }
    }

    public static String getJSIdentifier(String clientId) {
        if (clientId == null) {
            return null;
        }
        return clientId.replace(':', '_');
    }

    public static String getFormattedString(String pattern, String[] parameters) {
        FastMessageFormat formatter = new FastMessageFormat(pattern);
        return formatter.format(parameters);
    }

    public static String getEncodedParameter(String param) {
        return param + "_parameterkey";
    }

    public static String getEncodedNameAttribute(String[] param) {
        int noOfParam = param.length;
        int bufferLen = 0;
        for (int i = 0; i < noOfParam; ++i) {
            bufferLen += param[i].length();
        }
        StringBuilder nameAttri = new StringBuilder(bufferLen += (noOfParam - 1) * "_parameterkey".length());
        for (int i = 0; i < noOfParam - 1; ++i) {
            nameAttri.append(XhtmlUtils.getEncodedParameter(param[i]));
        }
        nameAttri.append(param[noOfParam - 1]);
        return nameAttri.toString();
    }

    public static String getClientEventHandler(FacesContext facesContext, UIComponent component, String eventName, String secondaryEventName, String userHandlerScript, String eventHandlerScript) {
        boolean hasBehaviors;
        BehaviorsData data = null;
        if (component instanceof ClientBehaviorHolder) {
            data = new BehaviorsData();
            XhtmlUtils._getBehaviorScripts(facesContext, component, eventName, data);
            if (secondaryEventName != null) {
                XhtmlUtils._getBehaviorScripts(facesContext, component, secondaryEventName, data);
            }
        }
        boolean hasHandler = eventHandlerScript != null && eventHandlerScript.length() > 0;
        boolean hasUserHandler = userHandlerScript != null && userHandlerScript.length() > 0;
        String script = null;
        boolean bl = hasBehaviors = data != null && data.behaviorScripts != null && !data.behaviorScripts.isEmpty();
        if (hasHandler && !hasBehaviors && !hasUserHandler) {
            script = eventHandlerScript;
        } else if (hasUserHandler && !hasBehaviors && !hasHandler) {
            script = userHandlerScript;
        } else if (!hasUserHandler && !hasHandler && hasBehaviors && data.behaviorScripts.size() == 1) {
            script = data.behaviorScripts.get(0);
        } else {
            int numBehaviorScripts;
            int length = numBehaviorScripts = hasBehaviors ? data.behaviorScripts.size() : 0;
            if (hasHandler) {
                ++length;
            }
            if (hasUserHandler) {
                ++length;
            }
            String[] scripts = new String[length];
            int index = 0;
            if (hasUserHandler) {
                scripts[0] = userHandlerScript;
                index = 1;
            }
            if (hasBehaviors) {
                System.arraycopy(data.behaviorScripts.toArray(), 0, scripts, index, numBehaviorScripts);
                index += numBehaviorScripts;
            }
            if (hasHandler) {
                scripts[index] = eventHandlerScript;
            }
            script = XhtmlUtils.getChainedJS(true, scripts);
        }
        return script;
    }

    private static void _getBehaviorScripts(FacesContext facesContext, UIComponent component, String eventName, BehaviorsData data) {
        ClientBehaviorHolder behaviorHolder = (ClientBehaviorHolder)component;
        List behaviors = (List)behaviorHolder.getClientBehaviors().get(eventName);
        if (behaviors != null && !behaviors.isEmpty()) {
            if (data.params == null && XhtmlUtils._hasSubmittingBehavior(behaviors)) {
                data.params = CoreRenderer.getBehaviorParameters((UIComponent)component);
            }
            ClientBehaviorContext behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)component, (String)eventName, (String)component.getClientId(facesContext), data.params);
            if (data.behaviorScripts == null) {
                data.behaviorScripts = new ArrayList<String>(behaviors.size());
            }
            for (ClientBehavior behavior : behaviors) {
                String behaviorScript = behavior.getScript(behaviorContext);
                if (data.params != null && behavior.getHints().contains(ClientBehaviorHint.SUBMITTING) && ("action".equals(eventName) || "click".equals(eventName))) {
                    behaviorScript = behaviorScript + ";return false";
                }
                data.behaviorScripts.add(behaviorScript);
            }
        }
    }

    private static boolean _hasSubmittingBehavior(Iterable<ClientBehavior> behaviors) {
        for (ClientBehavior behavior : behaviors) {
            if (!behavior.getHints().contains(ClientBehaviorHint.SUBMITTING)) continue;
            return true;
        }
        return false;
    }

    static {
        _NON_STRUCTURAL_COMPONENT_FAMILIES.add("org.apache.myfaces.trinidad.Iterator");
        _NON_STRUCTURAL_COMPONENT_FAMILIES.add("org.apache.myfaces.trinidad.ComponentRef");
        _NON_STRUCTURAL_COMPONENT_FAMILIES.add("org.apache.myfaces.trinidad.Subform");
        _NON_STRUCTURAL_COMPONENT_FAMILIES.add("org.apache.myfaces.trinidad.Switcher");
        XhtmlScriptletFactory.registerAllScriptlets();
        _LOG = TrinidadLogger.createTrinidadLogger(XhtmlUtils.class);
    }

    private static class BehaviorsData {
        Collection<ClientBehaviorContext.Parameter> params;
        List<String> behaviorScripts;

        private BehaviorsData() {
        }
    }
}

