/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;

public class PropertyTracker
implements Iterable<PropertyKey> {
    private long _propertiesMask = 0L;
    private FacesBean.Type _type;

    public PropertyTracker(FacesBean.Type type) {
        this._type = type;
    }

    public void addProperty(PropertyKey key) {
        int index = key.getIndex();
        this._checkIndex(index);
        this._propertiesMask |= 1L << index;
    }

    public void removeProperty(PropertyKey key) {
        int index = key.getIndex();
        this._checkIndex(index);
        long mask = 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
        this._propertiesMask &= mask;
    }

    @Override
    public Iterator<PropertyKey> iterator() {
        return new PropertyBitIterator();
    }

    private void _checkIndex(int index) {
        if (index < 0 || index >= 64) {
            throw new IllegalArgumentException("Only indexed properties may be tracked");
        }
    }

    private class PropertyBitIterator
    implements Iterator<PropertyKey> {
        private int _pos = 0;

        private PropertyBitIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this._pos >= 64) {
                return false;
            }
            return PropertyTracker.this._propertiesMask >= 1L << this._pos;
        }

        @Override
        public PropertyKey next() {
            while (this._pos < 64) {
                int current;
                ++this._pos;
                if ((PropertyTracker.this._propertiesMask & 1L << current) == 0L) continue;
                return PropertyTracker.this._type.findKey(current);
            }
            throw new NoSuchElementException();
        }
    }
}

