/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.context.ComponentContextManager;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.SuspendedContextChanges;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class UIXDocument
extends UIXComponentBase {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Document";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Document";
    private static final String _SUSPENDED_CHANGES_KEY = UIXDocument.class.getName() + ".SUSPENDED_CHANGES";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXDocument.class);

    public UIXDocument() {
        super("org.apache.myfaces.trinidad.Document");
    }

    @Override
    protected void setupVisitingContext(FacesContext facesContext) {
        ComponentContextManager ctxMgr = RequestContext.getCurrentInstance().getComponentContextManager();
        SuspendedContextChanges suspendedChanges = ctxMgr.suspend(facesContext);
        Map reqMap = facesContext.getExternalContext().getRequestMap();
        Queue<SuspendedContextChanges> suspendedChangesQueue = (Queue<SuspendedContextChanges>)reqMap.get(_SUSPENDED_CHANGES_KEY);
        if (suspendedChangesQueue == null) {
            suspendedChangesQueue = Collections.asLifoQueue(new ArrayDeque());
            reqMap.put(_SUSPENDED_CHANGES_KEY, suspendedChangesQueue);
        }
        suspendedChangesQueue.offer(suspendedChanges);
        _LOG.fine("UIXDocument suspended context changes in setupVisitingContext");
        super.setupVisitingContext(facesContext);
    }

    @Override
    protected void tearDownVisitingContext(FacesContext facesContext) {
        super.tearDownVisitingContext(facesContext);
        ComponentContextManager ctxMgr = RequestContext.getCurrentInstance().getComponentContextManager();
        Map reqMap = facesContext.getExternalContext().getRequestMap();
        Queue suspendedChangesQueue = (Queue)reqMap.get(_SUSPENDED_CHANGES_KEY);
        SuspendedContextChanges changes = (SuspendedContextChanges)suspendedChangesQueue.poll();
        ctxMgr.resume(facesContext, changes);
        _LOG.fine("UIXDocument resumed context changes in setupVisitingContext");
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.Document";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXDocument(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.Document", "org.apache.myfaces.trinidad.Document");
    }
}

